/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.dao;

import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.xdts.model.XdtsTimer;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.sql.SqlConditionParser;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.sql.model.SqlWhereElement;

public class XdtsTimerDAO
extends OrmAbstractDAO<XdtsTimer> {
    private XdtsTimerDAO() {
        super(new XdtsTimer[0]);
        this.setTableName("xdts_timer");
        this.setViewName(String.valueOf(this.tableName) + "__v1");
    }

    public static XdtsTimerDAO getInstance() {
        return SingletonHolder.instance;
    }

    public List<XdtsTimer> getTimerList(DtsSession dtsSession, Integer timerId, String timerName) throws Exception {
        SqlWhereElement whereElement;
        SqlContext sqlContext = dtsSession.getSqlContext();
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(null));
        selectQuery.setFromClause(String.valueOf(this.viewName) + " AS " + this.tableName);
        if (timerId != null) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("id = " + timerId);
            selectQuery.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(timerName)) {
            whereElement = SqlConditionParser.getInstance().parseCondition1(sqlContext, "name", timerName, null, false);
            selectQuery.addWhereElement(whereElement);
        }
        selectQuery.getOrderByList().add("name");
        String query = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, query);
    }

    public List<XdtsTimer> getTimerList(DtsSession dtsSession) throws Exception {
        return this.getTimerList(dtsSession, null, null);
    }

    public XdtsTimer getTimerFirst(DtsSession dtsSession, Integer timerId, String timerName) throws Exception {
        XdtsTimer timer = null;
        List<XdtsTimer> timerList = this.getTimerList(dtsSession, timerId, timerName);
        if (timerList.size() > 0) {
            timer = timerList.get(0);
        }
        return timer;
    }

    public XdtsTimer getTimer(DtsSession dtsSession, int timerId) throws Exception {
        return this.getTimerFirst(dtsSession, timerId, null);
    }

    public XdtsTimer getTimerByName(DtsSession dtsSession, String timerName) throws Exception {
        return this.getTimerFirst(dtsSession, -1, timerName);
    }

    /* synthetic */ XdtsTimerDAO(XdtsTimerDAO xdtsTimerDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final XdtsTimerDAO instance = new XdtsTimerDAO(null);

        private SingletonHolder() {
        }
    }
}

