/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.common;

import com.megginson.sax.DataWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.etc.model.EtcWord;
import jp.co.extreme.module.xdts.common.XdtsXmlUtil;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

class Z_XdtsWordXmlCreator {
    protected DataWriter dataWriter;
    protected int indentStep = XdtsXmlUtil.indentStep;
    Collection<EtcWord> wordCollection;
    File destFile;

    Z_XdtsWordXmlCreator() {
    }

    public void createXml(Collection<EtcWord> wordCollection, File destFile) throws Exception {
        this.wordCollection = wordCollection;
        this.destFile = destFile;
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(destFile));
        this.dataWriter = new DataWriter((Writer)new OutputStreamWriter(os));
        try {
            this.dataWriter.startDocument();
            this.dataWriter.setIndentStep(this.indentStep);
            this.dataWriter.startElement("words");
            this.createXml_L2();
            this.dataWriter.endElement("words");
            this.dataWriter.endDocument();
            this.dataWriter.flush();
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    protected void createXml_L2() throws Exception {
        Iterator<EtcWord> iterator = this.wordCollection.iterator();
        int cnt = 0;
        while (iterator.hasNext()) {
            if (++cnt % 100 == 0) {
                BcLogUtil.info("cnt=" + cnt);
            }
            EtcWord word = iterator.next();
            this.createXml_L3(word);
        }
    }

    protected void createXml_L3(EtcWord word) throws Exception {
        AttributesImpl aatLib1 = new AttributesImpl();
        aatLib1.addAttribute("", "code", "code", "CDATA", word.code);
        this.dataWriter.startElement("", "word", "word", (Attributes)aatLib1);
        AttributesImpl aatLib2 = new AttributesImpl();
        aatLib2.addAttribute("", "lang", "lang", "CDATA", word.lang);
        this.dataWriter.startElement("", "value", "value", (Attributes)aatLib2);
        if (!BcStringUtil.isEmpty(word.value)) {
            this.dataWriter.characters(word.value);
        }
        this.dataWriter.endElement("value");
        AttributesImpl aatLib3 = new AttributesImpl();
        aatLib3.addAttribute("", "lang", "lang", "CDATA", word.lang);
        this.dataWriter.startElement("", "note", "note", (Attributes)aatLib3);
        if (!BcStringUtil.isEmpty(word.note)) {
            this.dataWriter.characters(word.note);
        }
        this.dataWriter.endElement("note");
        this.dataWriter.endElement("word");
    }
}

