/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.wcb;

import com.squareup.square.Environment;
import com.squareup.square.exceptions.ApiException;
import java.io.BufferedReader;
import java.io.File;
import java.math.BigDecimal;
import java.util.List;
import javax.servlet.http.HttpSession;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.business.account.BsnAccountsUtil;
import jp.co.extreme.lib.html.mdl.MdlCreator;
import jp.co.extreme.lib.square.SquareUtil;
import jp.co.extreme.module.wbfw.common.WbfwUtil;
import jp.co.extreme.module.wbfw.container.WbfwWcbArgument;
import jp.co.extreme.module.wbs1.wcb.Wbs1AbstractWCB;
import jp.co.extreme.module.wbs1.wcb.Wbs1ArticleListWCB_DEL2;
import jp.co.extreme.module.xsod.model.XsodSales;
import jp.co.extreme.module.xsys.validation.XsysValidationResult;
import jp.co.extreme.module.xweb.common.HtmlUtil2;
import jp.co.extreme.module.xweb.common.WbxConstants;
import jp.co.extreme.module.xweb.common.WbxPath;
import jp.co.extreme.module.xweb.common.XwebUtil;

public class Wbs1PaymentWCB
extends Wbs1AbstractWCB {
    @Override
    protected List<String> getHeadElementList(WbfwWcbArgument wcbArg) throws Exception {
        List<String> list = super.getHeadElementList(wcbArg);
        list.add("<script type=\"text/javascript\" src=\"https://js.squareupsandbox.com/v2/paymentform\"></script>");
        list.add("<link rel=\"stylesheet\" type=\"text/css\" href=\"mysqpaymentform.css\" />");
        return list;
    }

    @Override
    protected StringBuilder createBodyScript(WbfwWcbArgument wcbArg) throws Exception {
        StringBuilder sb = super.createBodyScript(wcbArg);
        File file = WbfwUtil.getFile(wcbArg, "square_payment_script.txt");
        sb.append((CharSequence)BcFileUtil.readAsStringBuilder(file));
        return sb;
    }

    public void form(WbfwWcbArgument wcbArg) throws Exception {
        StringBuilder content = this.createContent(wcbArg);
        StringBuilder sb = this.getBaseHtml(wcbArg);
        sb = this.replace(wcbArg, "\u30ab\u30fc\u30c9\u6c7a\u6e08", null, sb);
        sb = BcStringUtil.replace((CharSequence)sb, WbxConstants.PlaceHolder.content.value, content);
        WbfwUtil.outputHtml(wcbArg, sb.toString());
    }

    protected StringBuilder createContent(WbfwWcbArgument wcbArg) throws Exception {
        HttpSession httpSession = WbfwUtil.getSession(wcbArg, false, true);
        XsysValidationResult validationResult = (XsysValidationResult)httpSession.getAttribute(this.getValidationKey());
        XsodSales sales = XwebUtil.getAttribute1(httpSession, XsodSales.class);
        if (sales == null) {
            sales = new XsodSales();
            sales.amount = 1000L;
            int baseDate = BcTimeUtil.createYyyyMMdd();
            BigDecimal consumptionTax = BsnAccountsUtil.calcConsumptionTax(sales.amount, baseDate, 4);
            sales.tax = consumptionTax.longValue();
            httpSession.setAttribute(sales.getClass().getName(), (Object)sales);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(MdlCreator.getInstance().card_supporting_text("\u304a\u652f\u6255\u3044\u91d1\u984d\u306f" + (sales.amount + sales.tax) + "\u3067\u3059\u3002"));
        File squarePaymentFile = WbfwUtil.getFile(wcbArg, "square_payment_from.txt");
        byte[] bytes = BcFileUtil.read(squarePaymentFile);
        sb.append(new String(bytes));
        String formName = "form1";
        sb = HtmlUtil2.form(formName, sb.toString());
        sb = MdlCreator.getInstance().cell_shadow_margin("\u30ab\u30fc\u30c9\u6c7a\u6e08", sb.toString());
        sb = MdlCreator.getInstance().div_card(sb, "480px");
        sb = MdlCreator.getInstance().grid_portfolio(sb);
        return sb;
    }

    /*
     * Unable to fully structure code
     */
    public void submit(WbfwWcbArgument wcbArg) throws Exception {
        block3: {
            httpSession = WbfwUtil.getSession(wcbArg, false, true);
            sales = XwebUtil.getAttribute1(httpSession, XsodSales.class);
            nonce = SquareUtil.getNonce(new BufferedReader(wcbArg.getRequest().getReader()));
            BcLogUtil.debug("nonce=" + nonce);
            amount = sales.amount + sales.tax;
            currency = SquareUtil.Currency.JPY;
            credentials = SquareUtil.getCredentials();
            try {
                createPaymentResponse = SquareUtil.createPaymentResponse(credentials.accessToken, Environment.SANDBOX, nonce, amount, currency);
                BcLogUtil.debug("createPaymentResponse.getPayment()=" + createPaymentResponse.getPayment().getStatus());
                break block3;
            }
            catch (ApiException ex) {
                BcLogUtil.error("ex.getResponseCode()=" + ex.getResponseCode());
                ** for (error : ex.getErrors())
            }
lbl-1000:
            // 1 sources

            {
                BcLogUtil.error(error.getCategory());
                BcLogUtil.error(error.getDetail());
                BcLogUtil.error(error.getField());
                BcLogUtil.error(error.getCode());
                continue;
            }
lbl20:
            // 1 sources

            throw ex;
        }
        XwebUtil.forward(wcbArg, Wbs1ArticleListWCB_DEL2.Method.articleList);
    }

    public String getValidationKey() throws Exception {
        return String.valueOf(this.getClass().getName()) + (Object)((Object)WbxConstants.AttributeSuffix._validationResult);
    }

    public static enum Method implements WbxPath
    {
        form("paymentForm"),
        submit("process-payment");

        private final String path;

        private Method(String path) {
            this.path = XwebUtil.createPath(this, path);
        }

        @Override
        public String getMethodName() {
            return this.name();
        }

        @Override
        public String getPath() {
            return this.path;
        }
    }
}

