/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbfw.servlet;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.co.extreme.base.core.BcConstants;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcWarningException;
import jp.co.extreme.datasource.DtsSessionFactory;
import jp.co.extreme.datasource.DtsSessionFactoryManegaer;
import jp.co.extreme.module.wbfw.common.WbSessionTimeoutException;
import jp.co.extreme.module.wbfw.common.WbfSiteContext;
import jp.co.extreme.module.wbfw.common.WbfwResourceHolder;
import jp.co.extreme.module.wbfw.common.WbfwUtil;
import jp.co.extreme.module.wbfw.container.WbfwContainer;
import jp.co.extreme.module.wbfw.container.WbfwWcbArgument;
import jp.co.extreme.module.wbfw.servlet.WbfwServlet;

public abstract class WbfwMainServlet
extends WbfwServlet {
    private static final long serialVersionUID = 7675503106298714210L;
    public static List<WbfwWcbArgument> wcbArgList = new ArrayList<WbfwWcbArgument>();

    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    @Override
    public void doDelete(HttpServletRequest httpReq, HttpServletResponse httpRes) throws ServletException, IOException {
        this.getLogger().debug("doDelete");
    }

    @Override
    public void doHead(HttpServletRequest httpReq, HttpServletResponse httpRes) throws ServletException, IOException {
        this.getLogger().debug("doHead");
    }

    @Override
    public void doOptions(HttpServletRequest httpReq, HttpServletResponse httpRes) throws ServletException, IOException {
        this.getLogger().debug("doOptions");
    }

    @Override
    public void doPut(HttpServletRequest httpReq, HttpServletResponse httpRes) throws ServletException, IOException {
        this.getLogger().debug("doPut");
    }

    @Override
    public void doTrace(HttpServletRequest httpReq, HttpServletResponse httpRes) throws ServletException, IOException {
        this.getLogger().debug("doTrace");
    }

    @Override
    public void doPost(HttpServletRequest httpReq, HttpServletResponse httpRes) throws ServletException, IOException {
        this.commonTransL1(httpReq, httpRes);
    }

    @Override
    public void doGet(HttpServletRequest httpReq, HttpServletResponse httpRes) throws ServletException, IOException {
        this.commonTransL1(httpReq, httpRes);
    }

    protected void commonTransL1(HttpServletRequest httpReq, HttpServletResponse httpRes) throws ServletException, IOException {
        try {
            this.commonTransL2(httpReq, httpRes);
        }
        catch (Exception ex) {
            this.getLogger().error(ex);
            httpRes.sendError(500, ex.getMessage());
        }
    }

    protected void commonTransL2(HttpServletRequest httpReq, HttpServletResponse httpRes) throws Exception {
        WbfwWcbArgument wcbArg = new WbfwWcbArgument();
        wcbArg.startDateTime = BcTimeUtil.createCalendar();
        httpReq.setCharacterEncoding(BcConstants.charset.name());
        wcbArg.setStartTime(System.currentTimeMillis());
        wcbArg.setRequest(httpReq);
        wcbArg.setResponse(httpRes);
        wcbArg.servletPath = WbfwUtil.getServletPath(httpReq);
        wcbArg.pathInfo = WbfwUtil.createPathInfo(httpReq, wcbArg.servletPath);
        WbfwContainer webContainer = WbfwResourceHolder.getInstance().webContainer;
        wcbArg.setWebContainer(webContainer);
        String serverKey = String.valueOf(httpReq.getServerName()) + ":" + httpReq.getServerPort();
        WbfSiteContext siteContext = webContainer.serverNameMap.get(serverKey);
        if (siteContext == null) {
            String msg = "\u30b5\u30a4\u30c8\u30b3\u30f3\u30c6\u30ad\u30b9\u30c8\u306b\u8a72\u5f53\u304c\u3042\u308a\u307e\u305b\u3093\u3002serverKey=" + serverKey + " URL=" + httpReq.getRequestURL();
            throw new Exception(msg);
        }
        wcbArg.setSiteContext(siteContext);
        wcbArg.setHttpSessionManager(wcbArg.getWebContainer().getHttpSessionManager());
        wcbArg.setOwner(this);
        if (BcStringUtil.isEmpty(httpReq.getMethod())) {
            wcbArg.getResponse().sendError(400, "Method is null.");
            return;
        }
        try {
            try {
                this.commonTransL3(wcbArg);
                wcbArg.setEndTime(System.currentTimeMillis());
            }
            catch (WbSessionTimeoutException ex) {
                try {
                    this.sessionTimeoutOccurred(wcbArg, ex);
                }
                catch (Exception ex2) {
                    this.getLogger().error(ex2);
                }
                wcbArg.desturuct();
            }
            catch (Exception ex) {
                try {
                    this.exceptionOccurred(wcbArg, ex);
                }
                catch (Exception ex2) {
                    this.getLogger().error(ex2);
                }
                wcbArg.desturuct();
            }
        }
        finally {
            wcbArg.desturuct();
        }
    }

    protected void commonTransL3(WbfwWcbArgument wcbArg) throws Exception {
        DtsSessionFactory dtsSessionFactory = DtsSessionFactoryManegaer.getInstance().getSessionFactoryMain();
        wcbArg.setSessionFactory(dtsSessionFactory);
        try {
            this.httpTrans(wcbArg);
        }
        catch (Exception ex) {
            try {
                wcbArg.rollback();
            }
            catch (Exception ex2) {
                this.getLogger().error(ex2);
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkTransTime(WbfwWcbArgument wcbArg1) throws Exception {
        if (System.currentTimeMillis() <= 0L) {
            return;
        }
        List<WbfwWcbArgument> list = wcbArgList;
        synchronized (list) {
            if (wcbArgList.size() <= 10) {
                wcbArgList.add(wcbArg1);
            } else {
                long term1 = wcbArg1.getEndTime() - wcbArg1.getStartTime();
                int i = 0;
                while (i < wcbArgList.size()) {
                    WbfwWcbArgument wcbArg2 = wcbArgList.get(i);
                    long term2 = wcbArg2.getEndTime() - wcbArg2.getStartTime();
                    if (term1 > term2) {
                        wcbArgList.remove(wcbArg2);
                        wcbArgList.add(wcbArg1);
                    }
                    ++i;
                }
            }
        }
    }

    protected String createExceptionMessage(Throwable throwable) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (throwable instanceof BcWarningException) {
            BcWarningException warningException = (BcWarningException)throwable;
            sb.append(warningException.getMessage());
        } else {
            sb.append(BcLogUtil.getStackTrace(throwable));
        }
        return sb.toString();
    }

    public void httpTrans(WbfwWcbArgument wcbArg) throws Exception {
        HttpServletRequest httpReq = wcbArg.getRequest();
        if ("/".equals(httpReq.getServletPath())) {
            this.notFound(wcbArg);
            return;
        }
        File file = WbfwUtil.getFile(wcbArg, httpReq.getServletPath());
        if (file != null) {
            this.fileOutput(wcbArg, file);
        } else {
            this.notFound(wcbArg);
        }
    }

    public void fileOutput(WbfwWcbArgument wcbArg, File file) throws Exception {
        if (file.exists()) {
            if (file.isFile()) {
                WbfwUtil.outputFile(wcbArg, file);
            } else {
                this.fileList(wcbArg, file);
            }
        } else {
            this.getLogger().warning("Not Found. file=" + file.getPath());
            this.notFound(wcbArg);
        }
    }

    protected void fileList(WbfwWcbArgument wcbArg, File file) throws Exception {
        this.getLogger().debug("not found URL=" + wcbArg.getRequest().getRequestURL());
        wcbArg.getResponse().sendError(404, "not found URL=" + wcbArg.getRequest().getRequestURL());
    }

    protected void notFound(WbfwWcbArgument wcbArg) throws Exception {
        wcbArg.getResponse().sendError(404);
    }

    public void sessionTimeoutOccurred(WbfwWcbArgument wcbArg, WbSessionTimeoutException ex) throws Exception {
        this.getLogger().error(ex);
        String html = BcLogUtil.convertMessage(ex);
        WbfwUtil.outputHtml(wcbArg, html.toString());
    }

    public void exceptionOccurred(WbfwWcbArgument wcbArg, Throwable throwable) throws Exception {
        this.getLogger().error(throwable);
        String html = BcLogUtil.convertMessage(throwable);
        WbfwUtil.outputHtml(wcbArg, html.toString());
    }

    protected abstract void defaultPage(WbfwWcbArgument var1) throws Exception;
}

