/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.tbcp.common;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogHelper;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.table.BcTableUtil;
import jp.co.extreme.base.util.BcCompareUtil;
import jp.co.extreme.base.util.BcDifference;
import jp.co.extreme.module.tbcp.common.TbcpCellNull;
import jp.co.extreme.module.tbcp.common.TbcpCsvComparator;
import jp.co.extreme.module.tbcp.common.TbcpUtil;
import jp.co.extreme.nlp.NlpNoun;

class TbcpTableComparator
extends BcLoggableObject {
    public static final String delimiter = "-";

    TbcpTableComparator() {
    }

    public Map<String, BcDifference> compare(BcTableModel tableModel1, BcTableModel tableModel2) throws Exception {
        int j;
        int rowCountMax = Math.max(tableModel1.getRowCount(), tableModel2.getRowCount());
        int columnCountMax = Math.max(tableModel1.getColumnCount(), tableModel2.getColumnCount());
        HashMap<String, BcDifference> diffMap = new HashMap<String, BcDifference>();
        int i = 0;
        while (i < rowCountMax) {
            if (i >= tableModel1.getRowCount()) {
                this.addRow(tableModel1);
            }
            if (i >= tableModel2.getRowCount()) {
                this.addRow(tableModel2);
            }
            j = 0;
            while (j < columnCountMax) {
                if (j >= tableModel1.getColumnCount()) {
                    this.addColumn(tableModel1);
                }
                if (j >= tableModel2.getColumnCount()) {
                    this.addColumn(tableModel2);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < rowCountMax) {
            if (i % 100 == 0) {
                this.getLogger().info(BcLogHelper.countBrackets(rowCountMax, i, true));
            }
            j = 0;
            while (j < columnCountMax) {
                Object value1 = this.getValueAt(tableModel1, i, j);
                Object value2 = this.getValueAt(tableModel2, i, j);
                String key = TbcpTableComparator.createKey(i, j);
                BcDifference difference = (BcDifference)diffMap.get(key);
                if (difference != null) {
                    this.getLogger().debug("Error key=" + key);
                } else {
                    difference = this.compare(value1, value2);
                    if (difference != null) {
                        diffMap.put(key, difference);
                    }
                }
                ++j;
            }
            ++i;
        }
        return diffMap;
    }

    protected Object getValueAt(BcTableModel tableModel, int rowId, int columnId) throws Exception {
        Object value = tableModel.getValueAtModel(rowId, columnId);
        if (value instanceof TbcpCellNull) {
            return null;
        }
        return value;
    }

    protected BcDifference compare(Object value1, Object value2) throws Exception {
        BcDifference difference = null;
        if (BcCompareUtil.Comparison.equals.value != BcCompareUtil.compare(value1, value2)) {
            List<NlpNoun> nounList;
            difference = new BcDifference(value1, value2);
            String src1 = BcStringUtil.toStringNotNull(value1);
            String src2 = BcStringUtil.toStringNotNull(value2);
            difference.arrayInfo = nounList = TbcpUtil.diff(src1, src2);
        }
        return difference;
    }

    protected void addRow(BcTableModel tableModel) throws Exception {
        BcTableUtil.addRow(tableModel, 1, (Object)TbcpCsvComparator.cellNull);
    }

    protected void addColumn(BcTableModel tableModel) throws Exception {
        tableModel.addColumn(new BcTableColumn());
        int i = 0;
        while (i < tableModel.getRowCount()) {
            tableModel.getRow(i).add(TbcpCsvComparator.cellNull);
            ++i;
        }
    }

    public static String createKey(int rowId, int columnId) throws Exception {
        return String.valueOf(rowId) + delimiter + columnId;
    }

    public static int[] toValues(String src) throws Exception {
        int[] values = new int[2];
        int index = src.indexOf(delimiter);
        values[0] = Integer.parseInt(src.substring(0, index));
        values[1] = Integer.parseInt(src.substring(index + 1));
        return values;
    }
}

