/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.mqsv.common;

import java.io.Serializable;
import java.util.Calendar;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.xml.BcXmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MqsvConstants
implements Serializable {
    private static final long serialVersionUID = 6143855556764064659L;
    public static final String TAG_config = "config";
    public static final String TAG_request = "request";
    public static final String TAG_respons = "respons";
    public static final String TAG_notice = "notice";
    public static final String TAG_status = "status";
    public static final String VAL_valid = "valid";
    public static final String VAL_objectNotFound = "objectNotFound";
    public static final String VAL_exception = "exception";
    public static final String TAG_tagSetVersion = "tagSetVersion";
    public static final String TAG_message = "message";
    public static final String TAG_metaData = "metaData";
    public static final String TAG_entryDateTime = "entryDateTime";
    public static final String TAG_entryMessageListener = "entryMessageListener";
    public static final String TAG_protocol = "protocol";
    public static final String VAL_socketXml = "socket:xml";
    public static final String VAL_compression = "compression";
    public static final String TAG_target = "target";
    public static final String TAG_dataCashMax = "dataCashMax";
    public static final String TAG_retryWait = "retryWait";
    public static final String TAG_retryMax = "retryMax";
    public static final String TAG_removeMessageListener = "removeMessageListener";
    public static final String TAG_messageId = "messageId";
    public static final String TAG_address = "address";
    public static final String TAG_port = "port";
    public static final String TAG_timeout = "timeout";
    public static final String TAG_startup = "startup";
    public static final String TAG_debug = "debug";
    public static final String TAG_logLevel = "logLevel";
    public static final String TAG_format = "format";
    public static final String TAG_lookAndFeel = "lookAndFeel";
    public static final String TAG_default = "default";
    public static final String TAG_title = "title";
    public static final String TAG_valid = "valid";
    public static final String TAG_property = "property";
    public static final String TAG_key = "key";
    public static final String TAG_value = "value";
    public static final String TAG_device = "device";
    public static final String TAG_recentFile = "recentFile";
    public static final String TAG_recentDir = "recentDir";

    private MqsvConstants() {
    }

    public static Document createRespons(String strVal, String message) throws Exception {
        Document xmlDoc = BcXmlUtil.createDocument("root", true);
        Element rootElem = xmlDoc.createElement(TAG_respons);
        xmlDoc.appendChild(rootElem);
        Element elemL1 = null;
        elemL1 = xmlDoc.createElement(TAG_status);
        rootElem.appendChild(elemL1);
        elemL1.appendChild(xmlDoc.createTextNode(strVal));
        if (!BcStringUtil.isEmpty(message)) {
            elemL1 = xmlDoc.createElement(TAG_message);
            rootElem.appendChild(elemL1);
            elemL1.appendChild(xmlDoc.createTextNode(message));
        }
        return xmlDoc;
    }

    public static Document createRespons(String strVal) throws Exception {
        return MqsvConstants.createRespons(strVal, null);
    }

    public static Element createTimeElement(Node baseNode, String tagName, Calendar calendar, String pattern) {
        Document xmlDoc = baseNode.getOwnerDocument();
        Element elem1 = xmlDoc.createElement(tagName);
        elem1.setAttribute(TAG_format, pattern);
        elem1.appendChild(xmlDoc.createTextNode(BcTimeUtil.toString(calendar, pattern)));
        return elem1;
    }

    public static Calendar parseDate(Node baseNode, String path) throws Exception {
        Node domNode = BcXmlUtil.getNode(baseNode, path, false);
        if (domNode == null) {
            return null;
        }
        String strValue = BcXmlUtil.getValue(domNode, 3, null);
        if (!BcStringUtil.isEmpty(strValue)) {
            String formatPattern = BcXmlUtil.getAttribute(domNode, TAG_format, "yyyy/MM/dd");
            Calendar calendar = null;
            try {
                calendar = BcTimeUtil.toCalendar(strValue, formatPattern);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return calendar;
        }
        return null;
    }
}

