/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.mmdx.fx;

import java.util.ArrayList;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TableView;
import javafx.scene.layout.BorderPane;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.datasource.util.DtsWordManager;
import jp.co.extreme.fx.table.FxTableRowList;
import jp.co.extreme.fx.table.FxTableUtil;
import jp.co.extreme.fx.table.FxTableView;
import jp.co.extreme.module.mmdx.common.MmdxConstants;
import jp.co.extreme.module.mmdx.fx.MmdxEventHandler;
import jp.co.extreme.module.mmdx.fx.MmdxFieldTableModel;
import jp.co.extreme.module.mmdx.model.MmdxField;
import jp.co.extreme.module.mmdx.model.MmdxModel;
import jp.co.extreme.module.xdts.fx.XdtsTableInfoPane;
import jp.co.extreme.scf6.fx.TmpTableViewPane;

public class MmdxFieldListPane
extends BorderPane {
    MmdxModel mmdxModel;
    MmdxFieldTableModel fieldTableModel;
    FxTableView tableView;
    List<MmdxEventHandler> mmdEventHandlerList = new ArrayList<MmdxEventHandler>();
    DtsWordManager wordManager;

    public void setData(MmdxModel mmdxModel, DtsWordManager wordManager) throws Exception {
        this.mmdxModel = mmdxModel;
        this.wordManager = wordManager;
        BcTableModel tableModel = XdtsTableInfoPane.createTableModel(mmdxModel.fieldList, mmdxModel.tableName, wordManager);
        this.tableView = new InnerTableView();
        FxTableUtil.createColumn(tableModel.getTableColumnModel(), this.tableView, null);
        FxTableRowList tableRowList = new FxTableRowList(tableModel);
        this.tableView.setItems(tableRowList);
        TmpTableViewPane tmpTableViewPane = new TmpTableViewPane();
        tmpTableViewPane.setTableView(this.tableView);
        tmpTableViewPane.tableControlPane.setData(tableModel.getTableColumnModel(), tableModel, null);
        tmpTableViewPane.tableControlPane.setTitle(mmdxModel.tableName);
        this.setCenter((Node)tmpTableViewPane);
    }

    public void addEventHandler(MmdxEventHandler eventHandler) {
        this.mmdEventHandlerList.add(eventHandler);
    }

    public boolean removeEventHandler(MmdxEventHandler eventHandler) {
        return this.mmdEventHandlerList.remove(eventHandler);
    }

    class InnerTableView
    extends FxTableView {
        @Override
        public void rowSelectionChanged(FxTableView tableView, ObservableList<Integer> rowIdList, int prevRowId, int nextRowId) throws Exception {
            super.rowSelectionChanged((FxTableView)this, rowIdList, prevRowId, nextRowId);
            ObservableList tableViewItems = this.getItems();
            String columnName = (String)FxTableUtil.getCellValue((TableView)this, nextRowId, MmdxConstants.TableColmnName.mdx_field__column_name.value);
            MmdxField mmdField = MmdxFieldListPane.this.mmdxModel.getFieldByName(columnName);
            Object[] eventHandlers = MmdxFieldListPane.this.mmdEventHandlerList.toArray();
            int i = 0;
            while (i < eventHandlers.length) {
                MmdxEventHandler eventHandler = (MmdxEventHandler)eventHandlers[i];
                try {
                    eventHandler.mmdSelected(mmdField);
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
                ++i;
            }
        }
    }
}

