/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.impt.common;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.charset.BcCharsetNames;
import jp.co.extreme.base.charset.BcUtf8Util;
import jp.co.extreme.base.core.BcInteger;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcUnicode;
import jp.co.extreme.base.runtime.BcRuntimeUtil;
import jp.co.extreme.base.util.BcCharacterCodingException;
import jp.co.extreme.base.util.BcEncoder;
import jp.co.extreme.module.impt.common.ImptAbstractRecordParser;
import jp.co.extreme.module.impt.common.ImptImportUtil;
import jp.co.extreme.module.impt.model.ImptImportDefine;

public class ImptImportDataParser
extends ImptAbstractRecordParser {
    protected ImptImportDefine importDefine;
    protected Charset charset;
    protected BcEncoder encoder;
    protected InputStream is;
    protected byte[] bufBytes;
    protected BcInteger offSet = new BcInteger();
    protected Reader reader;
    protected String[] delimiters = new String[]{BcStringUtil.COMMA_STR};
    protected final int VALUE = 11;
    protected final int STRING = 21;
    protected int mode;
    protected int rowCount;
    protected int page = 1;

    @Override
    public void doParse(ImptImportDefine importDefine, InputStream is1) throws Exception {
        try {
            this.doParse_L2(importDefine, is1);
        }
        finally {
            is1.close();
        }
    }

    protected void doParse_L2(ImptImportDefine importDefine, InputStream is1) throws Exception {
        this.importDefine = importDefine;
        this.is = BufferedInputStream.class.isAssignableFrom(is1.getClass()) ? is1 : new BufferedInputStream(is1);
        String charsetName = importDefine.charsetName;
        if (BcStringUtil.isEmpty(charsetName)) {
            this.is.mark(65535);
            charsetName = BcEncoder.detectEncoding(this.is);
            if (BcStringUtil.isEmpty(charsetName)) {
                String fileEncodingDefault = BcRuntimeUtil.getFileEncoding();
                String msg = "\u6587\u5b57\u30b3\u30fc\u30c9\u3092\u5224\u5225\u3067\u304d\u306a\u3044\u305f\u3081\u3001\u30b7\u30b9\u30c6\u30e0\u306e\u30c7\u30d5\u30a9\u30eb\u30c8 " + fileEncodingDefault + " \u3092\u63a1\u7528\u3057\u307e\u3059\u3002";
                this.getLogger().warning(msg);
                charsetName = fileEncodingDefault;
            }
            this.is.reset();
        }
        this.charset = Charset.forName(charsetName);
        this.getLogger().info("charset=" + this.charset);
        if (BcCharsetNames.UTF_8.value.equalsIgnoreCase(this.charset.name())) {
            this.getLogger().warning("skip BOM");
            BcUtf8Util.skipBom(this.is);
        }
        this.encoder = new BcEncoder();
        this.encoder.setEncodCharset(this.charset);
        switch (importDefine.datasourceType) {
            case 21: {
                this.bufBytes = new byte[importDefine.fixedLength];
                this.loopLevel1();
                break;
            }
            case 11: {
                InputStreamReader inputStreamReader = null;
                inputStreamReader = BcStringUtil.isEmpty(importDefine.charsetName) ? new InputStreamReader(this.is) : new InputStreamReader(this.is, importDefine.charsetName);
                this.reader = new BufferedReader(inputStreamReader);
                this.csvLevel1();
                break;
            }
            case 41: {
                InputStreamReader inputStreamReader = null;
                inputStreamReader = BcStringUtil.isEmpty(importDefine.charsetName) ? new InputStreamReader(this.is) : new InputStreamReader(this.is, importDefine.charsetName);
                this.reader = new BufferedReader(inputStreamReader);
                this.noFixedTextLevel1();
                break;
            }
            default: {
                throw new Exception("Not supported datasourceType=" + importDefine.datasourceType);
            }
        }
    }

    @Override
    public void doParse(ImptImportDefine importDefine, File file) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        this.doParse(importDefine, fis);
    }

    protected void loopLevel1() throws Exception {
        int tmpCnt = -1;
        int storedCnt = -1;
        int recCnt = 0;
        block0: do {
            if (this.isStop) {
                return;
            }
            tmpCnt = 0;
            storedCnt = 0;
            while ((tmpCnt = this.is.read(this.bufBytes, storedCnt, this.importDefine.fixedLength - storedCnt)) >= 0) {
                if ((storedCnt += tmpCnt) != this.importDefine.fixedLength) continue;
                this.parseOneRow(++recCnt, this.bufBytes);
                continue block0;
            }
        } while (tmpCnt >= 0);
    }

    protected void parseOneRow(int recCnt, byte[] bytes) throws Exception {
        try {
            List<String> valueList = ImptImportUtil.getInstance().parseFixdText(this.importDefine, this.encoder, bytes);
            this.newRow(this.page, recCnt, valueList);
        }
        catch (UnsupportedEncodingException ex) {
            throw ex;
        }
        catch (CharacterCodingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ex;
        }
    }

    protected void csvLevel1() throws Exception {
        this.rowCount = 0;
        ArrayList<String> valueList = new ArrayList<String>();
        this.mode = 11;
        char[] chars = new char[1];
        StringBuilder sb = new StringBuilder();
        boolean isPreSep = true;
        int pos = 0;
        while (true) {
            if (this.isStop) {
                return;
            }
            int readRes = this.reader.read(chars, 0, 1);
            if (readRes < 0) break;
            ++pos;
            String word = new String(chars);
            switch (this.mode) {
                case 11: {
                    if (this.isLineSeparator(word)) {
                        if (isPreSep) break;
                        isPreSep = true;
                        valueList.add(BcStringUtil.toNull(sb.toString()));
                        BcStringUtil.clear(sb);
                        if (this.rowCount == 0) {
                            this.columnCount = valueList.size();
                        } else {
                            int elementGap = this.columnCount - valueList.size();
                            if (elementGap > 0) {
                                int i = 0;
                                while (i < elementGap) {
                                    valueList.add(null);
                                    ++i;
                                }
                            }
                        }
                        ++this.rowCount;
                        this.newRow(this.page, this.rowCount, valueList);
                        valueList = new ArrayList();
                        break;
                    }
                    isPreSep = false;
                    if (this.isQuotation(word)) {
                        StringBuilder tmpBuf = BcStringUtil.replace((CharSequence)sb, BcStringUtil.SPACE_STR, "");
                        if (tmpBuf.length() > 0) {
                            BcCharacterCodingException ex = new BcCharacterCodingException();
                            ex.errorText = "pos=" + pos + " '" + tmpBuf + "'";
                            throw ex;
                        }
                        BcStringUtil.clear(sb);
                        this.mode = 21;
                        break;
                    }
                    if (this.isDelimiter(word)) {
                        valueList.add(BcStringUtil.toNull(sb.toString()));
                        BcStringUtil.clear(sb);
                        break;
                    }
                    sb.append(word);
                    break;
                }
                case 21: {
                    if (this.isQuotation(word)) {
                        this.mode = 11;
                        break;
                    }
                    sb.append(word);
                }
            }
        }
        if (this.mode == 11) {
            if (sb.length() > 0) {
                valueList.add(BcStringUtil.toNull(sb.toString()));
                ++this.rowCount;
                this.newRow(this.page, this.rowCount, valueList);
            }
        } else if (this.mode == 21) {
            throw new Exception("Quotation is invalid.");
        }
    }

    protected void noFixedTextLevel1() throws Exception {
        this.rowCount = 0;
        ArrayList<String> valueList = new ArrayList<String>();
        char[] charBuf = new char[1];
        StringBuilder sb = new StringBuilder();
        boolean isPreSep = true;
        while (true) {
            if (this.isStop) {
                return;
            }
            int readRes = this.reader.read(charBuf, 0, 1);
            if (readRes < 0) break;
            String word = new String(charBuf);
            if (this.isLineSeparator(word)) {
                if (isPreSep) continue;
                isPreSep = true;
                ++this.rowCount;
                valueList.add(BcStringUtil.toNull(sb.toString()));
                this.newRow(this.page, this.rowCount, valueList);
                BcStringUtil.clear(sb);
                valueList = new ArrayList();
                continue;
            }
            isPreSep = false;
            sb.append(word);
        }
    }

    protected boolean isLineSeparator(String word) {
        return word.equals(BcStringUtil.CARRIAGE_RETURN_STR) || word.equals(BcStringUtil.LINE_FEED_STR);
    }

    protected boolean isDelimiter(String word) {
        int i = 0;
        while (i < this.delimiters.length) {
            if (word.equals(this.delimiters[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isQuotation(String word) {
        return BcUnicode.quotationMark.string.equals(word);
    }

    public void setDelimiters(String[] delimiters) {
        this.delimiters = delimiters;
    }

    public void setDelimiter(String delimiter) {
        this.delimiters = new String[1];
        this.delimiters[0] = delimiter;
    }
}

