/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.lib.editorjs;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.util.Map;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.base.util.BcRandamUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.json.JacksonUtil;
import jp.co.extreme.json.JsonNodeVisitor;
import jp.co.extreme.module.wbfw.common.WbfSiteContext;
import jp.co.extreme.module.wbfw.common.WbfwUrlParameterMap;
import jp.co.extreme.module.wbfw.common.WbfwUtil;
import jp.co.extreme.module.wbfw.container.WbfwWcbArgument;
import jp.co.extreme.module.wbs1.dao.Wbs1FileResourceDAO;
import jp.co.extreme.module.wbs1.model.Wbs1FileResource;
import jp.co.extreme.module.wbs1.server.ArticleManager;
import jp.co.extreme.module.wbs1.wcb.Wbs1ImageWCB;
import jp.co.extreme.module.xweb.common.XwebUtil;

public class JsonNodeVisitorForEditorJs
extends JsonNodeVisitor {
    WbfSiteContext siteContext;
    WbfwWcbArgument wcbArg;
    DtsSession dtsSession;

    public JsonNodeVisitorForEditorJs(WbfSiteContext siteContext, WbfwWcbArgument wcbArg) {
        this.siteContext = siteContext;
        this.wcbArg = wcbArg;
    }

    @Override
    public void parse(JsonNode jsonNode) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSession2 = XwebUtil.createDataSourceSession(this.siteContext, this);){
            this.dtsSession = dtsSession2;
            super.parse(jsonNode);
            this.dtsSession.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void accept(JsonNode jsonNode, String path, int arrayIndex, String name, String parentName, JsonNode jsonNodeParent) throws Exception {
        this.getLogger().debug("accept:path=" + path + " arrayIndex=" + arrayIndex + " name=" + name + " parentName=" + parentName);
        if ("url".equals(name) && "file".equals(parentName)) {
            this.getLogger().debug("jsonNode.asText()=" + jsonNode.asText());
            int questionIindex = jsonNode.asText().indexOf("?");
            if (questionIindex >= 0) {
                String query = jsonNode.asText().substring(questionIindex + 1);
                Map<String, String> paramMap = XwebUtil.parseQuery(query);
                this.getLogger().debug("paramMap=" + paramMap);
                if (paramMap.containsKey("temp")) {
                    String fileName = paramMap.get("fileName");
                    String fileNameOrig = paramMap.get("fileNameOrig");
                    this.getLogger().debug("fileName=" + fileName + " fileNameOrig=" + fileNameOrig);
                    File tempDir = AfbApplication.getInstance().getTempDir();
                    File tempFile = new File(tempDir, fileName);
                    Wbs1FileResource fileResource = JsonNodeVisitorForEditorJs.fileProc(this.wcbArg, tempFile, this.dtsSession, fileNameOrig, this.getLogger());
                    WbfwUrlParameterMap neweUrlQueryMap = new WbfwUrlParameterMap();
                    String href = String.valueOf(XwebUtil.toRelativePath(this.wcbArg.getRequest(), Wbs1ImageWCB.Method.getImage)) + "/" + fileResource.fileName3 + WbfwUtil.createUrlQuery(neweUrlQueryMap);
                    this.getLogger().debug("href=" + href);
                    JacksonUtil.put(jsonNodeParent, name, href);
                }
            }
        }
    }

    public static Wbs1FileResource fileProc(WbfwWcbArgument wcbArg, File tempFile, DtsSession dtsSession, String fileNameOrig, BcLogger logger) throws Exception {
        File newDir = ArticleManager.getInstance().getFilesDir(wcbArg.getSiteContext());
        File newFile = new File(newDir, fileNameOrig);
        newFile = XwebUtil.createNewFileName(newFile);
        logger.debug("newFile=" + newFile.getPath());
        Wbs1FileResource fileResource = XwebUtil.createFileResource(fileNameOrig);
        fileResource.fileName2 = newFile.getName();
        fileResource.fileName3 = BcFileUtil.createFileName(BcRandamUtil.createCodeSecure(5, 32), BcFileUtil.getExtention(newFile));
        logger.debug("fileName2=" + fileResource.fileName2 + " fileName3=" + fileResource.fileName3);
        BcFileUtil.rename(tempFile, newFile);
        Wbs1FileResourceDAO.getInstance().putEntity(dtsSession, fileResource);
        return fileResource;
    }
}

