/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.itext;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import jp.co.extreme.awt.AwtFontUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.doc.util.DcfDocumentUtil;

public class ItextUtil {
    static float yAjust1 = 25.0f;
    static float yAjust2 = 10.0f;

    private ItextUtil() {
    }

    public static float toPdfX(PageFormat pageFormat, double exX) throws Exception {
        float pdfX = (float)exX;
        return pdfX;
    }

    public static float toPdfY(PageFormat pageFormat, double exY) throws Exception {
        float pdfY = (float)(DcfDocumentUtil.inch72ToPixel(pageFormat.getHeight()) - exY + (double)yAjust1 - (double)yAjust2);
        return pdfY;
    }

    public static Rectangle toRectangle(double x, double y, double width, double height) throws Exception {
        Rectangle rectangle = new Rectangle((float)x, (float)y, (float)width, (float)height);
        return rectangle;
    }

    public static Rectangle toRectangle(double width, double height) throws Exception {
        return ItextUtil.toRectangle(0.0, 0.0, width, height);
    }

    public static Rectangle toRectangle(Rectangle2D.Double rectangleDouble) throws Exception {
        return ItextUtil.toRectangle((float)rectangleDouble.x, (float)rectangleDouble.y, (float)rectangleDouble.width, (float)rectangleDouble.height);
    }

    public static BaseColor toBaseColor(Color awtColor) throws Exception {
        BaseColor baseColor = new BaseColor(awtColor.getRed(), awtColor.getGreen(), awtColor.getBlue());
        return baseColor;
    }

    public static void join(File destFile, List<File> inputFileList) throws Exception {
        BcLogUtil.info("join:destFile=" + destFile.getPath());
        BcLogUtil.info("join:inputFileList.size()=" + inputFileList.size());
        Document document = null;
        PdfCopy pdfCopy = null;
        try {
            try {
                int i = 0;
                while (i < inputFileList.size()) {
                    File inputFile = inputFileList.get(i);
                    BcLogUtil.info("join:inputPath=" + inputFile.getPath());
                    PdfReader reader = new PdfReader(new RandomAccessFileOrArray(inputFile.getPath()), null);
                    reader.consolidateNamedDestinations();
                    if (document == null) {
                        document = new Document(reader.getPageSizeWithRotation(1));
                        pdfCopy = new PdfCopy(document, (OutputStream)new FileOutputStream(destFile));
                        document.open();
                    }
                    int numberOfPages = reader.getNumberOfPages();
                    int j = 1;
                    while (j <= numberOfPages) {
                        PdfImportedPage importedPage = pdfCopy.getImportedPage(reader, j);
                        pdfCopy.addPage(importedPage);
                        ++j;
                    }
                    reader.close();
                    ++i;
                }
                pdfCopy.close();
                document.close();
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (DocumentException ex) {
                throw ex;
            }
        }
        finally {
            if (document != null) {
                document.close();
            }
            if (pdfCopy != null) {
                pdfCopy.close();
            }
        }
    }

    public static BaseFont font_TimesRoman() throws Exception {
        return BaseFont.createFont((String)"Times-Roman", (String)"Cp1252", (boolean)true);
    }

    public static BaseFont font_TimesBold() throws Exception {
        return BaseFont.createFont((String)"Times-Bold", (String)"Cp1252", (boolean)true);
    }

    public static BaseFont font_TimesItalic() throws Exception {
        return BaseFont.createFont((String)"Times-Italic", (String)"Cp1252", (boolean)true);
    }

    public static BaseFont font_TimesBoldItalic() throws Exception {
        return BaseFont.createFont((String)"Times-BoldItalic", (String)"Cp1252", (boolean)true);
    }

    public static BaseFont font_Helvetica() throws Exception {
        return BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)true);
    }

    public static BaseFont font_HelveticaOblique() throws Exception {
        return BaseFont.createFont((String)"Helvetica-Oblique", (String)"Cp1252", (boolean)true);
    }

    public static BaseFont font_HelveticaBoldOblique() throws Exception {
        return BaseFont.createFont((String)"Helvetica-BoldOblique", (String)"Cp1252", (boolean)true);
    }

    public static BaseFont font_Courier() throws Exception {
        return BaseFont.createFont((String)"Courier", (String)"Cp1252", (boolean)true);
    }

    public static BaseFont font_CourierBold() throws Exception {
        return BaseFont.createFont((String)"Courier-Bold", (String)"Cp1252", (boolean)true);
    }

    public static BaseFont font_CourierOblique() throws Exception {
        return BaseFont.createFont((String)"Courier-Oblique", (String)"Cp1252", (boolean)true);
    }

    public static BaseFont font_CourierBoldOblique() throws Exception {
        return BaseFont.createFont((String)"Courier-BoldOblique", (String)"Cp1252", (boolean)true);
    }

    public static BaseFont font_Symbol() throws Exception {
        return BaseFont.createFont((String)"Symbol", (String)"Cp1252", (boolean)true);
    }

    public static BaseFont font_ZapfDingbats() throws Exception {
        return BaseFont.createFont((String)"ZapfDingbats", (String)"Cp1252", (boolean)true);
    }

    public static BaseFont font_HeiseiMinW3() throws Exception {
        return BaseFont.createFont((String)"HeiseiMin-W3", (String)"UniJIS-UCS2-H", (boolean)true);
    }

    public static BaseFont font_HeiseiKakuGoW5() throws Exception {
        return BaseFont.createFont((String)"HeiseiKakuGo-W5", (String)"UniJIS-UCS2-H", (boolean)true);
    }

    public static BaseFont font_KozMinProRegular() throws Exception {
        return BaseFont.createFont((String)"KozMinPro-Regular", (String)"UniJIS-UCS2-H", (boolean)true);
    }

    public static BaseFont getBaseFontByLogicalName(String logicalFontName) throws Exception {
        BaseFont baseFont = null;
        if (logicalFontName.equals("Serif")) {
            baseFont = ItextUtil.font_HeiseiMinW3();
        } else if (logicalFontName.equals("SansSerif")) {
            baseFont = ItextUtil.font_HeiseiKakuGoW5();
        }
        return baseFont;
    }

    public static String getBaseFontName(String physicalFontName) throws Exception {
        File fontFile;
        String baseFontName = null;
        if (("\uff2d\uff33 \u660e\u671d".equals(physicalFontName) || "\uff2d\uff33 \uff30\u660e\u671d".equals(physicalFontName) || "\uff2d\uff33 \u30b4\u30b7\u30c3\u30af".equals(physicalFontName) || "\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af".equals(physicalFontName) || "MS UI Gothic".equals(physicalFontName) || "\u30e1\u30a4\u30ea\u30aa".equals(physicalFontName) || "Meiryo UI".equals(physicalFontName)) && (fontFile = AwtFontUtil.getFontFile(physicalFontName)) != null) {
            baseFontName = fontFile.getPath();
            baseFontName = String.valueOf(baseFontName) + ",0";
        }
        return baseFontName;
    }

    public static BaseFont getBaseFont(String physicalFontName, boolean alternative) throws Exception {
        BaseFont baseFont = null;
        String baseFontName = ItextUtil.getBaseFontName(physicalFontName);
        if (baseFontName != null) {
            baseFont = BaseFont.createFont((String)baseFontName, (String)"Identity-H", (boolean)false);
        } else if (alternative) {
            String logicalFontName = AwtFontUtil.toLogicalFontName(physicalFontName);
            if (logicalFontName == null) {
                throw new Exception("Not support font '" + physicalFontName + "'.");
            }
            baseFont = ItextUtil.getBaseFontByLogicalName(logicalFontName);
        }
        return baseFont;
    }

    public static void main(String[] args) {
        try {
            System.out.println("baseFontName=22");
            String baseFontName = ItextUtil.getBaseFontName("\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af");
            System.out.println("baseFontName=" + baseFontName);
            BcLogUtil.debug("baseFontName=" + baseFontName);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
    }
}

