/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx.viewer;

import java.util.List;
import javafx.event.EventHandler;
import javafx.scene.layout.Pane;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.fx.FxPlatform;
import jp.co.extreme.fx.viewer.FxxContent;
import jp.co.extreme.fx.viewer.FxxContentNode;
import jp.co.extreme.fx.viewer.FxxNavigatePane;
import jp.co.extreme.fx.viewer.FxxUrlEvent;
import jp.co.extreme.task.TskAbstractCallable;

class FxxImageLoadTask
extends TskAbstractCallable {
    List<FxxContent> contentList;
    Pane tilePane;
    EventHandler<? super FxxUrlEvent> eventHandler;

    public FxxImageLoadTask(List<FxxContent> contentList, Pane tilePane, EventHandler<? super FxxUrlEvent> eventHandler) throws Exception {
        this.contentList = contentList;
        this.tilePane = tilePane;
        this.eventHandler = eventHandler;
    }

    protected Object taskProcess() throws Exception {
        int i = 0;
        while (i < this.contentList.size()) {
            final FxxContent fxxContent = this.contentList.get(i);
            FxPlatform.runLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        FxxContentNode contentNode = fxxContent.getNode(FxxNavigatePane.scale);
                        contentNode.setOnMouseClicked(ev -> {
                            if (FxxImageLoadTask.this.eventHandler != null) {
                                FxxUrlEvent urlEvent = new FxxUrlEvent((Object)contentNode, null, FxxUrlEvent.SELECTED);
                                urlEvent.value = fxxContent;
                                FxxImageLoadTask.this.eventHandler.handle(urlEvent);
                            }
                        });
                        FxxImageLoadTask.this.tilePane.getChildren().add((Object)contentNode);
                    }
                    catch (Exception ex) {
                        BcLogUtil.error(ex);
                    }
                }
            });
            ++i;
        }
        return null;
    }
}

