/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx.skin;

import java.net.URI;
import java.util.Iterator;
import javafx.scene.Node;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import jp.co.extreme.awt.AwtColorUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.net.BcNetUtil;
import jp.co.extreme.base.util.BcRangeInt;
import jp.co.extreme.css.common.CssUtil;
import jp.co.extreme.fx.skin.FxSkinUtil;
import jp.co.extreme.fx.util.FxColorUtil;

public class FxCssUtil {
    public static final String fx_font = "-fx-font";
    public static final String fx_font_family = "-fx-font-family";
    public static final String fx_font_size = "-fx-font-size";
    public static final String fx_font_weight = "-fx-font-weight";
    public static final String fx_text_fill = "-fx-text-fill";
    public static final String fx_background_color = "-fx-background-color";
    public static final String fx_background_radius = "-fx-background-radius";
    public static final String fx_background_image = "-fx-background-image";
    public static final String fx_background_position = "-fx-background-position";
    public static final String fx_background_repeat = "-fx-background-repeat";
    public static final String fx_background_size = "-fx-background-size";
    public static final String fx_border_width = "-fx-border-width";
    public static final String fx_border_radius = "-fx-border-radius";
    public static final String fx_border_color = "-fx-border-color";
    public static final String fx_opacity = "-fx-opacity";
    public static final String fx_effect = "-fx-effect";
    public static final String SC_background = "background";
    public static final String SC_text_field = "text-field";
    public static final String SCSUFIX_disabled = ":disabled";
    public static final String SCSUFIX_editable = "-editable";

    static {
        try {
            Class.forName(BcNetUtil.class.getName());
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
    }

    private FxCssUtil() {
    }

    public static void styleClassLog(Node node) throws Exception {
        Iterator iterator = node.getStyleClass().iterator();
        BcLogUtil.info("node=" + node.getClass().getName() + " styleClass.size()=" + node.getStyleClass().size());
        while (iterator.hasNext()) {
            String styleClass = (String)iterator.next();
            BcLogUtil.info("styleClass=" + styleClass);
        }
    }

    public static String toRgba(int r, int g, int b, double opacity) {
        return "rgba(" + r + "," + g + "," + b + "," + opacity + ")";
    }

    public static String toRgba(Color color) {
        int r = (int)Math.round(color.getRed() * 255.0);
        int g = (int)Math.round(color.getGreen() * 255.0);
        int b = (int)Math.round(color.getBlue() * 255.0);
        return FxCssUtil.toRgba(r, g, b, color.getOpacity());
    }

    public static String addProperty(String style, String property) throws Exception {
        int idx1 = property.toString().indexOf(58);
        String propertyPname = property.toString().substring(0, idx1);
        propertyPname = BcStringUtil.trim(propertyPname);
        BcRangeInt rangeInt = FxCssUtil.getelemtntRange(style, propertyPname);
        StringBuilder newStyle = new StringBuilder(style);
        if (rangeInt.start < 0) {
            BcStringUtil.appendExceptEmpty(newStyle, ';', property);
        } else {
            newStyle.replace(rangeInt.start, rangeInt.end + 1, property.toString());
        }
        return newStyle.toString();
    }

    public static String addProperty(Node node, String property) throws Exception {
        String newStyle = FxCssUtil.addProperty(node.getStyle(), property);
        node.setStyle(newStyle);
        return newStyle.toString();
    }

    public static Color setOpacity(Color baseColor, double opacity) {
        Color newColor = Color.color((double)baseColor.getRed(), (double)baseColor.getGreen(), (double)baseColor.getBlue(), (double)opacity);
        return newColor;
    }

    public static String css_backgroundColor(String propertyValue) {
        StringBuilder sb = new StringBuilder();
        if (!BcStringUtil.isEmpty(propertyValue)) {
            sb.append(CssUtil.createProperty(fx_background_color, (Object)propertyValue));
        }
        return sb.toString();
    }

    public static String css_backgroundColor(Color bgColor) {
        StringBuilder sb = new StringBuilder();
        if (bgColor != null) {
            sb.append(FxCssUtil.css_backgroundColor(FxCssUtil.toRgba(bgColor)));
        }
        return sb.toString();
    }

    public static String css_backgroundColor_linearGradient(String rgbaColor1, String rgbaColor2, int radius) {
        StringBuilder sb = new StringBuilder();
        String propertyValue = "linear-gradient(" + rgbaColor1 + "," + rgbaColor2 + ")";
        sb.append(FxCssUtil.css_backgroundColor(propertyValue));
        if (radius > 0) {
            sb.append(CssUtil.createProperty(fx_background_radius, (Object)radius));
        }
        return sb.toString();
    }

    public static String css_backgroundColor_linearGradient(Color color1, Color color2, int radius) {
        return FxCssUtil.css_backgroundColor_linearGradient(FxCssUtil.toRgba(color1), FxCssUtil.toRgba(color2), radius);
    }

    public static String css_border(String width, String radius, String rgbaColor) {
        StringBuilder sb = new StringBuilder();
        if (!BcStringUtil.isEmpty(width)) {
            sb.append(CssUtil.createProperty(fx_border_width, (Object)width));
        }
        if (!BcStringUtil.isEmpty(radius)) {
            sb.append(CssUtil.createProperty(fx_border_radius, (Object)radius));
        }
        if (!BcStringUtil.isEmpty(rgbaColor)) {
            sb.append(CssUtil.createProperty(fx_border_color, (Object)rgbaColor));
        }
        return sb.toString();
    }

    public static String css_border(int widthNum, int radiusNum, Color color) {
        String width = null;
        if (widthNum > 0) {
            width = Integer.toString(widthNum);
        }
        String radius = null;
        if (radiusNum > 0) {
            radius = Integer.toString(radiusNum);
        }
        String rgbaColor = null;
        if (color != null) {
            rgbaColor = FxCssUtil.toRgba(color);
        }
        return FxCssUtil.css_border(width, radius, rgbaColor);
    }

    public static String css_textFill(Color textFillColor) {
        StringBuilder sb = new StringBuilder();
        if (textFillColor != null) {
            sb.append(CssUtil.createProperty(fx_text_fill, (Object)FxCssUtil.toRgba(textFillColor)));
        }
        return sb.toString();
    }

    public static String css_BG_FG(Color bgColor, Color textFillColor) {
        StringBuilder sb = new StringBuilder();
        sb.append(FxCssUtil.css_backgroundColor(bgColor));
        sb.append(FxCssUtil.css_textFill(textFillColor));
        return sb.toString();
    }

    public static String getCssValue(String name, String str1) throws Exception {
        int idx2;
        int idx1 = str1.indexOf(name);
        if (idx1 < 0) {
            return null;
        }
        String str2 = str1.substring(idx1 + name.length());
        String str3 = str2.substring((idx2 = str2.indexOf(":")) + 1);
        int idx3 = str3.indexOf(";");
        String value = idx3 >= 0 ? str3.substring(0, idx3) : str3;
        value = BcStringUtil.trim(value);
        value = BcStringUtil.replace((CharSequence)value, "pt", null).toString();
        return value;
    }

    public static double getFontSizeFromStyle(Node node) throws Exception {
        String fontSizeStr;
        double fontSize;
        block3: {
            fontSize = -1.0;
            fontSizeStr = FxCssUtil.getCssValue(fx_font_size, node.getStyle());
            if (!BcStringUtil.isEmpty(fontSizeStr)) break block3;
            return -1.0;
        }
        try {
            fontSize = Double.parseDouble(fontSizeStr);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
        return fontSize;
    }

    public static String css_font(Font font) {
        StringBuilder sb = new StringBuilder();
        sb.append(CssUtil.createProperty(fx_font_family, (Object)BcStringUtil.doubleQuotation(font.getFamily())));
        sb.append(" ");
        sb.append(CssUtil.createProperty(fx_font_size, (Object)(String.valueOf(Double.toString(font.getSize())) + "pt")));
        if (!font.getStyle().equals("Regular")) {
            sb.append(" ");
            sb.append(CssUtil.createProperty(fx_font_weight, (Object)font.getStyle()));
        }
        return sb.toString();
    }

    public static String createInnershadow() {
        return "innershadow(three-pass-box ,rgba(0,0,0,0.7), 2, 0.0, 0, 1)";
    }

    public static void setStyle_form_01(TextInputControl textInputControl) throws Exception {
        StringBuilder style = new StringBuilder();
        BcStringUtil.appendExceptEmpty(style, ';', textInputControl.getStyle());
        if (textInputControl.isDisabled()) {
            BcStringUtil.appendExceptEmpty(style, ';', FxCssUtil.css_backgroundColor_linearGradient("#666666", "#888888", 4));
        } else if (textInputControl.isEditable()) {
            BcStringUtil.appendExceptEmpty(style, ';', "-fx-effect: " + FxCssUtil.createInnershadow());
        } else {
            Color textFieldReadonlyBg = FxSkinUtil.getSkin().getTextFieldReadonlyBg();
            BcStringUtil.appendExceptEmpty(style, ';', FxCssUtil.css_backgroundColor(textFieldReadonlyBg));
            BcStringUtil.appendExceptEmpty(style, ';', "-fx-effect: " + FxCssUtil.createInnershadow());
        }
        textInputControl.setStyle(style.toString());
    }

    public static BcRangeInt getelemtntRange(CharSequence style, String propertyPname) throws Exception {
        BcRangeInt rangeInt = new BcRangeInt(-1, -1);
        String styleStr = style.toString();
        rangeInt.start = styleStr.indexOf(propertyPname);
        if (rangeInt.start < 0) {
            return rangeInt;
        }
        rangeInt.end = styleStr.indexOf(59, rangeInt.start + propertyPname.length());
        if (rangeInt.end < 0) {
            rangeInt.end = style.length() - 1;
        }
        return rangeInt;
    }

    public static String createBackgroundImage(URI uri, double opacity) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("-fx-background-image: url('" + uri + "');");
        sb.append("-fx-background-position: center center;");
        sb.append("-fx-background-repeat: stretch;");
        sb.append("-fx-background-size: cover;");
        if (opacity >= 0.0) {
            sb.append("-fx-opacity: " + opacity + ";");
        }
        return sb.toString();
    }

    public static void setBackgroundColor(Region region, Color color) throws Exception {
        String css = FxCssUtil.css_backgroundColor(color);
        region.setStyle(css);
    }

    public static void setBackgroundColorForDebug(Region region) throws Exception {
        FxCssUtil.setBackgroundColor(region, Color.AQUA);
        region.setOpacity(0.8);
    }

    public static String toColorCode(java.awt.Color awtColor) throws Exception {
        String hex = AwtColorUtil.toHex(awtColor);
        return "#" + hex;
    }

    public static String toColorCode(Color color) throws Exception {
        return FxCssUtil.toColorCode(FxColorUtil.convToAwt(color));
    }
}

