/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx.extension;

import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.image.BufferedImage;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.SubScene;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.stage.Modality;
import javafx.stage.StageStyle;
import jp.co.extreme.awt.AwtImageHelper;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.stage.FxStage;
import jp.co.extreme.fx.util.FxImageHelper;

public class FxxAbstractDesktopPane
extends FxBorderPane {
    protected BorderPane topPane = new BorderPane();
    protected MenuBar menuBar;
    protected ToolBar toolBar;
    protected double height = 30.0;
    protected MenuItem exitMenuItem;
    protected MenuItem aboutMenuItem;
    protected FxScene scene;
    protected FxStage stage;

    public FxxAbstractDesktopPane() {
        this.exitMenuItem = new MenuItem(BcWords.getInstance().exit);
        this.aboutMenuItem = new MenuItem(BcWords.getInstance().aboutThisSoftware);
    }

    protected void init() throws Exception {
        this.setTop((Node)this.topPane);
        this.topPane.setPrefHeight(this.height);
        this.menuBar = this.createMenuBar();
        this.topPane.setCenter((Node)this.menuBar);
        BufferedImage awtImage = AwtImageHelper.getWindowIconImage();
        try {
            TrayIcon trayIcon = new TrayIcon(awtImage);
            trayIcon.setImageAutoSize(true);
            SystemTray.getSystemTray().add(trayIcon);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
    }

    protected void createStage() throws Exception {
        this.scene = new FxScene((Parent)this);
        this.stage = new FxStage();
        this.stage.setScene(this.scene);
        this.stage.initStyle(StageStyle.DECORATED);
        this.stage.initModality(Modality.NONE);
        this.stage.setMinHeight(this.height + 40.0);
        this.stage.setMinWidth(200.0);
    }

    public FxStage getStage() throws Exception {
        return this.stage;
    }

    protected MenuBar createMenuBar() throws Exception {
        MenuBar menuBar = new MenuBar();
        Menu menu = this.createFileMenu();
        if (menu != null) {
            menuBar.getMenus().add((Object)menu);
        }
        this.createUserMenu(menuBar);
        menu = this.createWindowMenu();
        if (menu != null) {
            menuBar.getMenus().add((Object)menu);
        }
        if ((menu = this.createHelpMenu()) != null) {
            menuBar.getMenus().add((Object)menu);
        }
        menuBar.setPrefHeight(this.height);
        return menuBar;
    }

    protected Menu createFileMenu() throws Exception {
        Menu menu = new Menu(BcWords.getInstance().file);
        this.exitMenuItem.setOnAction(this.actionEventHandler);
        this.exitMenuItem.setGraphic((Node)FxImageHelper.createImageView_icon("exit_64x64.png"));
        menu.getItems().add((Object)this.exitMenuItem);
        return menu;
    }

    protected Menu createWindowMenu() throws Exception {
        Menu menu = new Menu(BcWords.getInstance().window);
        menu.setGraphic((Node)FxImageHelper.createImageView_icon("window_64x64.png"));
        return menu;
    }

    protected Menu createHelpMenu() throws Exception {
        Menu menu = new Menu(BcWords.getInstance().help);
        menu.setGraphic((Node)FxImageHelper.createImageView_icon("help_circle_64x64.png"));
        this.aboutMenuItem.setOnAction(this.actionEventHandler);
        this.aboutMenuItem.setGraphic((Node)FxImageHelper.createImageView_icon("about_64x64.png"));
        menu.getItems().add((Object)this.aboutMenuItem);
        return menu;
    }

    protected void createUserMenu(MenuBar menuBar) throws Exception {
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.exitMenuItem) {
            this.exitAction();
        } else if (ev.getSource() == this.aboutMenuItem) {
            this.aboutAction();
        }
    }

    public void exitAction() throws Exception {
    }

    public void aboutAction() throws Exception {
    }

    public void setToolBox(Region toolBoxRegion) throws Exception {
        this.topPane.setRight((Node)toolBoxRegion);
    }

    public void setContentNode(Node contentsNode) throws Exception {
        Pane contentBasePane = new Pane();
        this.setCenter((Node)contentBasePane);
        SubScene subSceneDummy = null;
        if (contentsNode instanceof Parent) {
            Parent parent = (Parent)contentsNode;
            subSceneDummy = new SubScene(parent, contentBasePane.getWidth(), contentBasePane.getHeight());
        } else {
            BorderPane borderPane1 = new BorderPane();
            borderPane1.setCenter(contentsNode);
            subSceneDummy = new SubScene((Parent)borderPane1, contentBasePane.getWidth(), contentBasePane.getHeight());
        }
        final SubScene subScene = subSceneDummy;
        contentBasePane.getChildren().add((Object)subScene);
        contentBasePane.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldWidth, Number newWidth) {
                subScene.setWidth(newWidth.doubleValue());
            }
        });
        contentBasePane.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldHeight, Number newHeight) {
                subScene.setHeight(newHeight.doubleValue());
            }
        });
    }
}

