/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx.control;

import java.util.HashMap;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import jp.co.extreme.base.core.BcInteger;
import jp.co.extreme.swing.SwgUtil;

public class FxTabPane
extends TabPane {
    protected ChangeListener<Tab> changeListener = new ChangeListener<Tab>(){

        public void changed(ObservableValue<? extends Tab> observable, Tab oldTab, Tab newTab) {
            try {
                FxTabPane.this.tabChanged(oldTab, newTab);
            }
            catch (Exception ex) {
                FxTabPane.this.handleException(ex);
            }
        }
    };
    protected Map<Integer, BcInteger> selectionMap = new HashMap<Integer, BcInteger>();

    public FxTabPane() throws Exception {
        this.getSelectionModel().selectedItemProperty().addListener(this.changeListener);
    }

    protected void tabChanged(Tab oldTab, Tab newTab) throws Exception {
        if (newTab == null) {
            return;
        }
        BcInteger selectedCount = this.selectionMap.get(newTab.hashCode());
        if (selectedCount == null) {
            selectedCount = new BcInteger(1);
            this.selectionMap.put(newTab.hashCode(), selectedCount);
            this.tabFirstShown(newTab);
        }
    }

    protected void tabFirstShown(Tab tab) throws Exception {
    }

    protected void handleException(Throwable throwable) {
        SwgUtil.getExceptionHandler().handleException(throwable, (Object)this);
    }
}

