/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.doc.util;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.Serializable;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.doc.renderer.DcfShapeRenderer;
import jp.co.extreme.doc.util.DcfDocumentUtil;
import jp.co.extreme.doc.util.DcfPageReader;
import nlc.lib.doc.DcfPage;

public class DcfPrintable
implements Printable,
Serializable {
    private static final long serialVersionUID = -4011494562475626805L;
    protected DcfPageReader pageReader;
    protected DcfShapeRenderer shapeRenderer;
    public Point2D.Double marginPoint2D;

    public DcfPrintable(DcfPageReader pageReader) {
        this.pageReader = pageReader;
        this.shapeRenderer = new DcfShapeRenderer();
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        block7: {
            try {
                if (this.pageReader.getPageCount() > pageIndex) break block7;
                return 1;
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
                throw new PrinterException(ex.getMessage());
            }
        }
        Graphics2D g2d = (Graphics2D)g;
        DcfPage dcfPage = this.pageReader.getPage(pageIndex);
        if (this.pageReader.isBgPageEnabled() && !BcStringUtil.isEmpty(dcfPage.getOverLayName())) {
            DcfPage overLayPage = this.pageReader.getBgPage(dcfPage.getOverLayName());
            if (overLayPage != null) {
                this.shapeRenderer.drawPage(g2d, pageFormat.getImageableX(), pageFormat.getImageableY(), overLayPage);
            } else {
                BcLogUtil.warning("overLayName '" + dcfPage.getOverLayName() + " is not found.");
            }
        }
        double bx = pageFormat.getImageableX();
        double by = pageFormat.getImageableY();
        if (this.marginPoint2D != null) {
            bx += DcfDocumentUtil.mmToPixel_deprecated2(this.marginPoint2D.x);
            by += DcfDocumentUtil.mmToPixel_deprecated2(this.marginPoint2D.y);
        }
        this.shapeRenderer.drawPage(g2d, bx, by, dcfPage);
        return 0;
    }
}

