/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.doc.util;

import jp.co.extreme.doc.util.DcfDocumentUtil;
import nlc.lib.doc.DcfBook;
import nlc.lib.doc.DcfPage;
import nlc.lib.doc.shape.DcfLineShape;
import nlc.lib.doc.shape.DcfShapeGroup;

public final class DcfGaugeUtil {
    private DcfGaugeUtil() {
    }

    public static DcfShapeGroup createGauge() throws Exception {
        double m1Size = 1.5;
        double m5Size = 3.0;
        double m10Size = 4.0;
        double x1 = 0.0;
        double y1 = 65.0;
        double w1 = 100.0;
        DcfShapeGroup gaugeGroup = new DcfShapeGroup();
        gaugeGroup.setRect(0.0, 0.0, DcfDocumentUtil.mmToPixel(w1), DcfDocumentUtil.mmToPixel(20.0));
        DcfLineShape lineShape = new DcfLineShape();
        lineShape.getLine().setLine(DcfDocumentUtil.mmToPixel(x1), DcfDocumentUtil.mmToPixel(y1), DcfDocumentUtil.mmToPixel(x1 + w1), DcfDocumentUtil.mmToPixel(y1));
        gaugeGroup.addShape(lineShape);
        int i = 0;
        while ((double)i <= w1) {
            double mx1 = x1 + (double)i;
            double lSize = m1Size;
            if (i % 5 == 0) {
                lSize = m5Size;
            } else if (i % 10 == 0) {
                lSize = m10Size;
            }
            double my1 = y1 - lSize / 2.0;
            double my2 = y1 + lSize / 2.0;
            lineShape = new DcfLineShape();
            lineShape.getLine().setLine(DcfDocumentUtil.mmToPixel(mx1), DcfDocumentUtil.mmToPixel(my1), DcfDocumentUtil.mmToPixel(mx1), DcfDocumentUtil.mmToPixel(my2));
            gaugeGroup.addShape(lineShape);
            ++i;
        }
        return gaugeGroup;
    }

    public static void setGauge(DcfBook dcfBook) throws Exception {
        int i = 0;
        while (i < dcfBook.getPageCount()) {
            DcfPage dcfPage = dcfBook.getPage(i);
            DcfShapeGroup gaugeGroup = DcfGaugeUtil.createGauge();
            dcfPage.addGroup(gaugeGroup);
            ++i;
        }
    }
}

