/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.css.common;

import java.awt.Color;
import java.util.ArrayList;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.css.common.CssConstants;
import jp.co.extreme.html.common.HtmlBuilder;
import jp.co.extreme.html.common.HtmlConstants;
import jp.co.extreme.html.util.HtmlUtil;

public final class CssUtil {
    static HtmlBuilder htmlBuilder = HtmlBuilder.getInstance();
    public static final String SS_textFieldRight = "style=\"text-align:right\"";
    public static final String SS_textFieldBgGray = "style=\"background-color:EAEAEA\"";

    private CssUtil() {
    }

    public static String createProperty(CharSequence name, Object value) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append(": ");
        sb.append(BcStringUtil.toString(value));
        sb.append(";");
        return sb.toString();
    }

    public static String createProperty(CssConstants.CssProperty cssProperty, Object value) {
        return CssUtil.createProperty(cssProperty.propertyName, value);
    }

    public static String toRgba(int red, int green, int blue, double opacity) {
        StringBuilder sb = new StringBuilder();
        sb.append("rgba(");
        sb.append(red);
        sb.append(", ");
        sb.append(green);
        sb.append(", ");
        sb.append(blue);
        if (opacity >= 0.0) {
            sb.append(", ");
            sb.append(opacity);
        }
        sb.append(")");
        return sb.toString();
    }

    public static String toRgba(Color color, double opacity) {
        return CssUtil.toRgba(color.getRed(), color.getGreen(), color.getBlue(), opacity);
    }

    public static String toRgba(Color color) {
        return CssUtil.toRgba(color, -1.0);
    }

    public static String cssLink(String url) {
        StringBuilder sb = new StringBuilder();
        sb.append("<link rel=\"stylesheet\"");
        sb.append(" href=" + BcStringUtil.doubleQuotation(url));
        sb.append(">");
        sb.append(CssUtil.htmlBuilder.lineSep);
        return sb.toString();
    }

    public static StringBuilder createStyle(int fontSize, int textAalign, String bgColor, String fgColor) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("text-decoration:none");
        if (fontSize > 0) {
            list.add("font-dataSize:" + fontSize + "px");
        }
        switch (textAalign) {
            case 2: {
                list.add("text-align:left");
                break;
            }
            case 0: {
                list.add("text-align:center");
                break;
            }
            case 4: {
                list.add("text-align:right");
            }
        }
        if (!BcStringUtil.isEmpty(bgColor)) {
            list.add("background-color:" + bgColor);
        }
        if (!BcStringUtil.isEmpty(fgColor)) {
            list.add("color:" + fgColor);
        }
        StringBuilder sb1 = new StringBuilder(BcStringUtil.marge(list, ";"));
        StringBuilder sb2 = new StringBuilder();
        if (sb1.length() > 0) {
            sb2.append("style=");
            sb2.append(BcStringUtil.doubleQuotation(sb1));
        }
        return sb2;
    }

    public static StringBuilder createStyle(int textAalign, String bgColor, String fgColor) throws Exception {
        return CssUtil.createStyle(-1, textAalign, bgColor, fgColor);
    }

    public static StringBuilder createStyle(int textAalign) throws Exception {
        return CssUtil.createStyle(-1, textAalign, null, null);
    }

    public static String toAlign(int swingAlign) throws Exception {
        String alignName = null;
        CssConstants.CssAlign[] cssAlignArray = CssConstants.CssAlign.values();
        int n = cssAlignArray.length;
        int n2 = 0;
        while (n2 < n) {
            CssConstants.CssAlign align = cssAlignArray[n2];
            if (swingAlign == align.swingAlign) {
                alignName = align.name();
            }
            ++n2;
        }
        return alignName;
    }

    public static StringBuilder cssLink(String linkColor, String visitedColor, String activeColor, String hoverColor, String bgImage) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<STYLE TYPE=\"text/css\">");
        sb.append(CssUtil.htmlBuilder.lineSep);
        sb.append("<!--");
        sb.append(CssUtil.htmlBuilder.lineSep);
        if (!BcStringUtil.isEmpty(linkColor)) {
            sb.append("A:link {" + CssUtil.createStyle(-1, -1, null, linkColor) + " }");
            sb.append(CssUtil.htmlBuilder.lineSep);
        }
        if (!BcStringUtil.isEmpty(visitedColor)) {
            sb.append("A:visited {" + CssUtil.createStyle(-1, -1, null, visitedColor) + " }");
            sb.append(CssUtil.htmlBuilder.lineSep);
        } else if (!BcStringUtil.isEmpty(linkColor)) {
            sb.append("A:visited {" + CssUtil.createStyle(-1, -1, null, linkColor) + " }");
            sb.append(CssUtil.htmlBuilder.lineSep);
        }
        if (!BcStringUtil.isEmpty(activeColor)) {
            sb.append("A:active {" + CssUtil.createStyle(-1, -1, null, activeColor) + " }");
            sb.append(CssUtil.htmlBuilder.lineSep);
        } else if (!BcStringUtil.isEmpty(linkColor)) {
            sb.append("A:active {" + CssUtil.createStyle(-1, -1, null, linkColor) + " }");
            sb.append(CssUtil.htmlBuilder.lineSep);
        }
        if (!BcStringUtil.isEmpty(hoverColor)) {
            sb.append("A:hover {" + CssUtil.createStyle(-1, -1, HtmlConstants.HtmlColor.darkblue.name(), hoverColor) + " }");
            sb.append(CssUtil.htmlBuilder.lineSep);
        }
        sb.append("H2 { font-dataSize:24px; line-height:1.2em; font-family:'serif','\uff2d\uff33 \uff30\u660e\u671d','\uff2d\uff33 \u660e\u671d'; }");
        sb.append(CssUtil.htmlBuilder.lineSep);
        if (!BcStringUtil.isEmpty(bgImage)) {
            sb.append("BODY { background-color: white; background-image: url(\"" + HtmlUtil.encode(bgImage) + "\");" + " background-repeat: no-repeat" + " }");
        }
        sb.append(CssUtil.htmlBuilder.lineSep);
        sb.append("-->");
        sb.append(CssUtil.htmlBuilder.lineSep);
        sb.append("</STYLE>");
        sb.append(CssUtil.htmlBuilder.lineSep);
        return sb;
    }

    public static String getTextFieldClass(boolean editable) {
        if (editable) {
            return "textFieldEnable";
        }
        return "textFieldDisable";
    }

    public static String getTableRowClass(int row) {
        String cssClass = null;
        cssClass = row % 2 == 0 ? "table01TrEven" : "table01TrOdd";
        return cssClass;
    }

    public static String underScoreToHyphen(String str) {
        return str.replace(BcStringUtil.UNDER_SCORE_STR, BcStringUtil.HYPHEN_STR);
    }
}

