/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;

public final class BcSIUnitUtil {
    private BcSIUnitUtil() {
    }

    public static SiUnit getSiUnit(String symbol) throws Exception {
        SiUnit[] siUnitArray = SiUnit.values();
        int n = siUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            SiUnit siUnit = siUnitArray[n2];
            if (siUnit.name().equals(symbol)) {
                return siUnit;
            }
            ++n2;
        }
        return null;
    }

    public static int getExponet(String symbol) throws Exception {
        if (BcStringUtil.isEmpty(symbol)) {
            return 0;
        }
        SiUnit[] siUnitArray = SiUnit.values();
        int n = siUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            SiUnit siUnit = siUnitArray[n2];
            if (siUnit.name().equals(symbol)) {
                return siUnit.exponet;
            }
            ++n2;
        }
        throw new Exception(String.format("Not suppoted symbol '%s'.", symbol));
    }

    public static BigDecimal convUnit(BigDecimal bigDecimal, SiUnit siUnit1, SiUnit siUnit2) throws Exception {
        int gap = siUnit1.exponet - siUnit2.exponet;
        return bigDecimal.movePointRight(gap);
    }

    public static BigDecimal convUnit(Number number, SiUnit siUnit1, SiUnit siUnit2) throws Exception {
        BigDecimal bigDecimal = new BigDecimal(number.toString());
        return BcSIUnitUtil.convUnit(bigDecimal, siUnit1, siUnit2);
    }

    public static BigDecimal convUnit(Number number, String unitPrefix1, String unitPrefix2) throws Exception {
        return BcSIUnitUtil.convUnit(number, BcSIUnitUtil.getSiUnit(unitPrefix1), BcSIUnitUtil.getSiUnit(unitPrefix2));
    }

    public static BigDecimal binaryByte(BigDecimal baseValue, BinaryByteUnit binaryByteUnit) throws Exception {
        BigDecimal bigDecimal = new BigDecimal(2);
        bigDecimal = bigDecimal.pow(binaryByteUnit.exponet);
        bigDecimal = bigDecimal.multiply(baseValue);
        return bigDecimal;
    }

    public static BigDecimal binaryByte(double baseValue, BinaryByteUnit binaryByteUnit) throws Exception {
        return BcSIUnitUtil.binaryByte(new BigDecimal(baseValue), binaryByteUnit);
    }

    public static long binaryByteLong(double baseValue, BinaryByteUnit binaryByteUnit) throws Exception {
        BigDecimal bigDecimal = BcSIUnitUtil.binaryByte(baseValue, binaryByteUnit);
        if (bigDecimal.doubleValue() <= 9.223372036854776E18) {
            return bigDecimal.longValue();
        }
        throw new IllegalArgumentException("binaryByteUnit=" + (Object)((Object)binaryByteUnit));
    }

    public static double weightConvert(double v1, String u1, String u2) throws Exception {
        u1 = BcStringUtil.replace((CharSequence)u1, "t", "M").toString();
        String u1SiPrefix = BcStringUtil.replace((CharSequence)u1, "g", "").toString();
        int m1 = BcSIUnitUtil.getExponet(u1SiPrefix);
        u2 = BcStringUtil.replace((CharSequence)u2, "t", "M").toString();
        String u2SiPrefix = BcStringUtil.replace((CharSequence)u2, "g", "").toString();
        int m2 = BcSIUnitUtil.getExponet(u2SiPrefix);
        double resValue = v1 * Math.pow(10.0, m1 - m2);
        return resValue;
    }

    public static String[] toByteString0(long byteSize) throws Exception {
        double byteSizeWk = byteSize;
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int counter = 0;
        while (byteSizeWk > 1024.0) {
            byteSizeWk /= 1024.0;
            ++counter;
        }
        BigDecimal bd = new BigDecimal(byteSizeWk);
        BigDecimal bd2 = bd.setScale(1, RoundingMode.HALF_UP);
        String numStr = BcNumberUtil.toString(bd2.stripTrailingZeros());
        String[] res = new String[]{numStr, units[counter]};
        return res;
    }

    public static String toByteString(long byteSize, String sep) throws Exception {
        String[] res = BcSIUnitUtil.toByteString0(byteSize);
        StringBuilder sb = new StringBuilder();
        sb.append(res[0]);
        if (!BcStringUtil.isEmpty(sep)) {
            sb.append(sep);
        }
        sb.append(res[1]);
        return sb.toString();
    }

    public static String toByteString(long byteSize) throws Exception {
        return BcSIUnitUtil.toByteString(byteSize, null);
    }

    public static enum BinaryByteUnit {
        KiB(10),
        MiB(20),
        GiB(30),
        TiB(40),
        PiB(50),
        EiB(60),
        ZiB(70),
        YiB(80),
        QiB(90);

        public final int exponet;

        private BinaryByteUnit(int exponet) {
            this.exponet = exponet;
        }
    }

    public static enum SiUnit {
        Q(30, "quetta", "nonillion", "\u767e\u7a63"),
        R(27, "ronna", "octillion", "\u5343\ud855\udf71"),
        Y(24, "yotta", "septillion", "\u4e00\ud855\udf71"),
        Z(21, "zetta", "sextillion", "\u5341\u5793"),
        E(18, "exa", "quintillion", "\u767e\u4eac"),
        P(15, "peta", "quadrillion", "\u5343\u5146"),
        T(12, "tera", "trillion", "\u4e00\u5146"),
        G(9, "giga", "billion", " \u5341\u5104"),
        M(6, "mega", "million", "\u767e\u4e07"),
        k(3, "kilo", "thousand", "\u5343"),
        h(2, "hecto", "hundred", "\u767e"),
        da(1, "deca", "ten", "\u5341"),
        d(-1, "deci", "tenth", "\u4e00\u5206"),
        c(-2, "centi", "hundredth", "\u4e00\u5398"),
        m(-3, "milli", "thousandth", "\u4e00\u6bdb"),
        u(-6, "micro", "millionth", "\u4e00\u5fae"),
        \u03bc(-6, "micro", "millionth", "\u4e00\u5fae"),
        n(-9, "nano", "billionth", "\u4e00\u5875"),
        p(-12, "pico", "trillionth", " \u4e00\u6f20"),
        f(-15, "femto", "quadrillionth", "\u4e00\u9808\u81fe"),
        a(-18, "atto", "quintillionth", "\u4e00\u5239\u90a3"),
        z(-21, "zepto", "sextillionth", "\u4e00\u6e05\u6d44"),
        y(-24, "yocto", "septillionth", null),
        r(-27, "ronto", "octillionth", null),
        q(-30, "quecto", "nonillionth", null);

        public final int exponet;
        public final String prefix;
        public final String shortScale;
        public final String kanji;

        private SiUnit(int exponet, String prefix, String shortScale, String kanji) {
            this.exponet = exponet;
            this.prefix = prefix;
            this.shortScale = shortScale;
            this.kanji = kanji;
        }
    }
}

