/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.util;

import java.util.HashMap;
import java.util.Map;
import jp.co.extreme.base.util.BcReflectUtil;

public class BcObjectPoolManager {
    private Map<Object, Object> objectMap = new HashMap<Object, Object>();

    public BcObjectPoolManager() {
        this.clear();
    }

    public static BcObjectPoolManager getInstance() {
        return SingletonHolder.instance;
    }

    public void clear() {
        this.objectMap.clear();
    }

    public void addObject(Object key, Object obj) {
        this.objectMap.put(key, obj);
    }

    public Object getObject(Object key) {
        return this.objectMap.get(key);
    }

    public Object getObject(Object key, Class clazz, boolean create) throws Exception {
        Object obj = this.getObject(key);
        if (obj != null && create) {
            obj = BcReflectUtil.createInstance(clazz);
            this.addObject(key, obj);
        }
        return obj;
    }

    public Object getObject(Object key, String className, boolean create) throws Exception {
        Class<?> clazz = Class.forName(className);
        return this.getObject(key, clazz, create);
    }

    public Object getObject(Object key, boolean create) throws Exception {
        return this.getObject(key, key.toString(), create);
    }

    private static final class SingletonHolder {
        private static final BcObjectPoolManager instance = new BcObjectPoolManager();

        private SingletonHolder() {
        }
    }
}

