/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.util;

import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;

public final class BcKanaUtil {
    public static final char ZENKANA_\u30a2 = '\u30a1';
    public static final char ZENKANA_\u30f0 = '\u30f0';
    public static final char ZENKANA_\u30f1 = '\u30f1';
    public static final char ZENKANA_\u30f2 = '\u30f2';
    public static final char ZENKANA_\u30f3 = '\u30f3';
    public static final char ZENKANA_\u30f4 = '\u30f4';
    public static final char ZENKANA_\u30f5 = '\u30f5';
    public static final char ZENKANA_\u30f6 = '\u30f6';
    public static final char ZENKANA_\u30f7 = '\u30f7';
    public static final char ZENKANA_\u30f8 = '\u30f8';
    public static final char ZENKANA_\u30f9 = '\u30f9';
    public static final char ZENKANA_\u30fa = '\u30fa';
    public static final String ZENKANA_BOIN = "\u30a2\u30a4\u30a6\u30a8\u30aa";
    public static final String ZENKANA_DAKUON_SEION = "\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30cf\u30d2\u30d5\u30d8\u30db";
    public static final String ZENKANA_DAKUON = "\u30ac\u30ae\u30b0\u30b2\u30b4\u30b6\u30b8\u30ba\u30bc\u30be\u30c0\u30c2\u30c5\u30c7\u30c9\u30d0\u30d3\u30d6\u30d9\u30dc";
    public static final String ZENKANA_HANDAKUON_SEION = "\u30cf\u30d2\u30d5\u30d8\u30db";
    public static final String ZENKANA_HANDAKUON = "\u30d1\u30d4\u30d7\u30da\u30dd";
    public static final String ZENKANA_SUTEGANA = "\u30a1\u30a3\u30a5\u30a7\u30a9\u30e3\u30e5\u30e7";
    public static final String ZENKANA_YOUON = "\u30e3\u30e5\u30e7";
    public static final char ZENKANA_START = '\u30a1';
    public static final char ZENKANA_END = '\u30f4';
    public static final char HIRAGANA_START = '\u3041';
    public static final char HIRAGANA_END = '\u3094';
    public static final char HIRAGANA_KANA_OFFSET = '`';
    public static final char[] HANKANA_ARRAY = new char[]{'\uff61', '\uff62', '\uff63', '\uff64', '\uff65', '\uff66', '\uff67', '\uff68', '\uff69', '\uff6a', '\uff6b', '\uff6c', '\uff6d', '\uff6e', '\uff6f', '\uff70', '\uff71', '\uff72', '\uff73', '\uff74', '\uff75', '\uff76', '\uff77', '\uff78', '\uff79', '\uff7a', '\uff7b', '\uff7c', '\uff7d', '\uff7e', '\uff7f', '\uff80', '\uff81', '\uff82', '\uff83', '\uff84', '\uff85', '\uff86', '\uff87', '\uff88', '\uff89', '\uff8a', '\uff8b', '\uff8c', '\uff8d', '\uff8e', '\uff8f', '\uff90', '\uff91', '\uff92', '\uff93', '\uff94', '\uff95', '\uff96', '\uff97', '\uff98', '\uff99', '\uff9a', '\uff9b', '\uff9c', '\uff9d', '\uff9e', '\uff9f'};
    public static final char[] ZENKANA_ARRAY_4_HANAKANA = new char[]{'\u3002', '\u300c', '\u300d', '\u3001', '\u30fb', '\u30f2', '\u30a1', '\u30a3', '\u30a5', '\u30a7', '\u30a9', '\u30e3', '\u30e5', '\u30e7', '\u30c3', '\u30fc', '\u30a2', '\u30a4', '\u30a6', '\u30a8', '\u30aa', '\u30ab', '\u30ad', '\u30af', '\u30b1', '\u30b3', '\u30b5', '\u30b7', '\u30b9', '\u30bb', '\u30bd', '\u30bf', '\u30c1', '\u30c4', '\u30c6', '\u30c8', '\u30ca', '\u30cb', '\u30cc', '\u30cd', '\u30ce', '\u30cf', '\u30d2', '\u30d5', '\u30d8', '\u30db', '\u30de', '\u30df', '\u30e0', '\u30e1', '\u30e2', '\u30e4', '\u30e6', '\u30e8', '\u30e9', '\u30ea', '\u30eb', '\u30ec', '\u30ed', '\u30ef', '\u30f3', '\u309b', '\u309c'};
    public static final char HANAKANA_KUTEN = '\uff61';
    public static final char HANAKANA_\u30f2 = '\uff66';
    public static final char HANAKANA_\uff6f = '\uff6f';
    public static final char HANKANA_TYOUONFU = '\uff70';
    public static final char HANAKANA_\uff71 = '\uff71';
    public static final char HANAKANA_\uff9c = '\uff9c';
    public static final char HANAKANA_\uff9d = '\uff9d';
    public static final char HANAKANA_DAKUTEN = '\uff9e';
    public static final char HANAKANA_DAKUTEN2 = '\u309b';
    public static final char HANKANA_HANDAKUTEN = '\uff9f';
    public static final String HANKANA_DAKUON_SEION = "\uff76\uff77\uff78\uff79\uff7a\uff7b\uff7c\uff7d\uff7e\uff7f\uff80\uff81\uff82\uff83\uff84\uff8a\uff8b\uff8c\uff8d\uff8e";
    public static final String HANKANA_HANDAKUON_SEION = "\uff8a\uff8b\uff8c\uff8d\uff8e";
    public static final char HANAKANA_STRAT = '\uff61';
    public static final char HANAKANA_END = '\uff9f';
    public static final char[] HANAKANA_DAKUTEN_ARRAY = new char[]{'\uff9e', '\u309b'};
    public static final String ZENKANA_\u30a1\u30a3\u30a5\u30a7\u30a9\u30c3\u30e3\u30e5\u30e7 = "\u30ac\u30ae\u30b0\u30b2\u30b4\u30b6\u30b8\u30ba\u30bc\u30be\u30c0\u30c2\u30c5\u30c7\u30c9\u30d0\u30d3\u30d6\u30d9\u30dc\u30d1\u30d4\u30d7\u30da\u30dd\u30a1\u30a3\u30a5\u30a7\u30a9\u30c3\u30e3\u30e5\u30e7";
    public static final String ZENKANA_\u30a2\u30a4\u30a6\u30a8\u30aa\u30c4\u30e4\u30e6\u30e8 = "\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30cf\u30d2\u30d5\u30d8\u30db\u30cf\u30d2\u30d5\u30d8\u30db\u30a2\u30a4\u30a6\u30a8\u30aa\u30c4\u30e4\u30e6\u30e8";
    public static char[] akasatanaKanaArray = new char[]{'\u30a2', '\u30ab', '\u30b5', '\u30bf', '\u30ca', '\u30cf', '\u30de', '\u30e4', '\u30e9', '\u30ef'};
    public static final String kanaHLineA = "\u3042\u3041\u3044\u3043\u3046\u3045\u3048\u3047\u304a\u3049";
    public static final String kanaHLineK = "\u304b\u304c\u304d\u304e\u304f\u3050\u3051\u3052\u3053\u3054";
    public static final String kanaHLineS = "\u3055\u3056\u3057\u3058\u3059\u305a\u305b\u305c\u305d\u305e";
    public static final String kanaHLineT = "\u305f\u3060\u3061\u3062\u3063\u3064\u3065\u3066\u3067\u3068\u3069";
    public static final String kanaHLineN = "\u306a\u306b\u306c\u306d\u306e";
    public static final String kanaHLineH = "\u306f\u3070\u3071\u3072\u3073\u3074\u3075\u3076\u3077\u3078\u3079\u307a\u307b\u307c\u307d";
    public static final String kanaHLineM = "\u307e\u307f\u3080\u3081\u3082";
    public static final String kanaHLineY = "\u3084\u3083\u3086\u3085\u3088\u3087";
    public static final String kanaHLineR = "\u3089\u308a\u308b\u308c\u308d";
    public static final String kanaHLineW = "\u308e\u308f\u3090\u3091\u3092\u3093";

    private BcKanaUtil() {
    }

    public static boolean isZenkana(char aChar) throws Exception {
        return aChar >= '\u30a1' && aChar <= '\u30f4';
    }

    public static boolean isZenkana(String str) throws Exception {
        if (BcStringUtil.isEmpty(str)) {
            return false;
        }
        int i = 0;
        while (i < str.length()) {
            char aChar = str.charAt(i);
            if (!BcKanaUtil.isZenkana(aChar)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isHankanaDakuten(char aChar) throws Exception {
        int i = 0;
        while (i < HANAKANA_DAKUTEN_ARRAY.length) {
            if (aChar == HANAKANA_DAKUTEN_ARRAY[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isHiragana(char aChar) throws Exception {
        return aChar >= '\u3041' && aChar <= '\u3094';
    }

    public static boolean isHiragana(String str) throws Exception {
        if (BcStringUtil.isEmpty(str)) {
            return false;
        }
        int i = 0;
        while (i < str.length()) {
            char aChar = str.charAt(i);
            if (!BcKanaUtil.isHiragana(aChar)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static char mergeHanKanaChar(char char1, char char2) throws Exception {
        int index;
        char resChar = char1;
        if (BcKanaUtil.isHankanaDakuten(char2)) {
            int index2 = HANKANA_DAKUON_SEION.indexOf(char1);
            if (index2 >= 0) {
                resChar = ZENKANA_DAKUON.charAt(index2);
            }
        } else if (char2 == '\uff9f' && (index = HANKANA_HANDAKUON_SEION.indexOf(char1)) >= 0) {
            resChar = ZENKANA_HANDAKUON.charAt(index);
        }
        return resChar;
    }

    public static boolean isValidZenKana4HanKana(char src) throws Exception {
        return src >= ZENKANA_ARRAY_4_HANAKANA[0] && src <= ZENKANA_ARRAY_4_HANAKANA[HANKANA_ARRAY.length - 1];
    }

    public static char hanKanaToZenKana(char src) throws Exception {
        char convertedChar = '\u0000';
        if (src >= HANKANA_ARRAY[0] && src <= HANKANA_ARRAY[HANKANA_ARRAY.length - 1]) {
            convertedChar = ZENKANA_ARRAY_4_HANAKANA[src - HANKANA_ARRAY[0]];
        }
        return convertedChar;
    }

    public static String hanKanaToZenKana(String src, int mode) throws Exception {
        if (src == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(src.length());
        int pos = -1;
        block4: while (++pos < src.length()) {
            char char1;
            char margedChar = char1 = src.charAt(pos);
            if (pos < src.length() - 1) {
                margedChar = BcKanaUtil.mergeHanKanaChar(char1, src.charAt(pos + 1));
            }
            if (char1 != margedChar) {
                sb.append(margedChar);
                ++pos;
                continue;
            }
            char convertedChar = BcKanaUtil.hanKanaToZenKana(char1);
            if (convertedChar > '\u0000') {
                sb.append(convertedChar);
                continue;
            }
            switch (mode) {
                case 3: {
                    continue block4;
                }
                case 2: {
                    sb.append(char1);
                    continue block4;
                }
            }
            throw new Exception("convert error:src='" + src + "' char1='" + char1 + "'");
        }
        return sb.toString();
    }

    public static String hanKanaToZenKana(String src) throws Exception {
        return BcKanaUtil.hanKanaToZenKana(src, 0);
    }

    public static String zenKanaToHanKana(String src, int mode) throws Exception {
        if (src == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(src.length());
        int pos = -1;
        block4: while (++pos < src.length()) {
            char char1 = src.charAt(pos);
            char convertedChar = '\u0000';
            int i = 0;
            while (i < ZENKANA_ARRAY_4_HANAKANA.length) {
                if (char1 == ZENKANA_ARRAY_4_HANAKANA[i]) {
                    convertedChar = HANKANA_ARRAY[i];
                    break;
                }
                ++i;
            }
            if (convertedChar > '\u0000') {
                sb.append(convertedChar);
                continue;
            }
            int index = ZENKANA_DAKUON.indexOf(char1);
            if (index >= 0) {
                sb.append(HANKANA_DAKUON_SEION.charAt(index));
                sb.append('\uff9e');
                continue;
            }
            index = ZENKANA_HANDAKUON.indexOf(char1);
            if (index >= 0) {
                sb.append(HANKANA_HANDAKUON_SEION.charAt(index));
                sb.append('\uff9f');
                continue;
            }
            switch (mode) {
                case 3: {
                    continue block4;
                }
                case 2: {
                    sb.append(char1);
                    continue block4;
                }
            }
            throw new Exception("convert error:src='" + src + "' char1='" + char1 + "'");
        }
        return sb.toString();
    }

    public static String zenKanaToHanKana(String src) throws Exception {
        return BcKanaUtil.zenKanaToHanKana(src, 0);
    }

    public static String hiraganaToZenKana(String src, int mode) throws Exception {
        if (src == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(src.length());
        int pos = -1;
        block4: while (++pos < src.length()) {
            char char1 = src.charAt(pos);
            if (char1 >= '\u3041' && char1 <= '\u3094') {
                sb.append((char)(char1 + 96));
                continue;
            }
            switch (mode) {
                case 3: {
                    continue block4;
                }
                case 2: {
                    sb.append(char1);
                    continue block4;
                }
            }
            throw new Exception("convert error:src='" + src + "' char1='" + char1 + "'");
        }
        return sb.toString();
    }

    public static String hiraganaToZenKana(String src) throws Exception {
        return BcKanaUtil.hiraganaToZenKana(src, 0);
    }

    public static String zenKanaToHiragana(String src, int mode) throws Exception {
        if (src == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(src.length());
        int pos = -1;
        block4: while (++pos < src.length()) {
            char char1 = src.charAt(pos);
            if (BcKanaUtil.isZenkana(char1)) {
                sb.append((char)(char1 - 96));
                continue;
            }
            switch (mode) {
                case 3: {
                    continue block4;
                }
                case 2: {
                    sb.append(char1);
                    continue block4;
                }
            }
            throw new Exception("convert error:src='" + src + "' char1='" + char1);
        }
        return sb.toString();
    }

    public static String zenKanaToSimple(String src, int mode) throws Exception {
        if (src == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(src.length());
        int pos = -1;
        block8: while (++pos < src.length()) {
            char char1 = src.charAt(pos);
            if (BcKanaUtil.isValidZenKana4HanKana(char1)) {
                sb.append(char1);
                continue;
            }
            char1 = src.charAt(pos);
            int index = ZENKANA_DAKUON.indexOf(char1);
            if (index >= 0) {
                sb.append(ZENKANA_DAKUON_SEION.charAt(index));
                continue;
            }
            index = ZENKANA_HANDAKUON.indexOf(char1);
            if (index >= 0) {
                sb.append(ZENKANA_HANDAKUON_SEION.charAt(index));
                continue;
            }
            index = ZENKANA_\u30a1\u30a3\u30a5\u30a7\u30a9\u30c3\u30e3\u30e5\u30e7.indexOf(char1);
            if (index >= 0) {
                sb.append(ZENKANA_\u30a2\u30a4\u30a6\u30a8\u30aa\u30c4\u30e4\u30e6\u30e8.charAt(index));
                continue;
            }
            switch (char1) {
                case '\u30f4': {
                    sb.append('\u30d5');
                }
                case '\u30fc': {
                    continue block8;
                }
            }
            if (char1 >= '\u30a1' && char1 <= '\u30f3') {
                sb.append(char1);
                continue;
            }
            switch (mode) {
                case 1: {
                    throw new Exception("convert error:src='" + src + "' char1='" + char1 + "'");
                }
                case 2: {
                    sb.append(char1);
                    continue block8;
                }
            }
        }
        return sb.toString();
    }

    public static String zenKanaToSimple(String src) throws Exception {
        return BcKanaUtil.zenKanaToSimple(src, 0);
    }

    public static List getLineIndexList(char kanaChar) throws Exception {
        String charStrs = BcKanaUtil.getKanaArray2(kanaChar);
        ArrayList<String> strList = new ArrayList<String>(charStrs.length());
        int i = 0;
        while (i < charStrs.length()) {
            strList.add(charStrs.substring(i, i + 1));
            ++i;
        }
        return strList;
    }

    public static String getKanaArray2(char kanaChar) throws Exception {
        switch (kanaChar) {
            case '\u3042': {
                return kanaHLineA;
            }
            case '\u304b': {
                return kanaHLineK;
            }
            case '\u3055': {
                return kanaHLineS;
            }
            case '\u305f': {
                return kanaHLineT;
            }
            case '\u306a': {
                return kanaHLineN;
            }
            case '\u306f': {
                return kanaHLineH;
            }
            case '\u307e': {
                return kanaHLineM;
            }
            case '\u3084': {
                return kanaHLineY;
            }
            case '\u3089': {
                return kanaHLineR;
            }
            case '\u308f': {
                return kanaHLineW;
            }
        }
        return null;
    }
}

