/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.app.common;

import java.util.Calendar;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.net.BcAddressPort;
import jp.co.extreme.base.net.BcConnectionCondition;
import jp.co.extreme.base.xml.BcXmlUtil;
import org.w3c.dom.Node;

public final class AfbXmlUtil {
    private AfbXmlUtil() {
    }

    public static Calendar parseDate(Node baseNode, String path) throws Exception {
        Node domNode = BcXmlUtil.getNode(baseNode, path, false);
        if (domNode == null) {
            return null;
        }
        String strValue = BcXmlUtil.getValue(domNode, 3, null);
        if (!BcStringUtil.isEmpty(strValue)) {
            String formatPattern = BcXmlUtil.getAttribute(domNode, "format", "yyyy/MM/dd");
            Calendar calendar = null;
            try {
                calendar = BcTimeUtil.toCalendar(strValue, formatPattern);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return calendar;
        }
        return null;
    }

    public static void parseAddressPort(Node baseNode, BcAddressPort addressPort) throws Exception {
        addressPort.address = BcXmlUtil.getTextValue(baseNode, "address");
        addressPort.port = BcNumberUtil.parseInt(BcXmlUtil.getTextValue(baseNode, "port"), -1);
    }

    public static BcAddressPort parseAddressPort(Node baseNode) throws Exception {
        BcAddressPort addressPort = new BcAddressPort();
        AfbXmlUtil.parseAddressPort(baseNode, addressPort);
        return addressPort;
    }

    public static void parseConnectionCondition(Node baseNode, BcConnectionCondition connectionCondition) throws Exception {
        connectionCondition.connectionTimeout = BcNumberUtil.parseInt(BcXmlUtil.getTextValue(baseNode, "connectionTimeout"), -1);
        connectionCondition.socketTimeout = BcNumberUtil.parseInt(BcXmlUtil.getTextValue(baseNode, "socketTimeout"), -1);
    }
}

