/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import sun.security.util.Debug;

public class KeyStore {
    private static final Debug pdebug = Debug.getInstance("provider", "Provider");
    private static final boolean skipDebug = Debug.isOn("engine=") && !Debug.isOn("keystore");
    private static final String KEYSTORE_TYPE = "keystore.type";
    private String type;
    private Provider provider;
    private KeyStoreSpi keyStoreSpi;
    private boolean initialized = false;

    protected KeyStore(KeyStoreSpi keyStoreSpi, Provider provider, String string) {
        this.keyStoreSpi = keyStoreSpi;
        this.provider = provider;
        this.type = string;
        if (!skipDebug && pdebug != null) {
            pdebug.println("KeyStore." + string.toUpperCase() + " type from: " + this.getProviderName());
        }
    }

    private String getProviderName() {
        return this.provider == null ? "(no provider)" : this.provider.getName();
    }

    public static KeyStore getInstance(String string) throws KeyStoreException {
        try {
            Object[] objectArray = Security.getImpl(string, "KeyStore", (String)null);
            return new KeyStore((KeyStoreSpi)objectArray[0], (Provider)objectArray[1], string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyStoreException(string + " not found", noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new KeyStoreException(string + " not found", noSuchProviderException);
        }
    }

    public static KeyStore getInstance(String string, String string2) throws KeyStoreException, NoSuchProviderException {
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("missing provider");
        }
        try {
            Object[] objectArray = Security.getImpl(string, "KeyStore", string2);
            return new KeyStore((KeyStoreSpi)objectArray[0], (Provider)objectArray[1], string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyStoreException(string + " not found", noSuchAlgorithmException);
        }
    }

    public static KeyStore getInstance(String string, Provider provider) throws KeyStoreException {
        if (provider == null) {
            throw new IllegalArgumentException("missing provider");
        }
        try {
            Object[] objectArray = Security.getImpl(string, "KeyStore", provider);
            return new KeyStore((KeyStoreSpi)objectArray[0], (Provider)objectArray[1], string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyStoreException(string + " not found", noSuchAlgorithmException);
        }
    }

    public static final String getDefaultType() {
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return Security.getProperty(KeyStore.KEYSTORE_TYPE);
            }
        });
        if (string == null) {
            string = "jks";
        }
        return string;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getType() {
        return this.type;
    }

    public final Key getKey(String string, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineGetKey(string, cArray);
    }

    public final Certificate[] getCertificateChain(String string) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineGetCertificateChain(string);
    }

    public final Certificate getCertificate(String string) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineGetCertificate(string);
    }

    public final Date getCreationDate(String string) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineGetCreationDate(string);
    }

    public final void setKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        if (key instanceof PrivateKey && (certificateArray == null || certificateArray.length == 0)) {
            throw new IllegalArgumentException("Private key must be accompanied by certificate chain");
        }
        this.keyStoreSpi.engineSetKeyEntry(string, key, cArray, certificateArray);
    }

    public final void setKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        this.keyStoreSpi.engineSetKeyEntry(string, byArray, certificateArray);
    }

    public final void setCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        this.keyStoreSpi.engineSetCertificateEntry(string, certificate);
    }

    public final void deleteEntry(String string) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        this.keyStoreSpi.engineDeleteEntry(string);
    }

    public final Enumeration<String> aliases() throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineAliases();
    }

    public final boolean containsAlias(String string) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineContainsAlias(string);
    }

    public final int size() throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineSize();
    }

    public final boolean isKeyEntry(String string) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineIsKeyEntry(string);
    }

    public final boolean isCertificateEntry(String string) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineIsCertificateEntry(string);
    }

    public final String getCertificateAlias(Certificate certificate) throws KeyStoreException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineGetCertificateAlias(certificate);
    }

    public final void store(OutputStream outputStream, char[] cArray) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        this.keyStoreSpi.engineStore(outputStream, cArray);
    }

    public final void store(LoadStoreParameter loadStoreParameter) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        this.keyStoreSpi.engineStore(loadStoreParameter);
    }

    public final void load(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.keyStoreSpi.engineLoad(inputStream, cArray);
        this.initialized = true;
    }

    public final void load(LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.keyStoreSpi.engineLoad(loadStoreParameter);
        this.initialized = true;
    }

    public final Entry getEntry(String string, ProtectionParameter protectionParameter) throws NoSuchAlgorithmException, UnrecoverableEntryException, KeyStoreException {
        if (string == null) {
            throw new NullPointerException("invalid null input");
        }
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineGetEntry(string, protectionParameter);
    }

    public final void setEntry(String string, Entry entry, ProtectionParameter protectionParameter) throws KeyStoreException {
        if (string == null || entry == null) {
            throw new NullPointerException("invalid null input");
        }
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        this.keyStoreSpi.engineSetEntry(string, entry, protectionParameter);
    }

    public final boolean entryInstanceOf(String string, Class<? extends Entry> clazz) throws KeyStoreException {
        if (string == null || clazz == null) {
            throw new NullPointerException("invalid null input");
        }
        if (!this.initialized) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineEntryInstanceOf(string, clazz);
    }

    static class SimpleLoadStoreParameter
    implements LoadStoreParameter {
        private final ProtectionParameter protection;

        SimpleLoadStoreParameter(ProtectionParameter protectionParameter) {
            this.protection = protectionParameter;
        }

        @Override
        public ProtectionParameter getProtectionParameter() {
            return this.protection;
        }
    }

    public static abstract class Builder {
        static final int MAX_CALLBACK_TRIES = 3;

        protected Builder() {
        }

        public abstract KeyStore getKeyStore() throws KeyStoreException;

        public abstract ProtectionParameter getProtectionParameter(String var1) throws KeyStoreException;

        public static Builder newInstance(final KeyStore keyStore, final ProtectionParameter protectionParameter) {
            if (keyStore == null || protectionParameter == null) {
                throw new NullPointerException();
            }
            if (!keyStore.initialized) {
                throw new IllegalArgumentException("KeyStore not initialized");
            }
            return new Builder(){
                private volatile boolean getCalled;

                @Override
                public KeyStore getKeyStore() {
                    this.getCalled = true;
                    return keyStore;
                }

                @Override
                public ProtectionParameter getProtectionParameter(String string) {
                    if (string == null) {
                        throw new NullPointerException();
                    }
                    if (!this.getCalled) {
                        throw new IllegalStateException("getKeyStore() must be called first");
                    }
                    return protectionParameter;
                }
            };
        }

        public static Builder newInstance(String string, Provider provider, File file, ProtectionParameter protectionParameter) {
            if (string == null || file == null || protectionParameter == null) {
                throw new NullPointerException();
            }
            if (!(protectionParameter instanceof PasswordProtection) && !(protectionParameter instanceof CallbackHandlerProtection)) {
                throw new IllegalArgumentException("Protection must be PasswordProtection or CallbackHandlerProtection");
            }
            if (!file.isFile()) {
                throw new IllegalArgumentException("File does not exist or it does not refer to a normal file: " + file);
            }
            return new FileBuilder(string, provider, file, protectionParameter, AccessController.getContext());
        }

        public static Builder newInstance(final String string, final Provider provider, final ProtectionParameter protectionParameter) {
            if (string == null || protectionParameter == null) {
                throw new NullPointerException();
            }
            final AccessControlContext accessControlContext = AccessController.getContext();
            return new Builder(){
                private volatile boolean getCalled;
                private IOException oldException;
                private final PrivilegedExceptionAction<KeyStore> action = new PrivilegedExceptionAction<KeyStore>(){

                    @Override
                    public KeyStore run() throws Exception {
                        KeyStore keyStore = provider == null ? KeyStore.getInstance(string) : KeyStore.getInstance(string, provider);
                        SimpleLoadStoreParameter simpleLoadStoreParameter = new SimpleLoadStoreParameter(protectionParameter);
                        if (!(protectionParameter instanceof CallbackHandlerProtection)) {
                            keyStore.load(simpleLoadStoreParameter);
                        } else {
                            int n = 0;
                            while (true) {
                                ++n;
                                try {
                                    keyStore.load(simpleLoadStoreParameter);
                                }
                                catch (IOException iOException) {
                                    if (iOException.getCause() instanceof UnrecoverableKeyException) {
                                        if (n < 3) continue;
                                        oldException = iOException;
                                    }
                                    throw iOException;
                                }
                                break;
                            }
                        }
                        getCalled = true;
                        return keyStore;
                    }
                };

                @Override
                public synchronized KeyStore getKeyStore() throws KeyStoreException {
                    if (this.oldException != null) {
                        throw new KeyStoreException("Previous KeyStore instantiation failed", this.oldException);
                    }
                    try {
                        return AccessController.doPrivileged(this.action, accessControlContext);
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Throwable throwable = privilegedActionException.getCause();
                        throw new KeyStoreException("KeyStore instantiation failed", throwable);
                    }
                }

                @Override
                public ProtectionParameter getProtectionParameter(String string2) {
                    if (string2 == null) {
                        throw new NullPointerException();
                    }
                    if (!this.getCalled) {
                        throw new IllegalStateException("getKeyStore() must be called first");
                    }
                    return protectionParameter;
                }
            };
        }

        private static final class FileBuilder
        extends Builder {
            private final String type;
            private final Provider provider;
            private final File file;
            private ProtectionParameter protection;
            private ProtectionParameter keyProtection;
            private final AccessControlContext context;
            private KeyStore keyStore;
            private Throwable oldException;

            FileBuilder(String string, Provider provider, File file, ProtectionParameter protectionParameter, AccessControlContext accessControlContext) {
                this.type = string;
                this.provider = provider;
                this.file = file;
                this.protection = protectionParameter;
                this.context = accessControlContext;
            }

            @Override
            public synchronized KeyStore getKeyStore() throws KeyStoreException {
                if (this.keyStore != null) {
                    return this.keyStore;
                }
                if (this.oldException != null) {
                    throw new KeyStoreException("Previous KeyStore instantiation failed", this.oldException);
                }
                PrivilegedExceptionAction<KeyStore> privilegedExceptionAction = new PrivilegedExceptionAction<KeyStore>(){

                    @Override
                    public KeyStore run() throws Exception {
                        if (!(protection instanceof CallbackHandlerProtection)) {
                            return this.run0();
                        }
                        int n = 0;
                        while (true) {
                            ++n;
                            try {
                                return this.run0();
                            }
                            catch (IOException iOException) {
                                if (n < 3 && iOException.getCause() instanceof UnrecoverableKeyException) continue;
                                throw iOException;
                            }
                            break;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public KeyStore run0() throws Exception {
                        KeyStore keyStore = provider == null ? KeyStore.getInstance(type) : KeyStore.getInstance(type, provider);
                        char[] cArray = null;
                        try (InputStream inputStream = null;){
                            Object object;
                            inputStream = new FileInputStream(file);
                            if (protection instanceof PasswordProtection) {
                                cArray = ((PasswordProtection)protection).getPassword();
                                keyProtection = protection;
                            } else {
                                object = ((CallbackHandlerProtection)protection).getCallbackHandler();
                                PasswordCallback passwordCallback = new PasswordCallback("Password for keystore " + file.getName(), false);
                                object.handle(new Callback[]{passwordCallback});
                                cArray = passwordCallback.getPassword();
                                if (cArray == null) {
                                    throw new KeyStoreException("No password provided");
                                }
                                passwordCallback.clearPassword();
                                keyProtection = new PasswordProtection(cArray);
                            }
                            keyStore.load(inputStream, cArray);
                            object = keyStore;
                            return object;
                        }
                    }
                };
                try {
                    this.keyStore = AccessController.doPrivileged(privilegedExceptionAction, this.context);
                    return this.keyStore;
                }
                catch (PrivilegedActionException privilegedActionException) {
                    this.oldException = privilegedActionException.getCause();
                    throw new KeyStoreException("KeyStore instantiation failed", this.oldException);
                }
            }

            @Override
            public synchronized ProtectionParameter getProtectionParameter(String string) {
                if (string == null) {
                    throw new NullPointerException();
                }
                if (this.keyStore == null) {
                    throw new IllegalStateException("getKeyStore() must be called first");
                }
                return this.keyProtection;
            }
        }
    }

    public static final class TrustedCertificateEntry
    implements Entry {
        private final Certificate cert;
        private final Set<Entry.Attribute> attributes;

        public TrustedCertificateEntry(Certificate certificate) {
            if (certificate == null) {
                throw new NullPointerException("invalid null input");
            }
            this.cert = certificate;
            this.attributes = Collections.emptySet();
        }

        public TrustedCertificateEntry(Certificate certificate, Set<Entry.Attribute> set) {
            if (certificate == null || set == null) {
                throw new NullPointerException("invalid null input");
            }
            this.cert = certificate;
            this.attributes = Collections.unmodifiableSet(new HashSet<Entry.Attribute>(set));
        }

        public Certificate getTrustedCertificate() {
            return this.cert;
        }

        @Override
        public Set<Entry.Attribute> getAttributes() {
            return this.attributes;
        }

        public String toString() {
            return "Trusted certificate entry:\r\n" + this.cert.toString();
        }
    }

    public static final class SecretKeyEntry
    implements Entry {
        private final SecretKey sKey;
        private final Set<Entry.Attribute> attributes;

        public SecretKeyEntry(SecretKey secretKey) {
            if (secretKey == null) {
                throw new NullPointerException("invalid null input");
            }
            this.sKey = secretKey;
            this.attributes = Collections.emptySet();
        }

        public SecretKeyEntry(SecretKey secretKey, Set<Entry.Attribute> set) {
            if (secretKey == null || set == null) {
                throw new NullPointerException("invalid null input");
            }
            this.sKey = secretKey;
            this.attributes = Collections.unmodifiableSet(new HashSet<Entry.Attribute>(set));
        }

        public SecretKey getSecretKey() {
            return this.sKey;
        }

        @Override
        public Set<Entry.Attribute> getAttributes() {
            return this.attributes;
        }

        public String toString() {
            return "Secret key entry with algorithm " + this.sKey.getAlgorithm();
        }
    }

    public static final class PrivateKeyEntry
    implements Entry {
        private final PrivateKey privKey;
        private final Certificate[] chain;
        private final Set<Entry.Attribute> attributes;

        public PrivateKeyEntry(PrivateKey privateKey, Certificate[] certificateArray) {
            this(privateKey, certificateArray, Collections.emptySet());
        }

        public PrivateKeyEntry(PrivateKey privateKey, Certificate[] certificateArray, Set<Entry.Attribute> set) {
            if (privateKey == null || certificateArray == null || set == null) {
                throw new NullPointerException("invalid null input");
            }
            if (certificateArray.length == 0) {
                throw new IllegalArgumentException("invalid zero-length input chain");
            }
            Certificate[] certificateArray2 = (Certificate[])certificateArray.clone();
            String string = certificateArray2[0].getType();
            for (int i = 1; i < certificateArray2.length; ++i) {
                if (string.equals(certificateArray2[i].getType())) continue;
                throw new IllegalArgumentException("chain does not contain certificates of the same type");
            }
            if (!privateKey.getAlgorithm().equals(certificateArray2[0].getPublicKey().getAlgorithm())) {
                throw new IllegalArgumentException("private key algorithm does not match algorithm of public key in end entity certificate (at index 0)");
            }
            this.privKey = privateKey;
            if (certificateArray2[0] instanceof X509Certificate && !(certificateArray2 instanceof X509Certificate[])) {
                this.chain = new X509Certificate[certificateArray2.length];
                System.arraycopy(certificateArray2, 0, this.chain, 0, certificateArray2.length);
            } else {
                this.chain = certificateArray2;
            }
            this.attributes = Collections.unmodifiableSet(new HashSet<Entry.Attribute>(set));
        }

        public PrivateKey getPrivateKey() {
            return this.privKey;
        }

        public Certificate[] getCertificateChain() {
            return (Certificate[])this.chain.clone();
        }

        public Certificate getCertificate() {
            return this.chain[0];
        }

        @Override
        public Set<Entry.Attribute> getAttributes() {
            return this.attributes;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Private key entry and certificate chain with " + this.chain.length + " elements:\r\n");
            for (Certificate certificate : this.chain) {
                stringBuilder.append(certificate);
                stringBuilder.append("\r\n");
            }
            return stringBuilder.toString();
        }
    }

    public static interface Entry {
        default public Set<Attribute> getAttributes() {
            return Collections.emptySet();
        }

        public static interface Attribute {
            public String getName();

            public String getValue();
        }
    }

    public static class CallbackHandlerProtection
    implements ProtectionParameter {
        private final CallbackHandler handler;

        public CallbackHandlerProtection(CallbackHandler callbackHandler) {
            if (callbackHandler == null) {
                throw new NullPointerException("handler must not be null");
            }
            this.handler = callbackHandler;
        }

        public CallbackHandler getCallbackHandler() {
            return this.handler;
        }
    }

    public static class PasswordProtection
    implements ProtectionParameter,
    Destroyable {
        private final char[] password;
        private final String protectionAlgorithm;
        private final AlgorithmParameterSpec protectionParameters;
        private volatile boolean destroyed = false;

        public PasswordProtection(char[] cArray) {
            this.password = cArray == null ? null : (char[])cArray.clone();
            this.protectionAlgorithm = null;
            this.protectionParameters = null;
        }

        public PasswordProtection(char[] cArray, String string, AlgorithmParameterSpec algorithmParameterSpec) {
            if (string == null) {
                throw new NullPointerException("invalid null input");
            }
            this.password = cArray == null ? null : (char[])cArray.clone();
            this.protectionAlgorithm = string;
            this.protectionParameters = algorithmParameterSpec;
        }

        public String getProtectionAlgorithm() {
            return this.protectionAlgorithm;
        }

        public AlgorithmParameterSpec getProtectionParameters() {
            return this.protectionParameters;
        }

        public synchronized char[] getPassword() {
            if (this.destroyed) {
                throw new IllegalStateException("password has been cleared");
            }
            return this.password;
        }

        @Override
        public synchronized void destroy() throws DestroyFailedException {
            this.destroyed = true;
            if (this.password != null) {
                Arrays.fill(this.password, ' ');
            }
        }

        @Override
        public synchronized boolean isDestroyed() {
            return this.destroyed;
        }
    }

    public static interface ProtectionParameter {
    }

    public static interface LoadStoreParameter {
        public ProtectionParameter getProtectionParameter();
    }
}

