/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.signature;

import com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithm;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.KeyInfo;
import com.sun.org.apache.xml.internal.security.keys.content.X509Data;
import com.sun.org.apache.xml.internal.security.signature.Manifest;
import com.sun.org.apache.xml.internal.security.signature.ObjectContainer;
import com.sun.org.apache.xml.internal.security.signature.SignatureProperties;
import com.sun.org.apache.xml.internal.security.signature.SignedInfo;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import com.sun.org.apache.xml.internal.security.transforms.Transforms;
import com.sun.org.apache.xml.internal.security.utils.I18n;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import com.sun.org.apache.xml.internal.security.utils.SignerOutputStream;
import com.sun.org.apache.xml.internal.security.utils.UnsyncBufferedOutputStream;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverSpi;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.io.IOException;
import java.security.Key;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public final class XMLSignature
extends SignatureElementProxy {
    public static final String ALGO_ID_MAC_HMAC_SHA1 = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    public static final String ALGO_ID_SIGNATURE_DSA = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    public static final String ALGO_ID_SIGNATURE_DSA_SHA256 = "http://www.w3.org/2009/xmldsig11#dsa-sha256";
    public static final String ALGO_ID_SIGNATURE_RSA = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA1 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    public static final String ALGO_ID_SIGNATURE_NOT_RECOMMENDED_RSA_MD5 = "http://www.w3.org/2001/04/xmldsig-more#rsa-md5";
    public static final String ALGO_ID_SIGNATURE_RSA_RIPEMD160 = "http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA224 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha224";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA256 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA384 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA512 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA1_MGF1 = "http://www.w3.org/2007/05/xmldsig-more#sha1-rsa-MGF1";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA224_MGF1 = "http://www.w3.org/2007/05/xmldsig-more#sha224-rsa-MGF1";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA256_MGF1 = "http://www.w3.org/2007/05/xmldsig-more#sha256-rsa-MGF1";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA384_MGF1 = "http://www.w3.org/2007/05/xmldsig-more#sha384-rsa-MGF1";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA512_MGF1 = "http://www.w3.org/2007/05/xmldsig-more#sha512-rsa-MGF1";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA3_224_MGF1 = "http://www.w3.org/2007/05/xmldsig-more#sha3-224-rsa-MGF1";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA3_256_MGF1 = "http://www.w3.org/2007/05/xmldsig-more#sha3-256-rsa-MGF1";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA3_384_MGF1 = "http://www.w3.org/2007/05/xmldsig-more#sha3-384-rsa-MGF1";
    public static final String ALGO_ID_SIGNATURE_RSA_SHA3_512_MGF1 = "http://www.w3.org/2007/05/xmldsig-more#sha3-512-rsa-MGF1";
    public static final String ALGO_ID_MAC_HMAC_NOT_RECOMMENDED_MD5 = "http://www.w3.org/2001/04/xmldsig-more#hmac-md5";
    public static final String ALGO_ID_MAC_HMAC_RIPEMD160 = "http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160";
    public static final String ALGO_ID_MAC_HMAC_SHA224 = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha224";
    public static final String ALGO_ID_MAC_HMAC_SHA256 = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256";
    public static final String ALGO_ID_MAC_HMAC_SHA384 = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha384";
    public static final String ALGO_ID_MAC_HMAC_SHA512 = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha512";
    public static final String ALGO_ID_SIGNATURE_ECDSA_SHA1 = "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1";
    public static final String ALGO_ID_SIGNATURE_ECDSA_SHA224 = "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224";
    public static final String ALGO_ID_SIGNATURE_ECDSA_SHA256 = "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256";
    public static final String ALGO_ID_SIGNATURE_ECDSA_SHA384 = "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384";
    public static final String ALGO_ID_SIGNATURE_ECDSA_SHA512 = "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512";
    public static final String ALGO_ID_SIGNATURE_ECDSA_RIPEMD160 = "http://www.w3.org/2007/05/xmldsig-more#ecdsa-ripemd160";
    public static final String ALGO_ID_SIGNATURE_EDDSA_ED25519 = "http://www.w3.org/2021/04/xmldsig-more#eddsa-ed25519";
    public static final String ALGO_ID_SIGNATURE_EDDSA_ED448 = "http://www.w3.org/2021/04/xmldsig-more#eddsa-ed448";
    public static final String ALGO_ID_SIGNATURE_RSA_PSS = "http://www.w3.org/2007/05/xmldsig-more#rsa-pss";
    private static final Logger LOG = LoggerFactory.getLogger(XMLSignature.class);
    private final SignedInfo signedInfo;
    private KeyInfo keyInfo;
    private boolean followManifestsDuringValidation = false;
    private Element signatureValueElement;
    private static final int MODE_SIGN = 0;
    private static final int MODE_VERIFY = 1;
    private int state = 0;

    public XMLSignature(Document document, String string, String string2) throws XMLSecurityException {
        this(document, string, string2, 0, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315", null, null);
    }

    public XMLSignature(Document document, String string, String string2, Provider provider) throws XMLSecurityException {
        this(document, string, string2, 0, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315", provider, null);
    }

    public XMLSignature(Document document, String string, String string2, int n) throws XMLSecurityException {
        this(document, string, string2, n, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315", null, null);
    }

    public XMLSignature(Document document, String string, String string2, int n, Provider provider) throws XMLSecurityException {
        this(document, string, string2, n, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315", provider, null);
    }

    public XMLSignature(Document document, String string, String string2, String string3) throws XMLSecurityException {
        this(document, string, string2, 0, string3, null, null);
    }

    public XMLSignature(Document document, String string, String string2, String string3, Provider provider) throws XMLSecurityException {
        this(document, string, string2, 0, string3, provider, null);
    }

    public XMLSignature(Document document, String string, String string2, int n, String string3) throws XMLSecurityException {
        this(document, string, string2, n, string3, null, null);
    }

    public XMLSignature(Document document, String string, String string2, int n, String string3, Provider provider, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSecurityException {
        super(document);
        String string4 = XMLSignature.getDefaultPrefix("http://www.w3.org/2000/09/xmldsig#");
        if (string4 == null || string4.length() == 0) {
            this.getElement().setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
        } else {
            this.getElement().setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string4, "http://www.w3.org/2000/09/xmldsig#");
        }
        this.addReturnToSelf();
        this.baseURI = string;
        this.signedInfo = new SignedInfo(this.getDocument(), string2, n, string3, provider, algorithmParameterSpec);
        this.appendSelf(this.signedInfo);
        this.addReturnToSelf();
        this.signatureValueElement = XMLUtils.createElementInSignatureSpace(this.getDocument(), "SignatureValue");
        this.appendSelf(this.signatureValueElement);
        this.addReturnToSelf();
    }

    public XMLSignature(Document document, String string, Element element, Element element2) throws XMLSecurityException {
        this(document, string, element, element2, null);
    }

    public XMLSignature(Document document, String string, Element element, Element element2, Provider provider) throws XMLSecurityException {
        super(document);
        String string2 = XMLSignature.getDefaultPrefix("http://www.w3.org/2000/09/xmldsig#");
        if (string2 == null || string2.length() == 0) {
            this.getElement().setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
        } else {
            this.getElement().setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string2, "http://www.w3.org/2000/09/xmldsig#");
        }
        this.addReturnToSelf();
        this.baseURI = string;
        this.signedInfo = new SignedInfo(this.getDocument(), element, element2, provider);
        this.appendSelf(this.signedInfo);
        this.addReturnToSelf();
        this.signatureValueElement = XMLUtils.createElementInSignatureSpace(this.getDocument(), "SignatureValue");
        this.appendSelf(this.signatureValueElement);
        this.addReturnToSelf();
    }

    public XMLSignature(Element element, String string) throws XMLSignatureException, XMLSecurityException {
        this(element, string, true, null);
    }

    public XMLSignature(Element element, String string, Provider provider) throws XMLSignatureException, XMLSecurityException {
        this(element, string, true, provider);
    }

    public XMLSignature(Element element, String string, boolean bl) throws XMLSignatureException, XMLSecurityException {
        this(element, string, bl, null);
    }

    public XMLSignature(Element element, String string, boolean bl, Provider provider) throws XMLSignatureException, XMLSecurityException {
        super(element, string);
        if (!"http://www.w3.org/2000/09/xmldsig#".equals(element.getNamespaceURI()) || !"Signature".equals(element.getLocalName())) {
            Object[] objectArray = new Object[]{element.getLocalName()};
            throw new XMLSignatureException("signature.Verification.InvalidElement", objectArray);
        }
        Element element2 = XMLUtils.getNextElement(element.getFirstChild());
        if (element2 == null || !"http://www.w3.org/2000/09/xmldsig#".equals(element2.getNamespaceURI()) || !"SignedInfo".equals(element2.getLocalName())) {
            Object[] objectArray = new Object[]{"SignedInfo", "Signature"};
            throw new XMLSignatureException("xml.WrongContent", objectArray);
        }
        this.signedInfo = new SignedInfo(element2, string, bl, provider);
        element2 = XMLUtils.getNextElement(element.getFirstChild());
        this.signatureValueElement = XMLUtils.getNextElement(element2.getNextSibling());
        if (this.signatureValueElement == null || !"http://www.w3.org/2000/09/xmldsig#".equals(this.signatureValueElement.getNamespaceURI()) || !"SignatureValue".equals(this.signatureValueElement.getLocalName())) {
            Object[] objectArray = new Object[]{"SignatureValue", "Signature"};
            throw new XMLSignatureException("xml.WrongContent", objectArray);
        }
        Attr attr = this.signatureValueElement.getAttributeNodeNS(null, "Id");
        if (attr != null) {
            this.signatureValueElement.setIdAttributeNode(attr, true);
        }
        Element element3 = XMLUtils.getNextElement(this.signatureValueElement.getNextSibling());
        Element element4 = null;
        if (element3 != null && "http://www.w3.org/2000/09/xmldsig#".equals(element3.getNamespaceURI()) && "KeyInfo".equals(element3.getLocalName())) {
            this.keyInfo = new KeyInfo(element3, string);
            this.keyInfo.setSecureValidation(bl);
            element4 = XMLUtils.getNextElement(element3.getNextSibling());
        } else {
            element4 = element3;
        }
        while (element4 != null) {
            Object object;
            if (!"http://www.w3.org/2000/09/xmldsig#".equals(element4.getNamespaceURI()) || !"Object".equals(element4.getLocalName())) {
                object = new Object[]{element4.getLocalName()};
                throw new XMLSignatureException("signature.Verification.InvalidElement", (Object[])object);
            }
            object = element4.getAttributeNodeNS(null, "Id");
            if (object != null) {
                element4.setIdAttributeNode((Attr)object, true);
            }
            for (Node node = element4.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                Element element5 = (Element)node;
                String string2 = element5.getLocalName();
                if ("Manifest".equals(string2)) {
                    new Manifest(element5, string);
                    continue;
                }
                if (!"SignatureProperties".equals(string2)) continue;
                new SignatureProperties(element5, string);
            }
            element4 = XMLUtils.getNextElement(element4.getNextSibling());
        }
        this.state = 1;
    }

    public void setId(String string) {
        if (string != null) {
            this.setLocalIdAttribute("Id", string);
        }
    }

    public String getId() {
        return this.getLocalAttribute("Id");
    }

    public SignedInfo getSignedInfo() {
        return this.signedInfo;
    }

    public byte[] getSignatureValue() throws XMLSignatureException {
        String string = XMLUtils.getFullTextChildrenFromNode(this.signatureValueElement);
        return XMLUtils.decode(string);
    }

    private void setSignatureValueElement(byte[] byArray) {
        while (this.signatureValueElement.hasChildNodes()) {
            this.signatureValueElement.removeChild(this.signatureValueElement.getFirstChild());
        }
        String string = XMLUtils.encodeToString(byArray);
        if (string.length() > 76 && !XMLUtils.ignoreLineBreaks()) {
            string = "\n" + string + "\n";
        }
        Text text = this.createText(string);
        this.signatureValueElement.appendChild(text);
    }

    public KeyInfo getKeyInfo() {
        if (this.state == 0 && this.keyInfo == null) {
            this.keyInfo = new KeyInfo(this.getDocument());
            Element element = this.keyInfo.getElement();
            Element element2 = XMLUtils.selectDsNode(this.getElement().getFirstChild(), "Object", 0);
            if (element2 != null) {
                this.getElement().insertBefore(element, element2);
                XMLUtils.addReturnBeforeChild(this.getElement(), element2);
            } else {
                this.appendSelf(element);
                this.addReturnToSelf();
            }
        }
        return this.keyInfo;
    }

    public void appendObject(ObjectContainer objectContainer) throws XMLSignatureException {
        this.appendSelf(objectContainer);
        this.addReturnToSelf();
    }

    public ObjectContainer getObjectItem(int n) {
        Element element = XMLUtils.selectDsNode(this.getFirstChild(), "Object", n);
        try {
            return new ObjectContainer(element, this.baseURI);
        }
        catch (XMLSecurityException xMLSecurityException) {
            return null;
        }
    }

    public int getObjectLength() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "Object");
    }

    public void sign(Key key) throws XMLSignatureException {
        if (key instanceof PublicKey) {
            throw new IllegalArgumentException(I18n.translate("algorithms.operationOnlyVerification"));
        }
        SignedInfo signedInfo = this.getSignedInfo();
        SignatureAlgorithm signatureAlgorithm = signedInfo.getSignatureAlgorithm();
        try (SignerOutputStream signerOutputStream = new SignerOutputStream(signatureAlgorithm);
             UnsyncBufferedOutputStream unsyncBufferedOutputStream = new UnsyncBufferedOutputStream(signerOutputStream);){
            signedInfo.generateDigestValues();
            signatureAlgorithm.initSign(key);
            signedInfo.signInOctetStream(unsyncBufferedOutputStream);
            this.setSignatureValueElement(signatureAlgorithm.sign());
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw xMLSignatureException;
        }
        catch (XMLSecurityException | IOException exception) {
            throw new XMLSignatureException(exception);
        }
    }

    public void addResourceResolver(ResourceResolverSpi resourceResolverSpi) {
        this.getSignedInfo().addResourceResolver(resourceResolverSpi);
    }

    public boolean checkSignatureValue(X509Certificate x509Certificate) throws XMLSignatureException {
        if (x509Certificate != null) {
            return this.checkSignatureValue(x509Certificate.getPublicKey());
        }
        Object[] objectArray = new Object[]{"Didn't get a certificate"};
        throw new XMLSignatureException("empty", objectArray);
    }

    public boolean checkSignatureValue(Key key) throws XMLSignatureException {
        if (key == null) {
            Object[] objectArray = new Object[]{"Didn't get a key"};
            throw new XMLSignatureException("empty", objectArray);
        }
        try {
            SignedInfo signedInfo = this.getSignedInfo();
            SignatureAlgorithm signatureAlgorithm = signedInfo.getSignatureAlgorithm();
            LOG.debug("signatureMethodURI = {}", signatureAlgorithm.getAlgorithmURI());
            LOG.debug("jceSigAlgorithm = {}", signatureAlgorithm.getJCEAlgorithmString());
            LOG.debug("PublicKey = {}", key);
            byte[] byArray = null;
            try (SignerOutputStream signerOutputStream = new SignerOutputStream(signatureAlgorithm);
                 UnsyncBufferedOutputStream unsyncBufferedOutputStream = new UnsyncBufferedOutputStream(signerOutputStream);){
                signatureAlgorithm.initVerify(key);
                LOG.debug("jceSigProvider = {}", signatureAlgorithm.getJCEProviderName());
                signedInfo.signInOctetStream(unsyncBufferedOutputStream);
                byArray = this.getSignatureValue();
            }
            catch (IOException iOException) {
                LOG.debug(iOException.getMessage(), iOException);
            }
            catch (XMLSecurityException xMLSecurityException) {
                throw xMLSecurityException;
            }
            if (!signatureAlgorithm.verify(byArray)) {
                LOG.warn("Signature verification failed.");
                return false;
            }
            return signedInfo.verify(this.followManifestsDuringValidation);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw xMLSignatureException;
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLSignatureException(xMLSecurityException);
        }
    }

    public void addDocument(String string, Transforms transforms, String string2, String string3, String string4) throws XMLSignatureException {
        this.signedInfo.addDocument(this.baseURI, string, transforms, string2, string3, string4);
    }

    public void addDocument(String string, Transforms transforms, String string2) throws XMLSignatureException {
        this.signedInfo.addDocument(this.baseURI, string, transforms, string2, null, null);
    }

    public void addDocument(String string, Transforms transforms) throws XMLSignatureException {
        this.signedInfo.addDocument(this.baseURI, string, transforms, "http://www.w3.org/2000/09/xmldsig#sha1", null, null);
    }

    public void addDocument(String string) throws XMLSignatureException {
        this.signedInfo.addDocument(this.baseURI, string, null, "http://www.w3.org/2000/09/xmldsig#sha1", null, null);
    }

    public void addKeyInfo(X509Certificate x509Certificate) throws XMLSecurityException {
        X509Data x509Data = new X509Data(this.getDocument());
        x509Data.addCertificate(x509Certificate);
        this.getKeyInfo().add(x509Data);
    }

    public void addKeyInfo(PublicKey publicKey) {
        this.getKeyInfo().add(publicKey);
    }

    public SecretKey createSecretKey(byte[] byArray) {
        return this.getSignedInfo().createSecretKey(byArray);
    }

    public void setFollowNestedManifests(boolean bl) {
        this.followManifestsDuringValidation = bl;
    }

    @Override
    public String getBaseLocalName() {
        return "Signature";
    }
}

