/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.netpreserve.jwarc.BrotliUtils;
import org.netpreserve.jwarc.IOUtils;
import org.netpreserve.jwarc.MessageBody;

public class DecodedBody
extends MessageBody {
    private final ReadableByteChannel channel;
    private final Encoding encoding;
    long position = 0L;

    private DecodedBody(ReadableByteChannel channel, Encoding encoding) throws IOException {
        this.encoding = encoding;
        switch (this.encoding) {
            case DEFLATE: {
                this.channel = IOUtils.inflateChannel(channel);
                break;
            }
            case GZIP: {
                this.channel = IOUtils.gunzipChannel(channel);
                break;
            }
            case BROTLI: {
                try {
                    this.channel = BrotliUtils.brotliChannel(channel);
                    break;
                }
                catch (NoClassDefFoundError e) {
                    throw new IOException("Brotli decoder not found, please install org.brotli:dec", e);
                }
            }
            default: {
                throw new IOException("Unsupported encoding");
            }
        }
    }

    public static DecodedBody create(ReadableByteChannel channel, Encoding encoding) throws IOException {
        return new DecodedBody(channel, encoding);
    }

    @Override
    public long position() throws IOException {
        return this.position;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int n = this.channel.read(dst);
        if (n > 0) {
            this.position += (long)n;
        }
        return n;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    public static enum Encoding {
        DEFLATE,
        GZIP,
        BROTLI;

    }
}

