/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.iwork.iwana;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class IWork18PackageParser
extends AbstractParser {
    private static final Set<MediaType> supportedTypes = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(IWork18DocumentType.KEYNOTE18.getType(), IWork18DocumentType.NUMBERS18.getType(), IWork18DocumentType.PAGES18.getType())));

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return supportedTypes;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        ZipFile zipFile = null;
        ZipInputStream zipStream = null;
        if (stream instanceof TikaInputStream) {
            TikaInputStream tis = (TikaInputStream)stream;
            Object container = ((TikaInputStream)stream).getOpenContainer();
            if (container instanceof ZipFile) {
                zipFile = (ZipFile)container;
            } else if (tis.hasFile()) {
                zipFile = ((ZipFile.Builder)ZipFile.builder().setFile(tis.getFile())).get();
            } else {
                zipStream = new ZipInputStream(stream);
            }
        } else {
            zipStream = new ZipInputStream(stream);
        }
        MediaType type = null;
        if (zipFile != null) {
            Enumeration<ZipArchiveEntry> entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (type != null) continue;
                type = IWork18DocumentType.detectIfPossible(entry);
            }
        } else {
            ZipEntry entry = zipStream.getNextEntry();
            while (entry != null) {
                if (type == null) {
                    type = IWork18DocumentType.detectIfPossible(entry);
                }
                entry = zipStream.getNextEntry();
            }
        }
        if (type != null) {
            metadata.add("Content-Type", type.toString());
        }
    }

    public static enum IWork18DocumentType {
        KEYNOTE18(MediaType.application("vnd.apple.keynote.18")),
        NUMBERS18(MediaType.application("vnd.apple.numbers.18")),
        PAGES18(MediaType.application("vnd.apple.pages.18"));

        private final MediaType mediaType;

        private IWork18DocumentType(MediaType mediaType) {
            this.mediaType = mediaType;
        }

        public static MediaType detect(ZipFile zipFile) {
            MediaType type = null;
            Enumeration<ZipArchiveEntry> entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                type = IWork18DocumentType.detectIfPossible(entry);
                if (type == null) continue;
                return type;
            }
            return null;
        }

        public static MediaType detectIfPossible(ZipEntry entry) {
            String name = entry.getName();
            if (name.endsWith(".numbers/Metadata/BuildVersionHistory.plist")) {
                return NUMBERS18.getType();
            }
            if (name.endsWith(".pages/Metadata/BuildVersionHistory.plist")) {
                return PAGES18.getType();
            }
            if (name.endsWith(".key/Metadata/BuildVersionHistory.plist")) {
                return KEYNOTE18.getType();
            }
            return null;
        }

        public MediaType getType() {
            return this.mediaType;
        }
    }
}

