/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.util.event.generator;

import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.bsf.util.event.generator.AdapterClassLoader;
import org.apache.bsf.util.event.generator.ByteUtility;
import org.apache.bsf.util.event.generator.Bytecode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventAdapterGenerator {
    public static AdapterClassLoader ldr = new AdapterClassLoader();
    static Class EVENTLISTENER = null;
    static String CLASSPACKAGE = "org/apache/bsf/util/event/adapters/";
    static String WRITEDIRECTORY = null;
    static byte[] CLASSHEADER;
    static short BASECPCOUNT;
    static byte[] BASECP;
    static byte[] FIXEDCLASSBYTES;
    static byte[] INITMETHOD;
    private static Log logger;

    static {
        logger = LogFactory.getLog(EventAdapterGenerator.class.getName());
        String USERCLASSPACKAGE = System.getProperty("DynamicEventClassPackage", "");
        if (!USERCLASSPACKAGE.equals("")) {
            CLASSPACKAGE = USERCLASSPACKAGE;
        }
        if (CLASSPACKAGE.length() > 0 && !(CLASSPACKAGE = CLASSPACKAGE.replace('\\', '/')).endsWith("/")) {
            CLASSPACKAGE = String.valueOf(CLASSPACKAGE) + "/";
        }
        if ((WRITEDIRECTORY = System.getProperty("DynamicEventClassWriteDirectory", CLASSPACKAGE)).length() > 0 && !(WRITEDIRECTORY = WRITEDIRECTORY.replace('\\', '/')).endsWith("/")) {
            WRITEDIRECTORY = String.valueOf(WRITEDIRECTORY) + "/";
        }
        try {
            EVENTLISTENER = Thread.currentThread().getContextClassLoader().loadClass("java.util.EventListener");
        }
        catch (ClassNotFoundException ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
        }
        CLASSHEADER = ByteUtility.addBytes(CLASSHEADER, (byte)-54);
        CLASSHEADER = ByteUtility.addBytes(CLASSHEADER, (byte)-2);
        CLASSHEADER = ByteUtility.addBytes(CLASSHEADER, (byte)-70);
        CLASSHEADER = ByteUtility.addBytes(CLASSHEADER, (byte)-66);
        CLASSHEADER = ByteUtility.addBytes(CLASSHEADER, (short)3);
        CLASSHEADER = ByteUtility.addBytes(CLASSHEADER, (short)45);
        BASECPCOUNT = (short)17;
        BASECP = Bytecode.addUtf8(BASECP, "()V");
        BASECP = Bytecode.addUtf8(BASECP, "<init>");
        BASECP = Bytecode.addUtf8(BASECP, "Code");
        BASECP = Bytecode.addUtf8(BASECP, "eventProcessor");
        BASECP = Bytecode.addUtf8(BASECP, "java/lang/Object");
        BASECP = Bytecode.addUtf8(BASECP, "org/apache/bsf/util/event/EventAdapterImpl");
        BASECP = Bytecode.addUtf8(BASECP, "org/apache/bsf/util/event/EventProcessor");
        BASECP = Bytecode.addUtf8(BASECP, "(Ljava/lang/String;[Ljava/lang/Object;)V");
        BASECP = Bytecode.addUtf8(BASECP, "Lorg/apache/bsf/util/event/EventProcessor;");
        BASECP = Bytecode.addClass(BASECP, (short)5);
        BASECP = Bytecode.addClass(BASECP, (short)6);
        BASECP = Bytecode.addClass(BASECP, (short)7);
        BASECP = Bytecode.addNameAndType(BASECP, (short)2, (short)1);
        BASECP = Bytecode.addNameAndType(BASECP, (short)4, (short)9);
        BASECP = Bytecode.addFieldRef(BASECP, (short)11, (short)14);
        BASECP = Bytecode.addMethodRef(BASECP, (short)11, (short)13);
        FIXEDCLASSBYTES = ByteUtility.addBytes(FIXEDCLASSBYTES, (short)33);
        FIXEDCLASSBYTES = ByteUtility.addBytes(FIXEDCLASSBYTES, (short)20);
        FIXEDCLASSBYTES = ByteUtility.addBytes(FIXEDCLASSBYTES, (short)11);
        FIXEDCLASSBYTES = ByteUtility.addBytes(FIXEDCLASSBYTES, (short)1);
        FIXEDCLASSBYTES = ByteUtility.addBytes(FIXEDCLASSBYTES, (short)19);
        FIXEDCLASSBYTES = ByteUtility.addBytes(FIXEDCLASSBYTES, (short)0);
        INITMETHOD = ByteUtility.addBytes(INITMETHOD, (short)1);
        INITMETHOD = ByteUtility.addBytes(INITMETHOD, (short)2);
        INITMETHOD = ByteUtility.addBytes(INITMETHOD, (short)1);
        INITMETHOD = ByteUtility.addBytes(INITMETHOD, (short)1);
        INITMETHOD = ByteUtility.addBytes(INITMETHOD, (short)3);
        INITMETHOD = ByteUtility.addBytes(INITMETHOD, 17L);
        INITMETHOD = ByteUtility.addBytes(INITMETHOD, (short)1);
        INITMETHOD = ByteUtility.addBytes(INITMETHOD, (short)1);
        INITMETHOD = ByteUtility.addBytes(INITMETHOD, 5L);
        INITMETHOD = ByteUtility.addBytes(INITMETHOD, (byte)42);
        INITMETHOD = ByteUtility.addBytes(INITMETHOD, (byte)-73);
        INITMETHOD = ByteUtility.addBytes(INITMETHOD, (short)16);
        INITMETHOD = ByteUtility.addBytes(INITMETHOD, (byte)-79);
        INITMETHOD = ByteUtility.addBytes(INITMETHOD, (short)0);
        INITMETHOD = ByteUtility.addBytes(INITMETHOD, (short)0);
    }

    public static Class makeEventAdapterClass(Class listenerType, boolean writeClassFile) {
        logger.info("EventAdapterGenerator");
        if (EVENTLISTENER.isAssignableFrom(listenerType)) {
            String adapterClassName;
            boolean exceptionable = false;
            boolean nonExceptionable = false;
            byte[] constantPool = null;
            int cpCount = 0;
            String listenerTypeName = listenerType.getName();
            logger.info("ListenerTypeName: " + listenerTypeName);
            String finalAdapterClassName = adapterClassName = String.valueOf(CLASSPACKAGE) + (listenerTypeName.endsWith("Listener") ? listenerTypeName.substring(0, listenerTypeName.length() - 8) : listenerTypeName).replace('.', '_') + "Adapter";
            Class cached = null;
            int suffixIndex = 0;
            do {
                if ((cached = ldr.getLoadedClass(finalAdapterClassName)) == null) continue;
                logger.info("cached:  " + cached);
                try {
                    if (!listenerType.isAssignableFrom(cached)) {
                        finalAdapterClassName = String.valueOf(adapterClassName) + "_" + suffixIndex++;
                        continue;
                    }
                    return cached;
                }
                catch (VerifyError ex) {
                    System.err.println(ex.getMessage());
                    ex.printStackTrace();
                    return cached;
                }
            } while (cached != null);
            String eventListenerName = listenerTypeName.replace('.', '/');
            Method[] lms = listenerType.getMethods();
            cpCount = (short)(cpCount + 4);
            constantPool = Bytecode.addUtf8(constantPool, eventListenerName);
            constantPool = Bytecode.addUtf8(constantPool, finalAdapterClassName);
            constantPool = Bytecode.addClass(constantPool, (short)17);
            constantPool = Bytecode.addClass(constantPool, (short)18);
            int i = 0;
            while (i < lms.length) {
                Class<?>[] exceptionTypes = lms[i].getExceptionTypes();
                if (exceptionTypes.length > 0) {
                    exceptionable = true;
                } else {
                    nonExceptionable = true;
                }
                ++i;
            }
            int nonExceptionableCount = 0;
            if (nonExceptionable) {
                nonExceptionableCount = 3;
                cpCount = (short)(cpCount + nonExceptionableCount);
                constantPool = Bytecode.addUtf8(constantPool, "processEvent");
                constantPool = Bytecode.addNameAndType(constantPool, (short)21, (short)8);
                constantPool = Bytecode.addInterfaceMethodRef(constantPool, (short)12, (short)22);
            }
            int exceptionableCount = 0;
            if (exceptionable) {
                int classIndex = BASECPCOUNT + cpCount + 1;
                int nameIndex = BASECPCOUNT + cpCount + 0;
                int natIndex = BASECPCOUNT + cpCount + 3;
                exceptionableCount = 5;
                cpCount = (short)(cpCount + exceptionableCount);
                constantPool = Bytecode.addUtf8(constantPool, "processExceptionableEvent");
                constantPool = Bytecode.addUtf8(constantPool, "java/lang/Exception");
                constantPool = Bytecode.addClass(constantPool, (short)classIndex);
                constantPool = Bytecode.addNameAndType(constantPool, (short)nameIndex, (short)8);
                constantPool = Bytecode.addInterfaceMethodRef(constantPool, (short)12, (short)natIndex);
            }
            short cpBaseIndex = (short)(BASECPCOUNT + cpCount);
            logger.debug("cpBaseIndex: " + cpBaseIndex);
            i = 0;
            while (i < lms.length) {
                String eventMethodName = lms[i].getName();
                String eventName = lms[i].getParameterTypes()[0].getName().replace('.', '/');
                cpCount = (short)(cpCount + 3);
                constantPool = Bytecode.addUtf8(constantPool, eventMethodName);
                constantPool = Bytecode.addUtf8(constantPool, "(L" + eventName + ";)V");
                constantPool = Bytecode.addString(constantPool, (short)(BASECPCOUNT + cpCount - 3));
                ++i;
            }
            boolean[] propertyChangeFlag = new boolean[lms.length];
            int cpIndexPCE = 0;
            int i2 = 0;
            while (i2 < lms.length) {
                String eventName = lms[i2].getParameterTypes()[0].getName().replace('.', '/');
                if (eventName.equalsIgnoreCase("java/beans/PropertyChangeEvent")) {
                    propertyChangeFlag[i2] = true;
                    if (cpIndexPCE == 0) {
                        constantPool = Bytecode.addUtf8(constantPool, eventName);
                        constantPool = Bytecode.addUtf8(constantPool, "getPropertyName");
                        constantPool = Bytecode.addUtf8(constantPool, "()Ljava/lang/String;");
                        constantPool = Bytecode.addClass(constantPool, (short)(BASECPCOUNT + cpCount));
                        constantPool = Bytecode.addNameAndType(constantPool, (short)(BASECPCOUNT + cpCount + 1), (short)(BASECPCOUNT + cpCount + 2));
                        constantPool = Bytecode.addMethodRef(constantPool, (short)(BASECPCOUNT + cpCount + 3), (short)(BASECPCOUNT + cpCount + 4));
                        cpCount = (short)(cpCount + 6);
                        cpIndexPCE = BASECPCOUNT + cpCount - 1;
                    }
                } else {
                    propertyChangeFlag[i2] = false;
                }
                ++i2;
            }
            short cpExceptionBaseIndex = (short)(BASECPCOUNT + cpCount);
            logger.debug("cpExceptionBaseIndex: " + cpExceptionBaseIndex);
            int[][] excpIndex = new int[lms.length][];
            int i3 = 0;
            while (i3 < lms.length) {
                Class<?>[] exceptionTypes = lms[i3].getExceptionTypes();
                excpIndex[i3] = new int[exceptionTypes.length];
                int j = 0;
                while (j < exceptionTypes.length) {
                    constantPool = Bytecode.addUtf8(constantPool, exceptionTypes[j].getName().replace('.', '/'));
                    constantPool = Bytecode.addClass(constantPool, (short)(BASECPCOUNT + cpCount));
                    excpIndex[i3][j] = BASECPCOUNT + cpCount + 1;
                    cpCount = (short)(cpCount + 2);
                    ++j;
                }
                ++i3;
            }
            byte[] newClass = CLASSHEADER;
            short count = (short)(BASECPCOUNT + cpCount);
            newClass = ByteUtility.addBytes(newClass, count);
            newClass = ByteUtility.addBytes(newClass, BASECP);
            newClass = ByteUtility.addBytes(newClass, constantPool);
            newClass = ByteUtility.addBytes(newClass, FIXEDCLASSBYTES);
            newClass = ByteUtility.addBytes(newClass, (short)(lms.length + 1));
            newClass = ByteUtility.addBytes(newClass, INITMETHOD);
            int i4 = 0;
            while (i4 < lms.length) {
                newClass = ByteUtility.addBytes(newClass, (short)1);
                newClass = ByteUtility.addBytes(newClass, (short)(cpBaseIndex + 3 * i4 + 0));
                newClass = ByteUtility.addBytes(newClass, (short)(cpBaseIndex + 3 * i4 + 1));
                newClass = ByteUtility.addBytes(newClass, (short)1);
                newClass = ByteUtility.addBytes(newClass, (short)3);
                int length = 32;
                if (excpIndex[i4].length > 0) {
                    length += 5 + 8 * (1 + excpIndex[i4].length);
                }
                if (propertyChangeFlag[i4]) {
                    length += 2;
                }
                newClass = ByteUtility.addBytes(newClass, (long)length);
                newClass = ByteUtility.addBytes(newClass, (short)6);
                newClass = ByteUtility.addBytes(newClass, (short)3);
                length = 20;
                if (exceptionable && excpIndex[i4].length > 0) {
                    length += 5;
                }
                if (propertyChangeFlag[i4]) {
                    length += 2;
                }
                newClass = ByteUtility.addBytes(newClass, (long)length);
                newClass = ByteUtility.addBytes(newClass, (byte)42);
                newClass = ByteUtility.addBytes(newClass, (byte)-76);
                newClass = ByteUtility.addBytes(newClass, (short)15);
                if (propertyChangeFlag[i4]) {
                    newClass = ByteUtility.addBytes(newClass, (byte)43);
                    newClass = ByteUtility.addBytes(newClass, (byte)-74);
                    newClass = ByteUtility.addBytes(newClass, (short)cpIndexPCE);
                } else {
                    newClass = ByteUtility.addBytes(newClass, (byte)18);
                    newClass = ByteUtility.addBytes(newClass, (byte)(cpBaseIndex + 3 * i4 + 2));
                }
                newClass = ByteUtility.addBytes(newClass, (byte)4);
                newClass = ByteUtility.addBytes(newClass, (byte)-67);
                newClass = ByteUtility.addBytes(newClass, (short)10);
                newClass = ByteUtility.addBytes(newClass, (byte)89);
                newClass = ByteUtility.addBytes(newClass, (byte)3);
                newClass = ByteUtility.addBytes(newClass, (byte)43);
                newClass = ByteUtility.addBytes(newClass, (byte)83);
                newClass = ByteUtility.addBytes(newClass, (byte)-71);
                length = 23;
                if (exceptionable && nonExceptionable) {
                    if (lms[i4].getExceptionTypes().length > 0) {
                        length += 5;
                    }
                } else if (exceptionable) {
                    length += 2;
                }
                newClass = ByteUtility.addBytes(newClass, (short)length);
                newClass = ByteUtility.addBytes(newClass, (byte)3);
                newClass = ByteUtility.addBytes(newClass, (byte)0);
                newClass = ByteUtility.addBytes(newClass, (byte)-79);
                if (exceptionable && excpIndex[i4].length > 0) {
                    newClass = ByteUtility.addBytes(newClass, (byte)77);
                    newClass = ByteUtility.addBytes(newClass, (byte)44);
                    newClass = ByteUtility.addBytes(newClass, (byte)-65);
                    newClass = ByteUtility.addBytes(newClass, (byte)87);
                    newClass = ByteUtility.addBytes(newClass, (byte)-79);
                    length = excpIndex[i4].length;
                    newClass = ByteUtility.addBytes(newClass, (short)(1 + length));
                    int j = 0;
                    while (j < length) {
                        newClass = ByteUtility.addBytes(newClass, (short)0);
                        if (propertyChangeFlag[i4]) {
                            newClass = ByteUtility.addBytes(newClass, (short)21);
                            newClass = ByteUtility.addBytes(newClass, (short)22);
                        } else {
                            newClass = ByteUtility.addBytes(newClass, (short)19);
                            newClass = ByteUtility.addBytes(newClass, (short)20);
                        }
                        newClass = ByteUtility.addBytes(newClass, (short)excpIndex[i4][j]);
                        ++j;
                    }
                    newClass = ByteUtility.addBytes(newClass, (short)0);
                    if (propertyChangeFlag[i4]) {
                        newClass = ByteUtility.addBytes(newClass, (short)21);
                        newClass = ByteUtility.addBytes(newClass, (short)25);
                    } else {
                        newClass = ByteUtility.addBytes(newClass, (short)19);
                        newClass = ByteUtility.addBytes(newClass, (short)23);
                    }
                    newClass = nonExceptionable ? ByteUtility.addBytes(newClass, (short)26) : ByteUtility.addBytes(newClass, (short)23);
                } else {
                    newClass = ByteUtility.addBytes(newClass, (short)0);
                }
                newClass = ByteUtility.addBytes(newClass, (short)0);
                ++i4;
            }
            newClass = ByteUtility.addBytes(newClass, (short)0);
            logger.debug("adapterName: " + finalAdapterClassName);
            logger.debug("cpCount: " + count + " = " + BASECPCOUNT + " + " + cpCount);
            logger.debug("methodCount: " + (lms.length + 1));
            if (writeClassFile) {
                try {
                    FileOutputStream fos = new FileOutputStream(String.valueOf(finalAdapterClassName) + ".class");
                    fos.write(newClass);
                    fos.close();
                }
                catch (IOException ex) {
                    System.err.println(ex.getMessage());
                    ex.printStackTrace();
                }
                try {
                    Class<?> ret = ldr.loadClass(finalAdapterClassName);
                    logger.debug("EventAdapterGenerator: " + ret.getName() + " dynamically generated");
                    return ret;
                }
                catch (ClassNotFoundException ex) {
                    System.err.println(ex.getMessage());
                    ex.printStackTrace();
                }
            }
            try {
                Class ret = ldr.defineClass(finalAdapterClassName, newClass);
                logger.debug("EventAdapterGenerator: " + ret.getName() + " dynamically generated");
                return ret;
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
                ex.printStackTrace();
            }
        }
        return null;
    }
}

