/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.swing;

import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.math.BcMath;
import jp.co.extreme.base.mmd.MmdCellAttribute;
import jp.co.extreme.base.mmd.MmdDefaultRenderingConverter;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.mmd.MmdRenderingConverter;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.swing.SwgCheckBox;
import jp.co.extreme.swing.SwgLabel;
import jp.co.extreme.swing.SwgTableViewUtil;
import jp.co.extreme.swing.SwgTextArea;
import jp.co.extreme.swing.SwgUtil;

public class SwgTableCellRenderer
implements TableCellRenderer,
Serializable {
    private static final long serialVersionUID = 3725527174648294999L;
    public SwgLabel label = new SwgLabel();
    public SwgTextArea textArea = new SwgTextArea();
    protected JComponent textComponent = this.label;
    protected SwgCheckBox checkBox = new SwgCheckBox();
    protected Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    public Color oddRowBg1;
    public Color oddRowBg2;
    public Color oddRowFg1;
    public Color oddRowFg2;
    public Color evenRowBg1;
    public Color evenRowBg2;
    public Color evenRowFg1;
    public Color evenRowFg2;
    public Color editableOddRowBg1;
    public Color editableOddRowFg1;
    public Color editableEvenRowBg1;
    public Color editableEvenRowFg1;
    boolean isFirst = true;

    public SwgTableCellRenderer() throws Exception {
        SwgUtil.setHtmlDisabled(this.label, true);
        this.checkBox.setHorizontalAlignment(0);
        this.textArea.setEnabled(false);
        this.textArea.forTable = true;
    }

    @Override
    public Component getTableCellRendererComponent(JTable tableView, Object value, boolean isSelected, boolean hasFocus, int rowrIndex, int columnIndex) {
        this.setColor(tableView.getBackground(), tableView.getForeground());
        Component component = null;
        if (value != null && JComponent.class.isAssignableFrom(value.getClass())) {
            return (JComponent)value;
        }
        this.oddRowBg2 = this.oddRowBg1;
        this.oddRowFg2 = this.oddRowFg1;
        this.evenRowBg2 = this.evenRowBg1;
        this.evenRowFg2 = this.evenRowFg1;
        TableColumn tableColumn = tableView.getColumnModel().getColumn(columnIndex);
        MmdField mmdField = null;
        if (BcTableColumn.class.isAssignableFrom(tableColumn.getClass())) {
            BcTableColumn bcTableColumn = (BcTableColumn)tableColumn;
            mmdField = bcTableColumn.getMmdField();
        }
        if (mmdField == null) {
            mmdField = new MmdField();
            BcLogUtil.debug("mmdField Is Null.");
        }
        try {
            boolean isEditable = tableView.isCellEditable(rowrIndex, columnIndex);
            component = this.getRendererComponent_L2(mmdField, value, isEditable);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
            this.label.setText("error");
            component = this.label;
        }
        this.setColor(tableView, isSelected, hasFocus, rowrIndex, columnIndex, component);
        return component;
    }

    protected void setColor(JTable tableView, boolean isSelected, boolean hasFocus, int rowrIndex, int columnIndex, Component component) {
        if (JComponent.class.isAssignableFrom(component.getClass())) {
            Color background;
            JComponent jComponent = (JComponent)component;
            if (isSelected) {
                if (BcMath.isEven(rowrIndex)) {
                    jComponent.setBackground(tableView.getSelectionBackground());
                    jComponent.setForeground(tableView.getSelectionForeground());
                } else {
                    jComponent.setBackground(tableView.getSelectionBackground());
                    jComponent.setForeground(tableView.getSelectionForeground());
                }
            } else if (tableView.isCellEditable(rowrIndex, columnIndex)) {
                if (BcMath.isEven(rowrIndex)) {
                    jComponent.setBackground(this.editableEvenRowBg1);
                    jComponent.setForeground(this.editableEvenRowFg1);
                } else {
                    jComponent.setBackground(this.editableOddRowBg1);
                    jComponent.setForeground(this.editableOddRowFg1);
                }
            } else if (BcMath.isEven(rowrIndex)) {
                jComponent.setBackground(this.evenRowBg2);
                jComponent.setForeground(this.evenRowFg2);
            } else {
                jComponent.setBackground(this.oddRowBg2);
                jComponent.setForeground(this.oddRowFg2);
            }
            if (hasFocus) {
                jComponent.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                if (tableView.isCellEditable(rowrIndex, columnIndex)) {
                    jComponent.setBackground(UIManager.getColor("Table.focusCellBackground"));
                    jComponent.setForeground(UIManager.getColor("Table.focusCellForeground"));
                }
            } else {
                jComponent.setBorder(this.noFocusBorder);
            }
            boolean colorMatch = (background = jComponent.getBackground()) != null && background.equals(tableView.getBackground()) && tableView.isOpaque();
            jComponent.setOpaque(!colorMatch);
            jComponent.setFont(tableView.getFont());
        }
    }

    protected Component getRendererComponent_L2(MmdField mmdField, Object cellValue1, boolean isEditable) throws Exception {
        boolean isEditor;
        Component component;
        Object cellValue2;
        MmdRenderingConverter renderingConverter = MmdDefaultRenderingConverter.getInstance();
        if (mmdField.fieldDisplay.renderingConverter != null) {
            renderingConverter = mmdField.fieldDisplay.renderingConverter;
        }
        if ((cellValue2 = renderingConverter.convertValue(mmdField, cellValue1)) == null) {
            this.label.setText(null);
            return this.label;
        }
        Class valueClass = cellValue2.getClass();
        if (mmdField.valueMap != null && MmdCellAttribute.class.isAssignableFrom(cellValue2.getClass())) {
            MmdCellAttribute cellAttribute = (MmdCellAttribute)cellValue2;
            if (cellAttribute.javaClassType != null) {
                valueClass = cellAttribute.javaClassType;
            }
            if (cellAttribute.background != null) {
                this.oddRowBg2 = cellAttribute.background;
                this.evenRowBg2 = cellAttribute.background;
            }
            if (cellAttribute.foreground != null) {
                this.oddRowFg2 = cellAttribute.foreground;
                this.evenRowFg2 = cellAttribute.foreground;
            }
        }
        if ((component = SwgTableViewUtil.getCellComponent_Number(mmdField, cellValue2, valueClass, isEditor = false, renderingConverter, null, this.label)) != null) {
            return component;
        }
        component = SwgTableViewUtil.getCellComponent_Calendar(mmdField, cellValue2, valueClass, isEditor, null, this.label);
        if (component != null) {
            return component;
        }
        component = SwgTableViewUtil.getCellComponent_Boolean(mmdField, cellValue2, valueClass, isEditor, isEditable, this.checkBox, this.label);
        if (component != null) {
            return component;
        }
        component = SwgTableViewUtil.getCellComponent_Text(mmdField, cellValue2, valueClass, isEditor, null, this.label, this.textComponent);
        return component;
    }

    public void setColor(Color backgroundColor, Color foregroundColor) {
        if (!this.isFirst) {
            return;
        }
        this.oddRowBg1 = SwgTableViewUtil.toRowOddBg(backgroundColor);
        this.evenRowBg1 = SwgTableViewUtil.toRowEvenBg(backgroundColor);
        this.isFirst = false;
    }

    protected String conv(String str) throws Exception {
        String target = "\u5c71";
        int index = str.indexOf(target);
        if (index < 0) {
            return str;
        }
        StringBuilder strbuf1 = new StringBuilder();
        strbuf1.append("<font color=\"#FF0000\">");
        strbuf1.append(target);
        strbuf1.append("</font>");
        StringBuilder strbuf2 = BcStringUtil.replace((CharSequence)str, target, strbuf1);
        strbuf2.insert(0, "<html>");
        strbuf2.append("</html>");
        return strbuf2.toString();
    }
}

