/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import jp.co.extreme.awt.AwtColorUtil;
import jp.co.extreme.swing.SwgControlPanel;

public class SwgControlBorderPanel
extends JPanel
implements ComponentListener {
    private static final long serialVersionUID = 1624060186962627304L;
    protected EtchedBorder etchedBorder = new EtchedBorder();
    protected TitledBorder titledBorder = new TitledBorder(this.etchedBorder);
    protected boolean b1;
    protected int xDiff = 16;
    protected int yDiff = 16;

    public SwgControlBorderPanel(String title, int fontSize) {
        this.setLayout(null);
        this.addComponentListener(this);
        this.setBorderTitle(title, fontSize);
    }

    public SwgControlBorderPanel(String title) {
        this.setLayout(null);
        this.addComponentListener(this);
        this.setBorderTitle(title, -1);
    }

    @Override
    public void componentResized(ComponentEvent ev) {
        this.calc();
    }

    @Override
    public void componentMoved(ComponentEvent ev) {
    }

    @Override
    public void componentShown(ComponentEvent ev) {
        this.calc();
    }

    @Override
    public void componentHidden(ComponentEvent ev) {
    }

    public void setBorderTitle(String title, int fontSize) {
        if (fontSize > 0) {
            this.titledBorder.setTitleFont(new Font("Dialog", 0, fontSize));
        } else {
            this.titledBorder.setTitleFont(new Font("Dialog", 0, 10));
        }
        this.titledBorder.setTitleColor(AwtColorUtil.hexToColor("004080"));
        this.titledBorder.setTitle(title);
        this.setBorder(this.titledBorder);
    }

    protected void calc() {
        if (this.b1) {
            this.b1 = false;
            return;
        }
        if (this.getParent() == null) {
            return;
        }
        Dimension dim0 = this.getSize();
        Component[] components = this.getComponents();
        if (components.length <= 0) {
            return;
        }
        Component component = components[0];
        if (SwgControlPanel.class.isAssignableFrom(component.getClass())) {
            SwgControlPanel controlPanel = (SwgControlPanel)component;
            Dimension dim5 = new Dimension(dim0.width - this.xDiff * 2, dim0.height);
            controlPanel.setSize(dim5);
            controlPanel.calc();
        }
        Dimension dim1 = component.getPreferredSize();
        component.setLocation(this.xDiff, this.yDiff);
        Dimension dim2 = new Dimension(dim1.width, dim1.height + this.yDiff * 2);
        this.b1 = true;
        this.setPreferredSize(dim2);
        this.setSize(dim2);
        this.getParent().validate();
    }
}

