/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf3.rmo;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jp.co.extreme.base.core.BcConstants;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.util.BcMessageCreator;
import jp.co.extreme.datasource.DtsConnectionManagerImpl;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.datasource.DtsSessionFactory;
import jp.co.extreme.datasource.DtsSessionFactoryManegaer;
import jp.co.extreme.datasource.util.DtsWordManagerImpl;
import jp.co.extreme.orm.dao.OrmSequenceDAO;
import jp.co.extreme.rmi.common.RmiRemoteMethod;
import jp.co.extreme.rmi.model.RmiRespons;
import jp.co.extreme.rmi.model.RmiRmoArgument;
import jp.co.extreme.rmi.rmo.RmiAbstractRMO;
import jp.co.extreme.scf.common.ScfHandle;
import jp.co.extreme.scf.common.ScfHandleResource;
import jp.co.extreme.scf.server.ScfServerContainer;
import jp.co.extreme.scf2.server.ScfTableHandleResource;
import jp.co.extreme.scf3.common.Scf3Words;
import jp.co.extreme.scf3.rmo.ScfSqlUtil;
import jp.co.extreme.scf3.server.ScfQueryTask;
import jp.co.extreme.scf3.server.ScfSqlHandleResource;
import jp.co.extreme.scf3.server.ScfTableModelTask;
import jp.co.extreme.sql.SqlResultSet;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;

public class ScfDatabaseRMO
extends RmiAbstractRMO {
    public static final String METHOD_getTableHeader = "getTableHeader";
    public static final String METHOD_cancelQuery = "cancelQuery";
    public static final String METHOD_getNextRecord = "getNextRecord";
    public static final String METHOD_getRowByRowNumbers = "getRowByRowNumbers";
    public static final String METHOD_getRowByRowNumber = "getRowByRowNumber";
    public static final String METHOD_generalList = "generalList";
    public static final String METHOD_getDatasourceProperties = "getDatasourceProperties";
    public static final String METHOD_getMmdFieldMap = "getMmdFieldMap";
    public static final String METHOD_remakeSequenceTable = "remakeSequenceTable";

    public ScfDatabaseRMO() {
        this.objectPoolEnabled = true;
    }

    public void getTableHeader(RmiRmoArgument rmoArg) throws Exception {
        String handleId = rmoArg.getRequest().getDataAsString();
        ScfHandle handle = ScfServerContainer.getInstance().getHandleManager().getHandle(handleId);
        if (handle == null) {
            String msg = "handle '" + handleId + "' is not found.";
            throw new Exception(msg);
        }
        ScfHandleResource handleResource = handle.getHandleResource(0);
        if (ScfSqlHandleResource.class.isAssignableFrom(handleResource.getClass())) {
            ScfSqlHandleResource sqlHandleResource = (ScfSqlHandleResource)handleResource;
            this.getTableHeaderByQueryTask(rmoArg, handle, sqlHandleResource);
        } else if (ScfTableHandleResource.class.isAssignableFrom(handleResource.getClass())) {
            ScfTableHandleResource tableHandleResource = (ScfTableHandleResource)handleResource;
            this.getTableHeaderByTableModelTask(rmoArg, handle, tableHandleResource);
        }
    }

    private void getTableHeaderByQueryTask(RmiRmoArgument rmoArg, ScfHandle handle, ScfSqlHandleResource sqlHandleResource) throws Exception {
        block7: {
            RmiRespons rmiRes = rmoArg.getRespons();
            ScfSqlUtil.setOk(rmiRes, false);
            ScfQueryTask queryTask = sqlHandleResource.queryTask;
            int tryCnt = 0;
            while (true) {
                ++tryCnt;
                if (queryTask.getThrowable() != null) {
                    if (queryTask.getThrowable() instanceof Exception) {
                        Exception exception = (Exception)queryTask.getThrowable();
                        throw exception;
                    }
                    throw new Exception(queryTask.getThrowable());
                }
                if (queryTask.canceled) {
                    this.getLogger().debug("queryTask.result=" + queryTask.result);
                    rmiRes.putData((Object)"result", queryTask.result);
                    break block7;
                }
                if (queryTask.result != null) break;
                Thread.sleep(100L);
            }
            if (queryTask.result instanceof ResultSet) {
                SqlResultSet rs = (SqlResultSet)queryTask.result;
                sqlHandleResource.setDBResource(queryTask.dtsSession, rs, queryTask.tableColumnList);
                ScfSqlUtil.setRespons(queryTask.dtsSession.getSqlContext(), rmiRes, handle, queryTask.tableColumnList, queryTask.tableContext, rs);
            } else if (queryTask.result instanceof Number) {
                Number updateCount = (Number)queryTask.result;
                ScfSqlUtil.setRespons(rmiRes, handle, updateCount.longValue());
            }
        }
    }

    private void getTableHeaderByTableModelTask(RmiRmoArgument rmoArg, ScfHandle handle, ScfTableHandleResource tableHandleResource) throws Exception {
        RmiRespons rmiRes = rmoArg.getRespons();
        rmiRes.addData(false);
        ScfTableModelTask tableModelTask = (ScfTableModelTask)tableHandleResource.tmpObject;
        int tryCnt = 0;
        while (true) {
            ++tryCnt;
            if (tableModelTask.getThrowable() != null) {
                throw new Exception(tableModelTask.getThrowable());
            }
            if (tableModelTask.tableColumnList != null) break;
            Thread.sleep(100L);
        }
        tableHandleResource.tableModel = tableModelTask.tableModel;
        tableHandleResource.tableContext = tableModelTask.tableContext;
        ScfSqlUtil.setRespons(rmiRes, handle, (List<BcTableColumn>)tableModelTask.tableColumnList, tableModelTask.tableContext);
    }

    public void cancelQuery(RmiRmoArgument rmoArg) throws Exception {
        String handleId = rmoArg.getRequest().getDataAsString();
        ScfHandle handle = ScfServerContainer.getInstance().getHandleManager().getHandle(handleId);
        if (handle == null) {
            this.getLogger().warning("handle '" + handleId + "' is not found.");
            return;
        }
        ScfHandleResource handleResource = handle.getHandleResource(0);
        if (ScfSqlHandleResource.class.isAssignableFrom(handleResource.getClass())) {
            ScfSqlHandleResource sqlHandleResource = (ScfSqlHandleResource)handleResource;
            this.cancelQuery(sqlHandleResource);
        }
    }

    public void cancelQuery(ScfSqlHandleResource sqlHandleResource) throws Exception {
        ScfQueryTask queryTask = sqlHandleResource.queryTask;
        if (queryTask == null) {
            this.getLogger().warning("queryTask=" + queryTask);
            return;
        }
        if (queryTask.stmt != null) {
            try {
                this.getLogger().info("stmt canceling... hashCode=" + queryTask.stmt.hashCode());
                queryTask.stmt.cancel();
                this.getLogger().info("stmt canceled. hashCode=" + queryTask.stmt.hashCode());
            }
            catch (Exception ex) {
                String msg = String.valueOf(ex.getMessage()) + " Statement.cancel() \u306b\u3066\u4f8b\u5916";
                this.getLogger().error(msg);
            }
        } else {
            String msg = "stmt is null.";
            throw new Exception(msg);
        }
        queryTask.stmt.close();
        queryTask.stmt = null;
        if (queryTask.dtsSession != null) {
            try {
                queryTask.dtsSession.desturuct();
            }
            catch (SQLException ex) {
                this.getLogger().error(ex);
            }
        } else {
            String msg = "queryTask.dtsSession is null.";
            this.getLogger().warning(msg);
        }
        queryTask.removeHandle();
    }

    public void getRow(List<BcTableColumn> tableColumnList, SqlResultSet rs, List valueList) throws Exception {
        ResultSetMetaData rsmd = rs.getMetaData();
        int i = 0;
        while (i < rsmd.getColumnCount()) {
            BcTableColumn tableColumn = tableColumnList.get(i);
            Object value = SqlUtil.getValue((ResultSet)rs, i + 1, tableColumn);
            valueList.add(value);
            ++i;
        }
    }

    public void getNextRecord(RmiRmoArgument rmoArg) throws Exception {
        String handleId = rmoArg.getRequest().getDataAsString();
        int reqRecCnt = rmoArg.getRequest().getDataAsNumber().intValue();
        ScfHandle handle = ScfServerContainer.getInstance().getHandleManager().getHandle(handleId, true);
        ScfHandleResource handleResource = handle.getHandleResource(0);
        if (ScfSqlHandleResource.class.isAssignableFrom(handleResource.getClass())) {
            ScfSqlHandleResource sqlHandleResource = (ScfSqlHandleResource)handleResource;
            this.getNextRecord(rmoArg, handle, sqlHandleResource, reqRecCnt);
        } else if (ScfTableHandleResource.class.isAssignableFrom(handleResource.getClass())) {
            ScfTableHandleResource tableHandleResource = (ScfTableHandleResource)handleResource;
            this.getNextRecord(rmoArg, handle, tableHandleResource, reqRecCnt);
        }
    }

    public void getNextRecord(RmiRmoArgument rmoArg, ScfHandle handle, ScfSqlHandleResource sqlHandleResource, int reqRecCnt) throws Exception {
        SqlResultSet rs = sqlHandleResource.getResultSet();
        List<BcTableColumn> tableColumnList = sqlHandleResource.getTableColumnList();
        ScfQueryTask queryTask = sqlHandleResource.queryTask;
        if (queryTask != null && queryTask.canceled) {
            throw new Exception("canceled=" + queryTask.canceled + " " + queryTask.result);
        }
        ArrayList<ArrayList<Object>> rowList = new ArrayList<ArrayList<Object>>(reqRecCnt);
        while ((reqRecCnt <= 0 || rowList.size() < reqRecCnt) && rs.next()) {
            ++sqlHandleResource.rowCount;
            if (queryTask != null && queryTask.rowLimit > 0L && sqlHandleResource.rowCount > queryTask.rowLimit) break;
            ArrayList<Object> row = new ArrayList<Object>();
            if (sqlHandleResource.sqlHandleResolver != null) {
                sqlHandleResource.sqlHandleResolver.getCurrentRow(sqlHandleResource.getdtsSession(), rs, row);
            } else {
                this.getRow(tableColumnList, rs, row);
            }
            rowList.add(row);
        }
        if (rowList.size() < reqRecCnt) {
            rmoArg.getRespons().putData((Object)"eod", BcConstants.Existence.TRUE.value);
        } else {
            rmoArg.getRespons().putData((Object)"eod", BcConstants.Existence.FALSE.value);
        }
        rmoArg.getRespons().putData((Object)"tb_rl", rowList);
    }

    public void getNextRecord(RmiRmoArgument rmoArg, ScfHandle handle, ScfTableHandleResource tableHandleResource, int reqRecCnt) throws Exception {
        ArrayList<List> rowList = new ArrayList<List>(reqRecCnt);
        BcTableModel tableModel = tableHandleResource.tableModel;
        while (tableHandleResource.rowSeq < tableModel.getRowCount() - 1 && (reqRecCnt <= 0 || rowList.size() < reqRecCnt)) {
            ++tableHandleResource.rowSeq;
            List row = tableModel.getRow(tableHandleResource.rowSeq);
            rowList.add(row);
        }
        if (rowList.size() < reqRecCnt) {
            rmoArg.getRespons().putData((Object)"eod", BcConstants.Existence.TRUE.value);
        } else {
            rmoArg.getRespons().putData((Object)"eod", BcConstants.Existence.FALSE.value);
        }
        rmoArg.getRespons().putData((Object)"tb_rl", rowList);
    }

    public void getRowByRowNumbers(RmiRmoArgument rmoArg) throws Exception {
        String handleId = rmoArg.getRequest().getDataAsString();
        String rowNumbers = rmoArg.getRequest().getDataAsString();
        ScfHandle handle = ScfServerContainer.getInstance().getHandleManager().getHandle(handleId, true);
        ScfHandleResource handleResource = handle.getHandleResource(0);
        ScfSqlHandleResource sqlHandleResource = (ScfSqlHandleResource)handleResource;
        SqlResultSet rs = sqlHandleResource.getResultSet();
        String[] rowNumberArray = rowNumbers.split(BcStringUtil.COMMA_STR);
        ArrayList rowList = new ArrayList();
        int i = 0;
        while (i < rowNumberArray.length) {
            Integer rowNumber = Integer.parseInt(rowNumberArray[i]);
            rs.absolute(rowNumber);
            ArrayList row = new ArrayList();
            this.getRow(sqlHandleResource.getTableColumnList(), rs, row);
            rowList.add(row);
            ++i;
        }
        rmoArg.getRespons().addData(rowList);
    }

    public void getRowByRowNumber(RmiRmoArgument rmoArg) throws Exception {
        String handleId = rmoArg.getRequest().getDataAsString();
        Integer rowNumber = rmoArg.getRequest().getDataAsInteger();
        ScfHandle handle = ScfServerContainer.getInstance().getHandleManager().getHandle(handleId, true);
        ScfHandleResource handleResource = handle.getHandleResource(0);
        ScfSqlHandleResource sqlHandleResource = (ScfSqlHandleResource)handleResource;
        SqlResultSet rs = sqlHandleResource.getResultSet();
        rs.absolute(rowNumber);
        ArrayList row = new ArrayList();
        this.getRow(sqlHandleResource.getTableColumnList(), rs, row);
        rmoArg.getRespons().addData(row);
    }

    public void generalList(RmiRmoArgument rmoArg) throws Exception {
        String datasourceName = rmoArg.getRequest().getDataAsString();
        Object sqlObj = rmoArg.getRequest().getData();
        DtsSession dtsSessionWk = DtsSessionFactoryManegaer.getInstance().createSession(datasourceName, this);
        if (CharSequence.class.isAssignableFrom(sqlObj.getClass())) {
            ScfQueryTask queryTask = ScfSqlUtil.createQueryTask(rmoArg, dtsSessionWk);
            queryTask.query = sqlObj.toString();
            ScfSqlUtil.generalListNew(queryTask, (Object)this);
        } else if (SqlSelectQuery.class.isAssignableFrom(sqlObj.getClass())) {
            ScfQueryTask queryTask = ScfSqlUtil.createQueryTask(rmoArg, dtsSessionWk);
            SqlSelectQuery selectQuery = (SqlSelectQuery)sqlObj;
            SqlContext sqlContextWk = dtsSessionWk.getSqlContext();
            queryTask.tableColumnNameList = selectQuery.getSelectColumnList();
            queryTask.query = sqlContextWk.buildSelectQuery(selectQuery);
            ScfSqlUtil.generalListNew(queryTask, (Object)this);
        } else {
            String msg = BcMessageCreator.getInstance().bindMessage(Scf3Words.getInstance().MSG_\u30aa\u30d6\u30b8\u30a7\u30af\u30c8_0_\u306f\u30b5\u30dd\u30fc\u30c8\u5bfe\u8c61\u5916\u3067\u3059, sqlObj);
            throw new Exception(msg);
        }
    }

    public void getDatasourceProperties(RmiRmoArgument rmoArg) throws Exception {
        String datasourceName = rmoArg.getRequest().getDataAsString();
        DtsSessionFactory sessionFactory = DtsSessionFactoryManegaer.getInstance().getSessionFactory(datasourceName);
        if (sessionFactory == null) {
            rmoArg.getRespons().addData(null);
            return;
        }
        DtsConnectionManagerImpl connectionManager = (DtsConnectionManagerImpl)sessionFactory.getConnectionManager();
        Properties dtsProps = connectionManager.getDataSourceProperties();
        rmoArg.getRespons().addData(dtsProps);
    }

    public void getMmdFieldMap(RmiRmoArgument rmoArg) throws Exception {
        String datasourceName = rmoArg.getRequest().getDataAsString();
        BcLogUtil.debug("datasourceName=" + datasourceName);
        DtsSessionFactory sessionFactory = DtsSessionFactoryManegaer.getInstance().getSessionFactory(datasourceName);
        rmoArg.getRespons().addData(sessionFactory.mmdFieldMap);
        DtsWordManagerImpl wordManager = (DtsWordManagerImpl)sessionFactory.wordManager;
        rmoArg.getRespons().addData(wordManager.wordMap);
        rmoArg.getRespons().addData(wordManager.langCodeList);
    }

    public void remakeSequenceTable(RmiRmoArgument rmoArg) throws Exception {
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        OrmSequenceDAO.getInstance().conpareNumber(dtsSession, true);
    }

    public void checkDatasource(RmiRmoArgument rmoArg) throws Exception {
        BcLogger logger = this.getLogger();
        for (Map.Entry<String, DtsSessionFactory> mapEntry : DtsSessionFactoryManegaer.getInstance().getSessionFactoryMap().entrySet()) {
            this.checkDatasource(mapEntry.getValue(), logger);
        }
    }

    public String checkDatasource(DtsSessionFactory sessionFactory, BcLogger logger) throws Exception {
        StringBuilder sb = new StringBuilder();
        logger.debug("Session Factory Name=" + sessionFactory.getName());
        DtsConnectionManagerImpl connectionManagerImpl = (DtsConnectionManagerImpl)sessionFactory.getConnectionManager();
        logger.debug("URL=" + connectionManagerImpl.getJdbcUrl());
        connectionManagerImpl.validation(false, this.getLogger());
        return sb.toString();
    }

    public static enum Method implements RmiRemoteMethod
    {
        checkDatasource;


        @Override
        public String getMethodName() {
            return this.name();
        }
    }
}

