/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf.rmo;

import java.lang.reflect.Method;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Calendar;
import jp.co.extreme.base.core.BcJavaConstants;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.net.BcAddressPort;
import jp.co.extreme.base.net.BcNetUtil;
import jp.co.extreme.base.reflect.BcReflectUtil;
import jp.co.extreme.base.runtime.BcRuntimeContext;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.util.BcObjectPoolManager;
import jp.co.extreme.rmi.agent.RmiAgentContext;
import jp.co.extreme.rmi.connector.RmiObjectStreamConnector;
import jp.co.extreme.rmi.model.RmiRequest;
import jp.co.extreme.rmi.model.RmiRmoArgument;
import jp.co.extreme.rmi.rmo.RmiAbstractRMO;
import jp.co.extreme.rmi.server.RmiAgentEventHandler;
import jp.co.extreme.rmi.server.RmiRemoteAgent;
import jp.co.extreme.rmi.server.RmiServer;
import jp.co.extreme.scf.common.ScfHandle;
import jp.co.extreme.scf.common.ScfHandleManager;
import jp.co.extreme.scf.rmi.server.RmiProcessHandle;
import jp.co.extreme.scf.rmi.server.RmiServerModule;
import jp.co.extreme.scf.server.ScfServerContainer;

public class ScfHandleRMO
extends RmiAbstractRMO {
    public static final String METHOD_removeHandle = "removeHandle";
    public static final String METHOD_checkFirstStatus = "checkFirstStatus";
    public static final String METHOD_heartBeart = "heartBeart";

    public ScfHandleRMO() {
        this.objectPoolEnabled = true;
    }

    public void removeHandle(RmiRmoArgument rmixArg) throws Exception {
        Object handleId = rmixArg.getRequest().getData();
        ScfHandleManager handleManager = ScfServerContainer.getInstance().getHandleManager();
        ScfHandle handle = handleManager.removeHandle(handleId);
        boolean res = false;
        if (handle != null) {
            res = true;
            try {
                handle.close();
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
        rmixArg.getRespons().addData(res);
    }

    public void checkFirstStatus(RmiRmoArgument rmixArg) throws Exception {
        BcRuntimeContext runtimeContext = (BcRuntimeContext)rmixArg.getRequest().getData();
        this.getLogger().info("hostAddress=" + runtimeContext.hostAddress);
        this.getLogger().info("hostName=" + runtimeContext.hostName);
        this.getLogger().info("javaVersion=" + runtimeContext.getSystemProperties().getProperty(BcJavaConstants.SysKey.java_version.value));
        this.getLogger().info("osName=" + runtimeContext.getSystemProperties().getProperty(BcJavaConstants.SysKey.os_name.value));
        this.getLogger().info("osVersion=" + runtimeContext.getSystemProperties().getProperty(BcJavaConstants.SysKey.os_version.value));
        this.getLogger().info("userName=" + runtimeContext.getSystemProperties().getProperty(BcJavaConstants.SysKey.user_name.value));
        RmiRemoteAgent remoteAgent = (RmiRemoteAgent)rmixArg.getAgent();
        RmiAgentContext agentContext = remoteAgent.getContext();
        agentContext.setRuntimeContext(runtimeContext);
        RmiObjectStreamConnector objectStreamConnector = (RmiObjectStreamConnector)remoteAgent.getConnector();
        Socket socket = objectStreamConnector.getSocket();
        SocketAddress remoteSocketAddress = socket.getRemoteSocketAddress();
        BcAddressPort remoteAddressPort = BcNetUtil.parseAddressPort(remoteSocketAddress.toString());
        String userName = runtimeContext.getSystemProperties().getProperty(BcJavaConstants.SysKey.user_name.value);
        agentContext.userSummary = String.valueOf(remoteAddressPort.address) + ":" + remoteAddressPort.port + "/" + userName;
        this.getLogger().debug("setSocket:userSummary=" + agentContext.userSummary);
        String domainCode = rmixArg.getRequest().getDataAsString();
        String password = rmixArg.getRequest().getDataAsString();
        boolean isAuth = true;
        if (isAuth) {
            rmixArg.getRespons().setStatusId(1);
            rmixArg.getRespons().addData(rmixArg.getAgent().getAgentId());
        } else {
            rmixArg.getRespons().setStatusId(2);
            rmixArg.getRespons().setException(new Exception("\u30c9\u30e1\u30a4\u30f3\u30b3\u30fc\u30c9\u307e\u305f\u306f\u30d1\u30b9\u30ef\u30fc\u30c9\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002"));
            this.getLogger().info("\u30c9\u30e1\u30a4\u30f3\u30b3\u30fc\u30c9\u307e\u305f\u306f\u30d1\u30b9\u30ef\u30fc\u30c9\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002");
        }
        RmiServer rmixServer = ScfServerContainer.getInstance().rmiServerModule.getServer();
        RmiAgentEventHandler[] agentEventHandlers = rmixServer.agentEventHandlerList.toArray(new RmiAgentEventHandler[0]);
        int i = 0;
        while (i < agentEventHandlers.length) {
            try {
                agentEventHandlers[i].firstStatusChecked(rmixArg.getAgent());
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
            }
            ++i;
        }
    }

    public void executeMethod(RmiRmoArgument rmixArg) throws Exception {
        String className = rmixArg.getRequest().getDataAsString();
        String methodName = rmixArg.getRequest().getDataAsString();
        Object targetObj = BcObjectPoolManager.getInstance().getObject(className);
        Class<?> clazz = null;
        if (targetObj == null) {
            clazz = Class.forName(className);
            targetObj = BcReflectUtil.getInstance(clazz);
            BcObjectPoolManager.getInstance().addObject(className, targetObj);
        } else {
            clazz = targetObj.getClass();
        }
        Class[] paramTypeArray = new Class[]{rmixArg.getAgent().getContext().getClass(), rmixArg.getRequest().getClass(), rmixArg.getRespons().getClass()};
        Method method = clazz.getMethod(methodName, paramTypeArray);
        Object[] paramValueArray = new Object[]{rmixArg.getAgent().getContext(), rmixArg.getRequest(), rmixArg.getRespons()};
        method.invoke(targetObj, paramValueArray);
    }

    public void heartBeart(RmiRmoArgument rmixArg) throws Exception {
        rmixArg.getAgent().getContext().lastHertBeatTime = System.currentTimeMillis();
    }

    public void isProcessing(RmiRmoArgument rmixArg) throws Exception {
        String handleId = rmixArg.getRequest().getDataAsString();
        RmiProcessHandle procHandle = (RmiProcessHandle)ScfServerContainer.getInstance().getHandleManager().getHandle(handleId);
        if (procHandle != null) {
            if (procHandle.isProcessing()) {
                rmixArg.getRespons().setStatusId(22);
                rmixArg.getRespons().addData(procHandle.getMessage());
            } else {
                rmixArg.getRespons().setStatusId(1);
            }
        } else {
            rmixArg.getRespons().setStatusId(23);
        }
    }

    public void noticeToAllClient(RmiRmoArgument rmixArg) throws Exception {
        RmiRequest rmiRequest = (RmiRequest)rmixArg.getRequest().getData();
    }

    public void getClientList(RmiRmoArgument rmixArg) throws Exception {
        BcTableModel tableModel = this.getClientTable();
        rmixArg.getRespons().addData(tableModel);
    }

    public BcTableModel getClientTable() throws Exception {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        BcTableColumn tableColumn = null;
        MmdField mmdField = null;
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = Integer.class;
        tableColumn.setMmdField(mmdField);
        tableColumn.setHeaderValue("ID");
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = Calendar.class;
        tableColumn.setMmdField(mmdField);
        tableColumn.setHeaderValue("connection start");
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = String.class;
        tableColumn.setMmdField(mmdField);
        tableColumn.setHeaderValue("Java");
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = String.class;
        tableColumn.setMmdField(mmdField);
        tableColumn.setHeaderValue("OS");
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = Integer.class;
        tableColumn.setMmdField(mmdField);
        tableColumn.setHeaderValue("Domain Id");
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = String.class;
        tableColumn.setMmdField(mmdField);
        tableColumn.setHeaderValue("Login Account");
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        BcTableModel tableModel = new BcTableModel(tableColumnModel);
        RmiServerModule rmiServerModule = ScfServerContainer.getInstance().rmiServerModule;
        RmiRemoteAgent[] remoteAgents = rmiServerModule.getServer().getAgentList().toArray(new RmiRemoteAgent[0]);
        int i = 0;
        while (i < remoteAgents.length) {
            RmiRemoteAgent remoteAgent = remoteAgents[i];
            RmiAgentContext agentContext2 = remoteAgent.getContext();
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(remoteAgent.getAgentId());
            row.add(remoteAgent.getContext().acceptDatetime);
            if (agentContext2.getRuntimeContext() != null) {
                String str = String.valueOf(agentContext2.getRuntimeContext().getSystemProperties().getProperty("java.version", "")) + " " + agentContext2.getRuntimeContext().getSystemProperties().getProperty("java.vendor", "");
                row.add(str);
                str = String.valueOf(agentContext2.getRuntimeContext().getSystemProperties().getProperty("os.name", "")) + " " + agentContext2.getRuntimeContext().getSystemProperties().getProperty("os.arch", "") + " " + agentContext2.getRuntimeContext().getSystemProperties().getProperty("os.version", "");
                row.add(str);
            } else {
                row.add(null);
                row.add(null);
            }
            row.add(null);
            row.add(null);
            tableModel.addRow(row);
            ++i;
        }
        return tableModel;
    }
}

