/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.rmi.client;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Timer;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.rmi.client.RmiAbstractLocalAgent;
import jp.co.extreme.rmi.client.RmiAgentNetThread;
import jp.co.extreme.rmi.connector.RmiConnector;
import jp.co.extreme.rmi.model.RmiNetConfig;
import jp.co.extreme.rmi.model.RmiPacket;
import jp.co.extreme.rmi.model.RmiRequest;
import jp.co.extreme.rmi.model.RmiRespons;
import jp.co.extreme.rmi.server.RmiRmoInvoker;

public class RmiAgentNet
extends RmiAbstractLocalAgent
implements Serializable {
    private static final long serialVersionUID = 8513803573230772014L;
    protected RmiNetConfig netConfig;
    protected RmiConnector connector;
    protected int remoteAgentId;
    public String domainCode;
    public String password;
    protected RmiRmoInvoker rmoInvoker;
    protected Timer timer;
    protected RmiAgentNetThread clientNetThread;
    protected boolean isOpen;
    public Calendar latestRequestTime = BcTimeUtil.createCalendar();

    public RmiNetConfig getNetConfig() {
        return this.netConfig;
    }

    public void setNetConfig(RmiNetConfig netConfig) {
        this.netConfig = netConfig;
    }

    @Override
    public RmiRespons invoke(RmiRequest rmiReq) throws Exception {
        this.latestRequestTime = BcTimeUtil.createCalendar();
        RmiRespons rmiRes = this.connector.sendRequest(rmiReq);
        this.checkResponsStatus(rmiReq, rmiRes);
        return rmiRes;
    }

    @Override
    public void open() throws Exception {
        this.getLogger().debug("disconnected:open.isOpen()=" + this.isOpen());
        if (this.isOpen()) {
            this.getLogger().info("RmiNetConfig(hashCode" + this.hashCode() + ") \u306f\u65e2\u306b\u63a5\u7d9a\u3092\u5b8c\u4e86\u3057\u3066\u307e\u3059\u3002");
            return;
        }
        if (this.clientNetThread == null) {
            this.clientNetThread = new RmiAgentNetThread(this);
        }
        this.clientNetThread.startThread();
    }

    @Override
    public boolean isOpen() throws Exception {
        return this.isOpen;
    }

    public void setOpen(boolean isOpen) throws Exception {
        this.isOpen = isOpen;
        if (this.rmoInvoker == null) {
            this.rmoInvoker = new RmiRmoInvoker();
        }
    }

    @Override
    public void close() throws Exception {
        this.setOpen(false);
        if (this.connector != null) {
            try {
                this.connector.close(this);
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
            }
            this.connector = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    @Override
    public void disconnected(RmiConnector rmixConnector, Object operator) throws Exception {
        this.isOpen = false;
        this.getLogger().debug("disconnected:rmixConnector=" + rmixConnector.getClass().getCanonicalName());
        this.getLogger().info("\u30bd\u30b1\u30c3\u30c8\u63a5\u7d9a\u304c\u5207\u65ad\u3055\u308c\u307e\u3057\u305f\u3002");
        this.getLogger().debug("disconnected:operator.hashCode()=" + operator.hashCode());
        this.getLogger().debug("disconnected:this.hashCode()=" + this.hashCode());
        if (operator.hashCode() != this.hashCode()) {
            this.open();
        }
    }

    @Override
    public void dataRecieved(RmiPacket rmixPacket) {
        switch (rmixPacket.getPacketType()) {
            case 11: {
                RmiRequest rmiReq = (RmiRequest)rmixPacket;
                try {
                    RmiRespons rmiRes = this.rmoInvoker.executeRequest(this, rmiReq);
                    this.connector.sendRespons(rmiRes);
                }
                catch (Exception ex) {
                    this.getLogger().error(ex);
                }
                break;
            }
            case 13: {
                RmiRequest rmiReq = (RmiRequest)rmixPacket;
                try {
                    this.rmoInvoker.executeRequest(this, rmiReq);
                    break;
                }
                catch (Exception ex) {
                    this.getLogger().error(ex);
                }
            }
        }
    }

    public int getRemoteAgentId() {
        return this.remoteAgentId;
    }

    public void setRemoteAgentId(int remoteAgentId) {
        this.remoteAgentId = remoteAgentId;
    }
}

