/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.poi;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcUnicode;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.mmd.MmdDefaultRenderingConverter;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.mmd.MmdRenderingConverter;
import jp.co.extreme.base.util.BcObjectPoolManager;
import jp.co.extreme.poi.PoiConstants;
import jp.co.extreme.poi.PoiExportCondition;
import jp.co.extreme.poi.PoiExportEventHandler;

public class PoiAbstractCsvWriter
extends BcLoggableObject {
    protected PoiExportCondition exportCondition;
    protected Locale locale;
    protected List<PoiExportEventHandler> exportEventHandlerList = new ArrayList<PoiExportEventHandler>();

    public PoiAbstractCsvWriter() throws Exception {
        this.setCondition(new PoiExportCondition());
    }

    public PoiExportCondition getCondition() throws Exception {
        return this.exportCondition;
    }

    public void setCondition(PoiExportCondition exportCondition) throws Exception {
        this.exportCondition = exportCondition;
    }

    public Locale getLocale() throws Exception {
        if (this.locale != null) {
            return this.locale;
        }
        this.locale = this.exportCondition.locale != null ? this.exportCondition.locale : Locale.getDefault();
        return this.locale;
    }

    public String escapEncode(String text) throws Exception {
        Pattern pattern = Pattern.compile(BcUnicode.quotationMark.string);
        Matcher matcher = pattern.matcher(text);
        return matcher.replaceAll(String.valueOf(BcUnicode.quotationMark.string) + BcUnicode.quotationMark.string);
    }

    public boolean hasSpecialCharacter(String text) throws Exception {
        int i = 0;
        while (i < PoiConstants.ESCAPE_SEQENCE_CHARS.length) {
            char aChar = PoiConstants.ESCAPE_SEQENCE_CHARS[i];
            if (text.indexOf(aChar) >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void write(Writer writer, String str) throws Exception {
        if (BcStringUtil.isEmpty(str)) {
            return;
        }
        writer.write(str);
    }

    public void writeValue(Writer writer, Object value, MmdField mmdField) throws Exception {
        String textValue = null;
        if (value != null) {
            if (this.exportCondition.codeMapEnabled) {
                MmdRenderingConverter renderingConverter = MmdDefaultRenderingConverter.getInstance();
                if (mmdField != null && !BcStringUtil.isEmpty(mmdField.fieldDisplay.renderingConverterClassName)) {
                    renderingConverter = (MmdRenderingConverter)BcObjectPoolManager.getInstance().getObject(mmdField.fieldDisplay.renderingConverterClassName, true);
                }
                textValue = renderingConverter.toString(mmdField, value);
            } else {
                textValue = BcStringUtil.toString(value);
            }
        }
        boolean quotationMarkEnabled = false;
        if (this.exportCondition.quotationMarkPolicy == PoiConstants.QuotationMarkPolicy.necessary) {
            if (!BcStringUtil.isEmpty(textValue)) {
                quotationMarkEnabled = this.hasSpecialCharacter(textValue);
            }
        } else if (this.exportCondition.quotationMarkPolicy == PoiConstants.QuotationMarkPolicy.always) {
            quotationMarkEnabled = true;
        } else {
            String msg = "Not Spported Quotation Mark Policy.'" + (Object)((Object)this.exportCondition.quotationMarkPolicy) + "'";
            throw new Exception(msg);
        }
        if (quotationMarkEnabled) {
            this.write(writer, BcUnicode.quotationMark.string);
        }
        if (!BcStringUtil.isEmpty(textValue)) {
            this.write(writer, this.escapEncode(textValue));
        }
        if (quotationMarkEnabled) {
            this.write(writer, BcUnicode.quotationMark.string);
        }
    }

    public void writeValueCollection(Writer writer, Collection collection) throws Exception {
        Object[] objects = collection.toArray();
        int i = 0;
        while (i < objects.length) {
            this.writeValue(writer, objects[i], null);
            this.write(writer, this.exportCondition.fieldSeparator);
            ++i;
        }
    }

    public void addExportEventHandler(PoiExportEventHandler exportEventHandler) {
        this.exportEventHandlerList.add(exportEventHandler);
    }

    public boolean removeExportEventHandler(PoiExportEventHandler exportEventHandler) {
        return this.exportEventHandlerList.remove(exportEventHandler);
    }
}

