/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xupd.fx;

import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import jp.co.extreme.fx.control.FxLabel;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.skin.FxCssUtil;
import jp.co.extreme.fx.skin.FxSkinUtil;
import jp.co.extreme.fx.stage.FxStage;
import jp.co.extreme.fx.util.FxColorUtil;
import jp.co.extreme.fx.util.FxFontUtil;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxUtil;

public class XupdMonitorPane {
    protected FxDecoratePane decoratePane = new FxDecoratePane();
    protected FlowPane bottomPane = new FlowPane();
    protected VBox centerVBox = new VBox();
    protected ProgressIndicator progressIndicator = new ProgressIndicator();
    public FxLabel infoLabeld = new FxLabel();
    protected Window ownerWindow;
    public Stage stage;

    public XupdMonitorPane() throws Exception {
        this.initComponent();
    }

    protected void initComponent() throws Exception {
        this.decoratePane.setBottom((Node)this.bottomPane);
        this.decoratePane.setCenter((Node)this.centerVBox);
        this.centerVBox.setSpacing(10.0);
        this.centerVBox.setAlignment(Pos.CENTER);
        Color bgColor1 = FxSkinUtil.getColorByKey("Panel.background");
        Color bgColor2 = FxColorUtil.colorChange(bgColor1, 40);
        String style1 = FxCssUtil.css_backgroundColor_linearGradient(bgColor1, bgColor2, 4);
        this.centerVBox.setStyle(style1.toString());
        float value = -1.0f;
        this.progressIndicator.setProgress((double)value);
        this.centerVBox.getChildren().addAll((Object[])new Node[]{this.progressIndicator});
        FxUtil.setFont((Node)this.infoLabeld, FxFontUtil.font_12_black);
        this.centerVBox.getChildren().addAll((Object[])new Node[]{this.infoLabeld});
    }

    public void close() {
        this.stage.close();
    }

    protected void windowOpend() {
    }

    public void show(String title, Window ownerWindow) throws Exception {
        this.ownerWindow = ownerWindow;
        this.stage = new FxStage(StageStyle.DECORATED);
        if (ownerWindow != null) {
            this.stage.initModality(Modality.WINDOW_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                XupdMonitorPane.this.windowOpend();
            }
        });
        this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                ev.consume();
            }
        });
        FxScene scene = new FxScene((Parent)this.decoratePane);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth(440.0);
        this.stage.setHeight(240.0);
        this.stage.setResizable(false);
        this.stage.setTitle(title);
        FxImageHelper.setStageIcon(this.stage);
        this.stage.show();
    }
}

