/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.doc.poi.DcfExcel2Book;
import jp.co.extreme.doc.renderer.DcfShapeRenderer;
import jp.co.extreme.module.xfil.common.XfilUtil;
import jp.co.extreme.module.xfil.model.XfilUriEntity;
import jp.co.extreme.module.xfil.parser.XfilFileParser;
import org.apache.poi.hdgf.extractor.VisioTextExtractor;

public class XfilMsVisioParser
extends BcLoggableObject
implements XfilFileParser {
    DcfExcel2Book excel2Book = new DcfExcel2Book();
    DcfShapeRenderer shapeRenderer = new DcfShapeRenderer();

    @Override
    public void parse(XfilUriEntity uriEntity) throws Exception {
        File file = XfilUtil.toFile(uriEntity);
        if (file.exists()) {
            this.parse(uriEntity, file);
            uriEntity.thumbnailTimestamp = BcTimeUtil.createCalendar();
        } else {
            BcLogUtil.warning("Not found file:" + file.getPath());
            uriEntity.missingTimestamp = BcTimeUtil.createCalendar();
        }
    }

    protected void parse(XfilUriEntity uriEntity, File file) throws Exception {
        VisioTextExtractor extractor = new VisioTextExtractor((InputStream)new FileInputStream(file));
        CharSequence[] strs = extractor.getAllText();
        uriEntity.text02 = String.join((CharSequence)"\n", strs);
        BcLogUtil.debug("uriEntity.text02=" + uriEntity.text02);
        extractor.close();
    }
}

