/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.common;

import java.io.File;
import java.util.Collection;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcProcessExecutor;
import jp.co.extreme.module.xfil.common.FfmpegParamBuiler;
import jp.co.extreme.module.xfil.common.FfpegParam;
import jp.co.extreme.module.xfil.common.FfpegText;
import org.apache.commons.lang3.time.DurationFormatUtils;

public final class FfmpegUtil {
    public static final String FORMAT_time = "HH:mm:ss.SSS";
    static BcProcessExecutor processExecutor = new BcProcessExecutor();
    public static String ffmpegPath;

    private FfmpegUtil() {
    }

    public static Integer checkVersion() throws Exception {
        FfmpegParamBuiler ffmpegParamBuiler = new FfmpegParamBuiler();
        List<String> argList = ffmpegParamBuiler.version().build();
        BcProcessExecutor.BcProcessResult processResult = processExecutor.execute(ffmpegPath, argList);
        return processResult.exitValue;
    }

    public static String formatDuration(long durationMillis) {
        return DurationFormatUtils.formatDuration(durationMillis, FORMAT_time);
    }

    public static List<String> createArgList(FfpegParam ffpegParam) throws Exception {
        FfmpegParamBuiler ffmpegParamBuiler = new FfmpegParamBuiler();
        ffmpegParamBuiler.startTimeMillis(ffpegParam.startTimeMillis);
        ffmpegParamBuiler.input(ffpegParam.inputPath);
        ffmpegParamBuiler.scale(ffpegParam.width, ffpegParam.height);
        if (!BcCollectionUtil.isEmpty(ffpegParam.ffpegTextList)) {
            for (FfpegText ffpegText : ffpegParam.ffpegTextList) {
                ffmpegParamBuiler.text(ffpegText);
            }
        }
        List<String> argList = ffmpegParamBuiler.build();
        argList.add("-vframes");
        argList.add("1");
        argList.add("-f");
        argList.add("image2");
        argList.add("-y");
        argList.add(ffpegParam.outputPath);
        return argList;
    }

    public static BcProcessExecutor.BcProcessResult createImage(FfpegParam ffpegParam) throws Exception {
        FfmpegUtil.checkSetting();
        List<String> argList = FfmpegUtil.createArgList(ffpegParam);
        argList.add(0, ffmpegPath);
        BcProcessExecutor.BcProcessResult processResult = processExecutor.execute(argList);
        return processResult;
    }

    public static List<String> createArgList(File imputFile, File outputFile, int width, int height, Collection<Long> frameNoCollection) throws Exception {
        FfmpegParamBuiler ffmpegParamBuiler = new FfmpegParamBuiler();
        ffmpegParamBuiler.input(imputFile.getPath());
        ffmpegParamBuiler.scale(width, height);
        ffmpegParamBuiler.eq(frameNoCollection);
        List<String> argList = ffmpegParamBuiler.build();
        argList.add("-vsync");
        argList.add("0");
        argList.add("-f");
        argList.add("image2");
        argList.add("-y");
        argList.add(String.valueOf(outputFile.getParentFile().getPath()) + "/out-%03d.jpg");
        return argList;
    }

    public static BcProcessExecutor.BcProcessResult createImage(File imputFile, File outputFile, int width, int height, Collection<Long> frameNoCollection) throws Exception {
        FfmpegUtil.checkSetting();
        List<String> argList = FfmpegUtil.createArgList(imputFile, outputFile, width, height, frameNoCollection);
        BcProcessExecutor.BcProcessResult processResult = processExecutor.execute(ffmpegPath, argList);
        return processResult;
    }

    public static void checkSetting() throws Exception {
        if (BcStringUtil.isEmpty(ffmpegPath)) {
            throw new Exception("ffmpegPath is empty.");
        }
        File file = new File(ffmpegPath);
        if (!file.exists()) {
            throw new Exception("ffmpegPath not exists.");
        }
    }

    public static enum Resolution {
        _144p(256, 144, "144p", null),
        _240p(427, 240, "240p", null),
        _360p(640, 360, "360p", null),
        _480p(720, 480, "480p", "DVD"),
        _720p(1280, 720, "720p", "HD:\u30cf\u30a4\u30d3\u30b8\u30e7\u30f3"),
        _1080p(1920, 1080, "1080p", "\u30d5\u30ebHD:\u30d5\u30eb\u30cf\u30a4\u30d3\u30b8\u30e7\u30f3 2K"),
        _1440p(2560, 1440, "1440p", null),
        _2160p(3840, 2160, "2160p", "4K");

        public final int width;
        public final int height;
        public final String code;
        public final String note;

        private Resolution(int width, int height, String code, String note) {
            this.width = width;
            this.height = height;
            this.code = code;
            this.note = note;
        }

        public static Resolution getByCode(String code) {
            Resolution[] resolutionArray = Resolution.values();
            int n = resolutionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Resolution resolution = resolutionArray[n2];
                if (resolution.code.equalsIgnoreCase(code)) {
                    return resolution;
                }
                ++n2;
            }
            return null;
        }
    }
}

