/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.rmo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.datasource.DtsSessionFactory;
import jp.co.extreme.etc.util.EtcEnumStrUtil;
import jp.co.extreme.etc.util.EtcWordUtil;
import jp.co.extreme.module.xdts.common.XdtsUtil;
import jp.co.extreme.module.xdts.dao.XdtsExtractionConditionDAO;
import jp.co.extreme.module.xdts.model.v0001.XdtsExtractionCondition;
import jp.co.extreme.module.xdts.server.XdtsServerUtil;
import jp.co.extreme.module.xdts.server.XdtsSessionFactoryManager;
import jp.co.extreme.rmi.common.RmiRemoteMethod;
import jp.co.extreme.rmi.model.RmiRmoArgument;
import jp.co.extreme.rmi.rmo.RmiAbstractRMO;

public class XdtsExtractionConditionRMO
extends RmiAbstractRMO {
    String namePrefix;

    public XdtsExtractionConditionRMO() {
        this.namePrefix = BcWords.getInstance().extractionCondition + "-";
    }

    public void putEntity(RmiRmoArgument rmoArg) throws Exception {
        XdtsExtractionCondition extractionCondition = (XdtsExtractionCondition)rmoArg.getRequest().getData();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        extractionCondition.name = BcStringUtil.trim(extractionCondition.name);
        extractionCondition.group = XdtsUtil.reformPath(extractionCondition.group);
        XdtsExtractionConditionDAO.getInstance().putEntity(dtsSession, extractionCondition);
        extractionCondition.name = this.createName(dtsSession, extractionCondition.profileId, extractionCondition.id, extractionCondition.name, this.namePrefix);
        XdtsExtractionConditionDAO.getInstance().putEntity(dtsSession, extractionCondition);
        this.getLogger().debug(XdtsUtil.createInfo(extractionCondition));
        rmoArg.getRespons().addData(extractionCondition);
    }

    public void deleteEntity(RmiRmoArgument rmoArg) throws Exception {
        Collection entityIdCollection = (Collection)rmoArg.getRequest().getData();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        XdtsExtractionCondition extractionCondition = new XdtsExtractionCondition();
        int cnt = 0;
        for (Integer entityId : entityIdCollection) {
            extractionCondition.id = entityId;
            cnt += XdtsExtractionConditionDAO.getInstance().deleteEntity(dtsSession, extractionCondition);
        }
        rmoArg.getRespons().addData(cnt);
    }

    public void getEntity(RmiRmoArgument rmoArg) throws Exception {
        int entityId = rmoArg.getRequest().getDataAsInteger();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        XdtsExtractionCondition extractionCondition = XdtsExtractionConditionDAO.getInstance().getById(dtsSession, entityId);
        rmoArg.getRespons().addData(extractionCondition);
    }

    public void getList(RmiRmoArgument rmoArg) throws Exception {
        int profileId = rmoArg.getRequest().getDataAsInteger();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        List extractionConditionList = XdtsExtractionConditionDAO.getInstance().getList(dtsSession, profileId);
        rmoArg.getRespons().addData(extractionConditionList);
    }

    public void copyExtractionCondition(RmiRmoArgument rmoArg) throws Exception {
        int profileId = rmoArg.getRequest().getDataAsInteger();
        Collection extractionConditionIdCollection = (Collection)rmoArg.getRequest().getData();
        String group = rmoArg.getRequest().getDataAsString();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        ArrayList<XdtsExtractionCondition> extractionConditionList = new ArrayList<XdtsExtractionCondition>();
        Iterator iterator = extractionConditionIdCollection.iterator();
        while (iterator.hasNext()) {
            int extractionConditionId = (Integer)iterator.next();
            XdtsExtractionCondition extractionCondition = XdtsExtractionConditionDAO.getInstance().getById(dtsSession, extractionConditionId);
            extractionCondition.profileId = profileId;
            extractionCondition.name = this.createName(dtsSession, extractionCondition.profileId, extractionCondition.id, extractionCondition.name, this.namePrefix);
            extractionCondition.id = -1;
            extractionCondition.group = group;
            XdtsExtractionConditionDAO.getInstance().putEntity(dtsSession, extractionCondition);
            extractionConditionList.add(extractionCondition);
        }
        rmoArg.getRespons().addData(extractionConditionList);
    }

    public String createName(DtsSession dtsSession, int profileId, int entityId, String origName, String namePrefix) throws Exception {
        XdtsExtractionCondition extractionCondition;
        if (BcStringUtil.isEmpty(origName)) {
            origName = String.valueOf(namePrefix) + entityId;
        }
        String newName = BcStringUtil.toStringNotNull(origName);
        String baseName = null;
        int tryCnt = 0;
        while ((extractionCondition = (XdtsExtractionCondition)XdtsExtractionConditionDAO.getInstance().getByName(dtsSession, profileId, newName)) != null && extractionCondition.id != entityId) {
            if (BcStringUtil.isEmpty(baseName) && BcStringUtil.isEmpty(baseName = EtcWordUtil.getBaseName(origName))) {
                baseName = origName;
            }
            newName = String.valueOf(baseName) + EtcEnumStrUtil.toElement(++tryCnt);
        }
        return newName;
    }

    public void createExtractionConditionBySql(RmiRmoArgument rmoArg) throws Exception {
        int profileId = rmoArg.getRequest().getDataAsInteger();
        String query = rmoArg.getRequest().getDataAsString();
        this.getLogger().debug("profileId=" + profileId + " query=" + query);
        DtsSession dtsSessionMain = rmoArg.getDtsSession(this);
        DtsSessionFactory dtsSessionFactoryWk1 = XdtsSessionFactoryManager.getInstance().getSessionFactory(dtsSessionMain, profileId);
        Throwable throwable = null;
        Object var7_9 = null;
        try (DtsSession dtsSessionWk1 = dtsSessionFactoryWk1.createSession(this);){
            BcResult result = XdtsServerUtil.getInstance().createExtractionConditionBySql_L2(dtsSessionWk1, query, BcLogUtil.getDefaultLogger());
            if (!result.hasError()) {
                XdtsExtractionCondition extractionCondition = (XdtsExtractionCondition)result.getUserObject();
                extractionCondition.profileId = profileId;
            }
            rmoArg.getRespons().addData(result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void createExtractionConditionByTable(RmiRmoArgument rmoArg) throws Exception {
        int profileId = rmoArg.getRequest().getDataAsInteger();
        String tableName = rmoArg.getRequest().getDataAsString();
        BcLogUtil.debug("profileId=" + profileId + " tableName=" + tableName);
        DtsSession dtsSessionMain = rmoArg.getDtsSession(this);
        BcResult result = XdtsServerUtil.getInstance().createExtractionConditionByTable(dtsSessionMain, profileId, tableName);
        rmoArg.getRespons().addData(result);
    }

    public static enum Method implements RmiRemoteMethod
    {
        putEntity,
        deleteEntity,
        getEntity,
        getList,
        copyExtractionCondition,
        createExtractionConditionBySql,
        createExtractionConditionByTable;


        @Override
        public String getMethodName() {
            return this.name();
        }
    }
}

