/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.dao;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.wbs1.common.Wbs1MailConstants;
import jp.co.extreme.module.wbs1.dao.Wbs1AnswerDAO;
import jp.co.extreme.module.wbs1.model.Wbs1Message;
import jp.co.extreme.module.wbs1.model.WbsJudgementCondition;
import jp.co.extreme.module.wbs1.model.WbsMessageCondition;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.sql.model.SqlWhereElement;

public class Wbs1MessageDAO
extends OrmAbstractDAO<Wbs1Message> {
    static Map<String, Wbs1MessageDAO> instanceMap = new HashMap<String, Wbs1MessageDAO>();

    private Wbs1MessageDAO() {
        super(new Wbs1Message[0]);
    }

    public static Wbs1MessageDAO getInstance(String tableName) {
        Wbs1MessageDAO instance = instanceMap.get(tableName);
        if (instance == null) {
            instance = new Wbs1MessageDAO();
            instance.setTableName(tableName);
            instanceMap.put(tableName, instance);
        }
        return instance;
    }

    public SqlSelectQuery createSelectQuery(SqlContext sqlContext, Mode mode, String alias, WbsMessageCondition messageCondition, WbsJudgementCondition judgementCondition) throws Exception {
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (messageCondition.messageId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "id =" + messageCondition.messageId);
            selectQuery.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(messageCondition.source)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "from_ " + sqlContext.toCondition("=", messageCondition.source));
            selectQuery.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(messageCondition.destination)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "to_ " + sqlContext.toCondition("=", messageCondition.destination));
            selectQuery.addWhereElement(whereElement);
        }
        if (messageCondition.messageStatus == Wbs1MailConstants.MessageStatus.Draft) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "fair_copy_datetime Is Null");
            selectQuery.addWhereElement(whereElement);
        } else if (messageCondition.messageStatus == Wbs1MailConstants.MessageStatus.Unsent) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "fair_copy_datetime Is Null");
            selectQuery.addWhereElement(whereElement);
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "send_end_datetime Is Null");
            selectQuery.addWhereElement(whereElement);
        } else if (messageCondition.messageStatus == Wbs1MailConstants.MessageStatus.NotOpened) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "send_end_datetime Is Not Null");
            selectQuery.addWhereElement(whereElement);
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "open_datetime Is Null");
            selectQuery.addWhereElement(whereElement);
        } else if (messageCondition.messageStatus == Wbs1MailConstants.MessageStatus.Opened) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "open_datetime Is Not Null");
            selectQuery.addWhereElement(whereElement);
        }
        Wbs1AnswerDAO.setJudgementCondition(selectQuery, aliasWk, judgementCondition);
        selectQuery.setFromClause(String.valueOf(this.getTableName()) + " AS " + alias);
        selectQuery.getOrderByList().add(String.valueOf(aliasWk) + mode.orderBy);
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        return selectQuery;
    }

    public <T> List<T> getList(DtsSession dtsSession, Mode mode, WbsMessageCondition messageCondition, WbsJudgementCondition judgementCondition) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "a";
        SqlSelectQuery selectQuery = this.createSelectQuery(sqlContext, mode, alias, messageCondition, judgementCondition);
        String query = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, query);
    }

    public <T> T getById(DtsSession dtsSession, long id) throws Exception {
        WbsMessageCondition messageCondition = new WbsMessageCondition();
        messageCondition.messageId = id;
        messageCondition.messageStatus = Wbs1MailConstants.MessageStatus.NULL;
        List<T> entityList = this.getList(dtsSession, Mode.id, messageCondition, null);
        return BcCollectionUtil.getFirst(entityList);
    }

    public static enum Mode {
        id("id"),
        from("from_"),
        to("to_");

        public final String orderBy;

        private Mode(String orderBy) {
            this.orderBy = orderBy;
        }
    }
}

