/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.tbcp.fx;

import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.layout.VBox;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.base.util.BcInputValidator;
import jp.co.extreme.base.util.BcMessageCreator;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.control.FxLabel;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.util.FxOptionPane;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.tbcp.common.TbcpCondition;
import jp.co.extreme.module.tbcp.common.TbcpUtil;
import jp.co.extreme.module.tbcp.common.TbcpWords;
import jp.co.extreme.module.tbcp.fx.TbcpConditionPane;
import jp.co.extreme.module.tbcp.fx.TbcpCsvComparatorTask2;
import jp.co.extreme.module.tbcp.fx.TbcpFilePane;
import jp.co.extreme.module.tbcp.fx.TbcpLogger;

public class TbcpInstructionPane
extends FxDecoratePane {
    VBox vBox = new VBox();
    String label1;
    String label2;
    TbcpFilePane filePane1;
    TbcpFilePane filePane2;
    TbcpConditionPane conditionPane;
    FxLabel logLabel;
    Button executeButton;
    Button closeButton;
    BcInputValidator inputValidator;
    TbcpLogger tbcpLogger;
    BcLogger logger1;

    public TbcpInstructionPane() throws Exception {
        this.label1 = String.valueOf(BcWords.getInstance().file) + "1";
        this.label2 = String.valueOf(BcWords.getInstance().file) + "2";
        this.filePane1 = new TbcpFilePane(this.label1);
        this.filePane2 = new TbcpFilePane(this.label2);
        this.conditionPane = new TbcpConditionPane();
        this.logLabel = new FxLabel();
        this.inputValidator = BcInputValidator.getInstance();
        this.initComponent();
        this.tbcpLogger = new TbcpLogger();
        this.tbcpLogger.textField = this.logLabel;
        this.logger1 = BcLogUtil.createLogger("csv-diffex-" + ((Object)((Object)this)).hashCode(), false, false);
        this.logger1.bind(this.tbcpLogger);
    }

    protected void initComponent() throws Exception {
        this.vBox.setSpacing(10.0);
        this.vBox.getChildren().add((Object)this.filePane1);
        this.vBox.getChildren().add((Object)this.filePane2);
        TbcpCondition condition = TbcpUtil.createCondition();
        this.conditionPane.setCondition(condition);
        this.vBox.getChildren().add((Object)this.conditionPane);
        this.vBox.getChildren().add((Object)this.logLabel);
        this.executeButton = FxUtil.createExecuteButton();
        this.addButton((ButtonBase)this.executeButton);
        this.closeButton = FxUtil.createCloseButton();
        this.addButton((ButtonBase)this.closeButton);
        this.setCenter((Node)this.vBox);
        this.underLineEnabled();
        FxUtil.defaultInitialize((Node)this);
    }

    protected BcResult validate(TbcpCondition condition) throws Exception {
        BcResult result = new BcResult();
        this.inputValidator.fileRequired(this.filePane1.filePathField.getText(), this.label1, result.getErrorList(), true);
        this.inputValidator.fileRequired(this.filePane2.filePathField.getText(), this.label2, result.getErrorList(), true);
        if (BcFileUtil.isSamePath(this.filePane1.filePathField.getText(), this.filePane2.filePathField.getText())) {
            result.addError(TbcpWords.getInstance().you_cannot_set_the_same_file);
        }
        String[] items = new String[]{TbcpWords.getInstance().excel_workbook, TbcpWords.getInstance().csv_file};
        boolean[] selects = new boolean[]{condition.workbook, condition.csv};
        this.inputValidator.select_$_or_more_$(items, selects, 1, result.getErrorList());
        return result;
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.executeButton) {
            this.executeButton.setDisable(true);
            TbcpCondition condition = this.conditionPane.getCondition();
            BcResult result = this.validate(condition);
            if (result.hasError()) {
                String msg = BcMessageCreator.getInstance().createMessage(result.getErrorList());
                FxOptionPane.showMessageDialog((Node)this, (Object)msg, BcWords.getInstance().warning, 2);
                this.executeButton.setDisable(false);
                return;
            }
            TbcpCsvComparatorTask2 csvComparatorTask = new TbcpCsvComparatorTask2();
            csvComparatorTask.file1 = new File(this.filePane1.filePathField.getText());
            csvComparatorTask.file2 = new File(this.filePane2.filePathField.getText());
            csvComparatorTask.condition = condition;
            csvComparatorTask.setLogger(this.logger1);
            csvComparatorTask.instructionPane = this;
            ExecutorService executorService = Executors.newCachedThreadPool();
            csvComparatorTask.future = executorService.submit(csvComparatorTask);
            executorService.shutdown();
        } else if (ev.getSource() == this.closeButton) {
            this.exitAction();
        }
    }

    protected void exitAction() throws Exception {
    }

    @Override
    protected void handleException(Throwable throwable) {
        this.logger1.info(throwable);
        super.handleException(throwable);
    }
}

