/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.advm.fx;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.net.ConnectException;
import java.net.URL;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.WritableImage;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Duration;
import jp.co.extreme.awt.AwtImageUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.FxPlatform;
import jp.co.extreme.fx.concurrent.FxTimerTask;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.stage.FxStage;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.fx.web.FxWebPane;
import jp.co.extreme.http.client.HtclContentLoader;
import jp.co.extreme.swing.SwgUtil;

public class AdvmWebViewPane {
    protected FxDecoratePane decoratePane = new InnerDecoratePane();
    protected FxButton closeButton;
    public FxWebPane webPane = new InnerWebPane();
    public String title;
    public String faviconUrl;
    public int periodSec = 0;
    protected Service service;
    public boolean isSuccess;
    public Stage stage;

    public AdvmWebViewPane() throws Exception {
        this.decoratePane.setCenter((Node)this.webPane);
        this.closeButton = this.decoratePane.createButton("");
        this.closeButton.setDisable(true);
    }

    public void close() {
        this.stage.close();
        this.stage = null;
    }

    protected void windowOpend() throws Exception {
    }

    protected void startTimer() {
        final InnerTimerTask timerTask = new InnerTimerTask();
        timerTask.setAccuracy(Duration.millis((double)200.0));
        Duration duration = Duration.millis((double)1000.0);
        timerTask.setDuration(duration);
        this.service = new Service(){

            protected Task createTask() {
                return timerTask;
            }
        };
        this.service.start();
    }

    protected void stopTimer() {
        this.service.cancel();
    }

    public void show(String title, Window ownerWindow, int width, int height) throws Exception {
        this.title = title;
        this.stage = new FxStage(StageStyle.DECORATED);
        if (ownerWindow != null) {
            this.stage.initModality(Modality.WINDOW_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                try {
                    AdvmWebViewPane.this.windowOpend();
                }
                catch (Exception ex) {
                    AdvmWebViewPane.this.handleException(ex);
                }
            }
        });
        this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent we) {
                System.out.println("Stage is closing");
            }
        });
        this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                if (AdvmWebViewPane.this.closeButton.isDisabled()) {
                    ev.consume();
                    AdvmWebViewPane.this.stage.show();
                } else {
                    AdvmWebViewPane.this.close();
                }
            }
        });
        FxScene scene = new FxScene((Parent)this.decoratePane);
        this.stage.setScene((Scene)scene);
        FxUtil.setWindowSize((Window)this.stage, width, height, true);
        this.stage.setResizable(true);
        this.stage.setTitle(title);
        if (!BcStringUtil.isEmpty(this.faviconUrl)) {
            try {
                HtclContentLoader contentLoader = new HtclContentLoader();
                ByteArrayOutputStream baos = contentLoader.getContent(new URL(this.faviconUrl));
                BufferedImage awtImage = AwtImageUtil.toImage(baos.toByteArray(), BcFileUtil.getExtention(this.faviconUrl));
                WritableImage image = SwingFXUtils.toFXImage((BufferedImage)AwtImageUtil.toBufferedImage(awtImage), null);
                this.stage.getIcons().add((Object)image);
            }
            catch (ConnectException ex) {
                BcLogUtil.error(ex);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        this.stage.show();
    }

    protected void handleException(Throwable throwable) {
        SwgUtil.getExceptionHandler().handleException(throwable, this);
    }

    class InnerDecoratePane
    extends FxDecoratePane {
        @Override
        protected void actionPerformed(ActionEvent ev) throws Exception {
            super.actionPerformed(ev);
            if (ev.getSource() == AdvmWebViewPane.this.closeButton) {
                AdvmWebViewPane.this.close();
            }
        }
    }

    class InnerTimerTask
    extends FxTimerTask {
        long preZan;

        InnerTimerTask() {
        }

        @Override
        public Void call2() {
            final long zan = (long)AdvmWebViewPane.this.periodSec - this.getElapsedTimeMillis() / 1000L;
            if (this.preZan != zan) {
                if (zan > 0L) {
                    FxPlatform.runLater(new Runnable(){

                        @Override
                        public void run() {
                            ((InnerTimerTask)InnerTimerTask.this).AdvmWebViewPane.this.closeButton.setText(String.valueOf(BcWords.getInstance().close) + "(" + zan + ")");
                        }
                    });
                } else {
                    FxPlatform.runLater(new Runnable(){

                        @Override
                        public void run() {
                            ((InnerTimerTask)InnerTimerTask.this).AdvmWebViewPane.this.closeButton.setText(BcWords.getInstance().close);
                            ((InnerTimerTask)InnerTimerTask.this).AdvmWebViewPane.this.closeButton.setDisable(false);
                        }
                    });
                    AdvmWebViewPane.this.stopTimer();
                }
            }
            this.preZan = zan;
            return null;
        }
    }

    class InnerWebPane
    extends FxWebPane {
        InnerWebPane() {
        }

        @Override
        protected void stateChanged(Worker.State oldValue, Worker.State newValue) throws Exception {
            super.stateChanged(oldValue, newValue);
            if (newValue.equals((Object)Worker.State.SUCCEEDED)) {
                if (AdvmWebViewPane.this.service == null) {
                    AdvmWebViewPane.this.isSuccess = true;
                    AdvmWebViewPane.this.startTimer();
                }
            } else {
                newValue.equals((Object)Worker.State.RUNNING);
            }
        }
    }
}

