/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.html.ruby;

import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.html.common.HtmlTextElement;
import jp.co.extreme.html.parser.HtmlParseEventHandler;
import jp.co.extreme.html.parser.HtmlParser;

public class HtmlRubyParser
extends BcLoggableObject
implements HtmlParseEventHandler {
    private HtmlParser htmlParser = new HtmlParser();
    private List<HtmlTextElement> textElementList;
    private HtmlTextElement textElement;
    private List<String> tagNestList = new ArrayList<String>();
    private String currentTagName;

    public HtmlRubyParser() {
        this.htmlParser.setParseEventHandler(this);
    }

    public List<HtmlTextElement> parseToList(String srcStr) throws Exception {
        this.textElementList = new ArrayList<HtmlTextElement>();
        this.htmlParser.parse(srcStr);
        return this.textElementList;
    }

    @Override
    public void handleStartTag(String tagName, int pos) {
        this.tagNestList.add(tagName);
        this.currentTagName = tagName;
        if (this.currentTagName.compareToIgnoreCase("ruby") == 0) {
            if (this.textElement != null) {
                this.textElementList.add(this.textElement);
            }
            this.textElement = new HtmlTextElement();
        } else if (this.currentTagName.compareToIgnoreCase("br") == 0) {
            if (this.textElement != null) {
                this.textElementList.add(this.textElement);
            }
            this.textElement = new HtmlTextElement();
            this.textElement.text = "\n";
            this.textElementList.add(this.textElement);
            this.textElement = null;
            this.currentTagName = null;
        }
    }

    @Override
    public void handleEndTag(String tagName, int pos) {
        this.tagNestList.remove(this.tagNestList.size() - 1);
        this.currentTagName = null;
    }

    @Override
    public void handleText(String str, int pos) {
        if (this.currentTagName == null) {
            if (this.textElement != null) {
                this.textElementList.add(this.textElement);
            }
            this.textElement = new HtmlTextElement();
            this.textElement.text = str;
        } else if (this.currentTagName.compareToIgnoreCase("rb") == 0) {
            this.textElement.text = str;
        } else if (this.currentTagName.compareToIgnoreCase("rt") == 0) {
            this.textElement.ruby = str;
        }
    }

    @Override
    public void attributeName(String attributeName, int pos) throws Exception {
    }

    @Override
    public void attributeValue(String attributeValue, int pos) throws Exception {
    }

    @Override
    public void parseEnd() {
        if (this.textElement != null) {
            this.textElementList.add(this.textElement);
        }
        this.textElement = null;
    }
}

