/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx.extension;

import javafx.event.ActionEvent;
import javafx.geometry.Dimension2D;
import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Region;
import jp.co.extreme.etc.model.EtcInputText;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.control.FxComboBox;
import jp.co.extreme.fx.control.FxTextField;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.layout.FxPane;
import jp.co.extreme.fx.util.FxFontUtil;
import jp.co.extreme.fx.util.FxUtil;

public class FxxComboBoxControl
extends FxPane
implements EtcInputText {
    private FxFlowPane flowPane = new FxFlowPane(21);
    public FxComboBox<String> comboBox = new FxComboBox();
    public FxTextField nameTextField = new InnerNameTextField();
    protected FxButton optionButton = new FxButton();

    public FxxComboBoxControl() throws Exception {
        this.nameTextField.setEditable(false);
        this.optionButton.setOnAction(this.actionEventHandler);
        this.optionButton.setText("i");
    }

    @Override
    public String getInputText() throws Exception {
        return (String)this.comboBox.getSelectionModel().getSelectedItem();
    }

    @Override
    public void setInputText(String value) throws Exception {
        this.comboBox.getSelectionModel().select((Object)value);
    }

    public void setValue(FxxComboBoxControl generalControl) throws Exception {
        this.comboBox.getSelectionModel().select((Object)((String)generalControl.comboBox.getSelectionModel().getSelectedItem()));
        this.nameTextField.setText(generalControl.nameTextField.getText());
    }

    public void setControlSize(int inputColumnCount, int nameColumnCount, boolean optionButtonEnabled) throws Exception {
        this.getChildren().clear();
        this.flowPane.removeAll();
        this.flowPane.topMargin = 0.0;
        this.flowPane.leftMargin = 0.0;
        this.flowPane.leftRightSpace = 0.0;
        this.comboBox.columnCount.set(inputColumnCount);
        int columnCountSum = inputColumnCount;
        if (nameColumnCount > 0) {
            this.nameTextField.setPrefColumnCount(nameColumnCount);
            columnCountSum += nameColumnCount;
        }
        ++columnCountSum;
        FxNodeUnit nodeUnit = new FxNodeUnit(null, new Node[]{this.comboBox});
        this.flowPane.addNodeUnit(nodeUnit);
        if (optionButtonEnabled) {
            nodeUnit = new FxNodeUnit(null, new Node[]{this.optionButton});
            this.flowPane.addNodeUnit(nodeUnit);
        }
        this.getChildren().add((Object)this.flowPane);
        Dimension2D dim2d = FxUtil.getTextFieldSize(FxFontUtil.getDefaultFont(), columnCountSum);
        FxUtil.setPrefSize((Region)this, dim2d);
    }

    public void setControlSize(int textColumnCount, int nameColumnCount) throws Exception {
        this.setControlSize(textColumnCount, nameColumnCount, false);
    }

    protected void imputTextChanged(String text) throws Exception {
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.optionButton) {
            this.optionButtonAction();
        }
    }

    public void optionButtonAction() throws Exception {
    }

    class InnerInputTextField
    extends FxTextField {
        @Override
        protected void keyEvent(KeyEvent ev) throws Exception {
            super.keyEvent(ev);
            ev.getEventType();
        }

        @Override
        protected void textEdited() throws Exception {
            super.textEdited();
            FxxComboBoxControl.this.imputTextChanged(this.getText());
        }
    }

    class InnerNameTextField
    extends FxTextField {
        public InnerNameTextField() throws Exception {
            this.setFocusTraversable(false);
        }

        @Override
        public void focusIn() throws Exception {
            super.focusIn();
        }
    }
}

