/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.log;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.co.extreme.base.log.BcLogConstants;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.base.log.BcLoggerFactoryJul;

public class BcLoggerJul
implements BcLogger {
    private Logger julLogger;
    private BcLogger bindLogger;

    @Override
    public String getName() {
        return this.julLogger.getName();
    }

    @Override
    public void setLogLevel(BcLogConstants.LogLevel logLevel) {
        Handler[] handlers;
        Level jLogLevel = BcLoggerFactoryJul.toJulLevel(logLevel);
        this.julLogger.setLevel(jLogLevel);
        Handler[] handlerArray = handlers = this.julLogger.getHandlers();
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            handler.setLevel(jLogLevel);
            ++n2;
        }
    }

    @Override
    public BcLogConstants.LogLevel getLogLevel() {
        return BcLoggerFactoryJul.toLogLevel(this.julLogger.getLevel());
    }

    @Override
    public void fatal(Object log) {
        String str = BcLogUtil.convertMessage(log);
        this.julLogger.severe(str);
        if (this.bindLogger != null) {
            this.bindLogger.fatal(str);
        }
    }

    @Override
    public void error(Object log) {
        String str = BcLogUtil.convertMessage(log);
        this.julLogger.severe(str);
        if (this.bindLogger != null) {
            this.bindLogger.error(str);
        }
    }

    @Override
    public void warning(Object log) {
        String str = BcLogUtil.convertMessage(log);
        this.julLogger.warning(str);
        if (this.bindLogger != null) {
            this.bindLogger.warning(str);
        }
    }

    @Override
    public void info(Object log) {
        String str = BcLogUtil.convertMessage(log);
        this.julLogger.info(str);
        if (this.bindLogger != null) {
            this.bindLogger.info(str);
        }
    }

    @Override
    public void debug(Object log) {
        String str = BcLogUtil.convertMessage(log);
        this.julLogger.config(str);
        if (this.bindLogger != null) {
            this.bindLogger.debug(str);
        }
    }

    @Override
    public void trace(Object log) {
        String str = BcLogUtil.convertMessage(log);
        this.julLogger.fine(str);
        if (this.bindLogger != null) {
            this.bindLogger.trace(str);
        }
    }

    @Override
    public void bind(BcLogger bindLogger) {
        this.bindLogger = bindLogger;
    }

    public Logger getjulLogger() {
        return this.julLogger;
    }

    public void setjulLogger(Logger julLogger) {
        this.julLogger = julLogger;
    }
}

