/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.io.BcStreamTransmitter;
import jp.co.extreme.base.log.BcLogUtil;

public class BcFileMerger {
    public List<File> inputFileList = new ArrayList<File>();

    public void doMerge(File destFile) throws Exception {
        boolean isSuccess = destFile.createNewFile();
        if (!isSuccess) {
            throw new Exception(String.valueOf(destFile.getPath()) + " is allready exists.");
        }
        try (FileOutputStream os = new FileOutputStream(destFile);){
            this.doMerge_L2(os);
        }
    }

    public void doMerge_L2(OutputStream os) throws Exception {
        int i = 0;
        while (i < this.inputFileList.size()) {
            File inputFile = this.inputFileList.get(i);
            BcLogUtil.debug("inputFile(" + (i + 1) + "/" + this.inputFileList.size() + ")=" + inputFile.getPath());
            try (FileInputStream is = new FileInputStream(inputFile);){
                this.doMerge_L3(is, os);
            }
            ++i;
        }
    }

    protected void doMerge_L3(InputStream is, OutputStream os) throws Exception {
        BcStreamTransmitter streamTransmitter = new BcStreamTransmitter();
        long transmitCount = streamTransmitter.transmit(is, os);
        BcLogUtil.debug("transmitCount=" + transmitCount);
    }
}

