/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jp.co.extreme.base.event.BcEvent;
import jp.co.extreme.base.event.BcEventHandler;
import jp.co.extreme.base.log.BcLoggableObject;

public class BcEventHandlerList
extends BcLoggableObject {
    private List<BcEventHandler> list = Collections.synchronizedList(new ArrayList());

    public boolean addEventHandler(BcEventHandler eventHandler) throws Exception {
        return this.list.add(eventHandler);
    }

    public boolean removeEventHandler(BcEventHandler eventHandler) throws Exception {
        this.getLogger().debug("removeEventHandler:eventHandler" + eventHandler);
        return this.list.remove(eventHandler);
    }

    public void fireEvent(BcEvent event) throws Exception {
        this.getLogger().debug("fireEvent:event=" + event);
        BcEventHandler[] eventHandlers = this.list.toArray(new BcEventHandler[this.list.size()]);
        this.getLogger().debug("eventHandlers.length=" + eventHandlers.length);
        int i = 0;
        while (i < eventHandlers.length) {
            try {
                BcEventHandler eventHandler = eventHandlers[i];
                eventHandler.handle(event);
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
            }
            ++i;
        }
    }
}

