/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.app.common;

import java.util.Properties;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.app.common.AfbApplicationContext;
import jp.co.extreme.base.core.BcConstants;
import jp.co.extreme.base.core.BcJavaConstants;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.runtime.BcRuntimeUtil;

public final class AfbLogUtil {
    private AfbLogUtil() {
    }

    public static String jvmInfo(Properties properties) {
        StringBuilder sb = new StringBuilder();
        sb.append(BcRuntimeUtil.lineSeparator);
        sb.append(" java version : " + properties.getProperty(BcJavaConstants.SysKey.java_version.value, "") + BcRuntimeUtil.lineSeparator);
        sb.append("    java home : " + properties.getProperty(BcJavaConstants.SysKey.java_home.value, "") + BcRuntimeUtil.lineSeparator);
        sb.append("      os name : " + properties.getProperty(BcJavaConstants.SysKey.os_name.value, "") + BcRuntimeUtil.lineSeparator);
        sb.append("   os version : " + properties.getProperty(BcJavaConstants.SysKey.os_version.value, "") + BcRuntimeUtil.lineSeparator);
        sb.append("   process id : " + BcRuntimeUtil.getProcessId() + BcRuntimeUtil.lineSeparator);
        sb.append("    user name : " + properties.getProperty(BcJavaConstants.SysKey.user_name.value, "") + BcRuntimeUtil.lineSeparator);
        sb.append("     user dir : " + properties.getProperty(BcJavaConstants.SysKey.user_dir.value, "") + BcRuntimeUtil.lineSeparator);
        sb.append("    java arch : " + properties.getProperty(BcJavaConstants.SysKey.sun_arch_data_model.value, "") + BcRuntimeUtil.lineSeparator);
        return sb.toString();
    }

    public static String jvmInfo() {
        return AfbLogUtil.jvmInfo(System.getProperties());
    }

    public static String frameworkInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append(BcRuntimeUtil.lineSeparator);
        sb.append(String.valueOf(BcStringUtil.fill("*", 78)) + BcRuntimeUtil.lineSeparator);
        sb.append("  Talisker Ver.1.02" + BcRuntimeUtil.lineSeparator);
        sb.append("  " + BcConstants.LIB_NAME + " Ver." + BcConstants.LIB_VERSION_CODE + BcRuntimeUtil.lineSeparator);
        sb.append("  Copyright(c) 2025 Extreme Co.,Ltd. All rights reserved." + BcRuntimeUtil.lineSeparator);
        sb.append(String.valueOf(BcStringUtil.fill("*", 78)) + BcRuntimeUtil.lineSeparator);
        return sb.toString();
    }

    public static String applicationInfo(AfbApplication application) {
        AfbApplicationContext appContext = application.getApplicationContext();
        StringBuilder sb = new StringBuilder();
        sb.append(BcRuntimeUtil.lineSeparator);
        sb.append(String.valueOf(BcStringUtil.fill('=', 60)) + BcRuntimeUtil.lineSeparator);
        sb.append("");
        sb.append(" application name : " + appContext.appName + BcRuntimeUtil.lineSeparator);
        sb.append("          version : " + appContext.version + BcRuntimeUtil.lineSeparator);
        sb.append("            build : " + appContext.buildInfo + BcRuntimeUtil.lineSeparator);
        sb.append("");
        sb.append("      vendor name : " + appContext.vendorName + BcRuntimeUtil.lineSeparator);
        sb.append("       vendor URL : " + appContext.vendorUrl + BcRuntimeUtil.lineSeparator);
        sb.append("  " + appContext.vendorCopyright + BcRuntimeUtil.lineSeparator);
        sb.append(String.valueOf(BcStringUtil.fill('=', 60)) + BcRuntimeUtil.lineSeparator);
        return sb.toString();
    }

    public static String appNameAndVersion(AfbApplicationContext appContext) {
        StringBuilder sb = new StringBuilder();
        if (!BcStringUtil.isEmpty(appContext.appName)) {
            sb.append(appContext.appName);
        }
        if (!BcStringUtil.isEmpty(appContext.version)) {
            if (!BcStringUtil.isEmpty(sb)) {
                sb.append(" ");
            }
            sb.append("Ver.");
            sb.append(appContext.version);
        }
        return sb.toString();
    }
}

