/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.sql;

import java.io.Reader;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLoggableObject;

public class SqlStatementVisitor
extends BcLoggableObject {
    static final int CTL_init = -1;
    static final int CTL_statement = 1;
    static final int CTL_comment1 = 2;
    static final int CTL_comment2 = 3;
    private final char sentenceSeparator = (char)59;

    public void parse(Reader reader) throws Exception {
        String comment;
        int readInt;
        int control = -1;
        int row = 1;
        char preChar = '\u0000';
        StringBuilder statementBuf = new StringBuilder();
        StringBuilder commentBuf = new StringBuilder();
        while ((readInt = reader.read()) >= 0) {
            char aChar = (char)readInt;
            boolean isLineSP = false;
            switch (aChar) {
                case '\n': {
                    isLineSP = true;
                    break;
                }
                case '\r': {
                    isLineSP = true;
                }
            }
            if (isLineSP) {
                ++row;
            }
            block4 : switch (control) {
                case -1: {
                    switch (aChar) {
                        case '-': {
                            if (preChar != '-') break block4;
                            control = 2;
                            break block4;
                        }
                        case '*': {
                            if (preChar != '/') break block4;
                            control = 3;
                            break block4;
                        }
                    }
                    if (isLineSP) break;
                    statementBuf.append(aChar);
                    control = 1;
                    break;
                }
                case 1: {
                    switch (aChar) {
                        case ';': {
                            this.visitStatement(statementBuf.toString());
                            BcStringUtil.clear(statementBuf);
                            control = -1;
                            break block4;
                        }
                    }
                    statementBuf.append(aChar);
                    break;
                }
                case 2: {
                    if (isLineSP) {
                        this.visitComment(commentBuf.toString());
                        BcStringUtil.clear(commentBuf);
                        control = -1;
                        break;
                    }
                    commentBuf.append(aChar);
                    break;
                }
                case 3: {
                    switch (aChar) {
                        case '/': {
                            if (preChar == '*') {
                                commentBuf.delete(commentBuf.length() - 1, commentBuf.length());
                                this.visitComment(commentBuf.toString());
                                BcStringUtil.clear(commentBuf);
                                control = -1;
                                break block4;
                            }
                            commentBuf.append(aChar);
                            break block4;
                        }
                    }
                    commentBuf.append(aChar);
                }
            }
            preChar = aChar;
        }
        String statement = statementBuf.toString();
        if (!BcStringUtil.isEmpty(statement)) {
            this.visitStatement(statement);
        }
        if (!BcStringUtil.isEmpty(comment = commentBuf.toString())) {
            this.visitComment(comment);
        }
    }

    protected void visitStatement(String statement) throws Exception {
        this.getLogger().info("statement=" + statement);
    }

    protected void visitComment(String comment) throws Exception {
        this.getLogger().info("comment=" + comment);
    }
}

