/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.swg;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javafx.scene.Node;
import javafx.scene.Parent;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import jp.co.extreme.awt.AwtImageHelper;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.FxPlatform;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xdts.common.XdtsUtil;
import jp.co.extreme.module.xdts.common.XdtsWords;
import jp.co.extreme.module.xdts.fx.XdtsConditionBasePane;
import jp.co.extreme.module.xdts.fx.XdtsFxLauncher;
import jp.co.extreme.module.xdts.fx.XdtsSqlEditPane;
import jp.co.extreme.module.xdts.model.XdtsCustomSql;
import jp.co.extreme.module.xdts.model.XdtsProcessCondition;
import jp.co.extreme.module.xdts.model.v0001.XdtsExtractionCondition;
import jp.co.extreme.module.xdts.rmo.XdtsDataViewRMO;
import jp.co.extreme.module.xdts.stub.XdtsExtractionConditionStub;
import jp.co.extreme.module.xdts.swg.XdtsAbstractDataViewPanel;
import jp.co.extreme.rmi.model.RmiRequest;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.context.SqlContextFactory;
import jp.co.extreme.swing.SwgButton;
import jp.co.extreme.swing.SwgOptionPane;
import jp.co.extreme.swing.SwgUtil;

public class XdtsDataViewPanel_Sql
extends XdtsAbstractDataViewPanel {
    private static final long serialVersionUID = 4460877028057492016L;
    XdtsSqlEditPane sqlEditPanel1;
    protected SwgButton saveButton;
    protected SwgButton saveAsNewButton;
    protected SwgButton createConditionButton;
    private XdtsCustomSql customSql;

    public XdtsDataViewPanel_Sql() throws Exception {
        this.saveButton = new SwgButton(XdtsWords.getInstance().saveSql);
        this.saveAsNewButton = new SwgButton(XdtsWords.getInstance().saveAsNewSql);
        this.createConditionButton = new SwgButton(XdtsWords.getInstance().createExtractionConditions);
    }

    @Override
    protected Parent createConditionNode(int tabIndex, Node preConditionNode) throws Exception {
        XdtsConditionBasePane conditionBasePane1 = new XdtsConditionBasePane();
        this.sqlEditPanel1 = new XdtsSqlEditPane();
        if (preConditionNode == null) {
            if (this.customSql == null) {
                this.customSql = new XdtsCustomSql();
            }
            this.sqlEditPanel1.setSql(this.customSql.sql);
        } else {
            XdtsConditionBasePane conditionBasePane2 = (XdtsConditionBasePane)preConditionNode;
            XdtsSqlEditPane sqlEditPanel2 = (XdtsSqlEditPane)conditionBasePane2.getCenter();
            this.sqlEditPanel1.setSql(sqlEditPanel2.getSql());
        }
        this.setTitle(this.customSql.name);
        conditionBasePane1.setCenter((Node)this.sqlEditPanel1);
        FxUtil.defaultInitialize((Node)conditionBasePane1);
        return conditionBasePane1;
    }

    @Override
    protected void optionControlSetup(JPanel conditionControlPanel) throws Exception {
        super.optionControlSetup(conditionControlPanel);
        this.saveButton.addActionListener(this.actionListener);
        this.saveButton.setIcon(new ImageIcon(AwtImageHelper.getImageAsIcon("floppy_disk_64x64.png")));
        conditionControlPanel.add(this.saveButton);
        if (this.customSql.getDataId() > 0) {
            this.saveAsNewButton.addActionListener(this.actionListener);
            this.saveAsNewButton.setIcon(new ImageIcon(AwtImageHelper.getImageAsIcon("floppy_disk_64x64.png")));
            conditionControlPanel.add(this.saveAsNewButton);
        }
        this.createConditionButton.addActionListener(this.actionListener);
        this.createConditionButton.setIcon(new ImageIcon(AwtImageHelper.getImageAsIcon("form_64x64.png")));
        conditionControlPanel.add(this.createConditionButton);
    }

    @Override
    protected BcResult validateCondition() throws Exception {
        BcResult result = XdtsUtil.validateSql(this.sqlEditPanel1.getSql(), true);
        return result;
    }

    @Override
    protected RmiRequest createRequest() throws Exception {
        XdtsProcessCondition processCondition = new XdtsProcessCondition();
        processCondition.profileId = this.getProfile().getDataId();
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(XdtsDataViewRMO.class.getName());
        rmiReq.setMethodName(XdtsDataViewRMO.Method.dataView.name());
        rmiReq.addData(processCondition);
        rmiReq.addData(this.sqlEditPanel1.getSql());
        return rmiReq;
    }

    @Override
    protected void actionPerformed2(ActionEvent ev) throws Exception {
        super.actionPerformed2(ev);
        if (ev.getSource() == this.saveButton) {
            this.customSql.profileId = this.getProfile().getDataId();
            this.customSql.sql = this.sqlEditPanel1.getSql();
            XdtsFxLauncher.customSqlPane(this.customSql, null);
        } else if (ev.getSource() == this.saveAsNewButton) {
            XdtsCustomSql customSql2 = (XdtsCustomSql)this.customSql.clone();
            customSql2.setObjectId(-1L);
            customSql2.setDataId(-1);
            customSql2.name = "Copy of '" + this.customSql.name + "'.";
            customSql2.sql = this.sqlEditPanel1.getSql();
            XdtsFxLauncher.customSqlPane(customSql2, null);
        } else if (ev.getSource() == this.createConditionButton) {
            SqlContext sqlContext = SqlContextFactory.getSqlContext(this.getProfile().productId);
            BcResult result = XdtsExtractionConditionStub.getInstance().createExtractionConditionBySql(this.getProfile().getDataId(), this.sqlEditPanel1.getSql());
            if (result.hasError()) {
                Component msgComponent = SwgUtil.createMessageComponent(null, result.getErrorList());
                SwgOptionPane.showMessageDialog(this, msgComponent, BcWords.getInstance().error, 0);
                return;
            }
            XdtsExtractionCondition extractionCondition = (XdtsExtractionCondition)result.getUserObject();
            XdtsFxLauncher.extractionCondition(sqlContext, extractionCondition);
        }
    }

    @Override
    protected void windowOpened(WindowEvent ev) throws Exception {
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                XdtsDataViewPanel_Sql.this.sqlEditPanel1.sqlTextArea.requestFocus();
            }
        });
    }

    @Override
    protected String getConditionTitle() throws Exception {
        return BcWords.getInstance().extractionCondition + "(SQL)";
    }

    @Override
    protected Image getIconImage() throws Exception {
        return AwtImageHelper.getImage("sql_48x48.png");
    }

    public XdtsCustomSql getCustomSql() throws Exception {
        return this.customSql;
    }

    public void setCustomSql(XdtsCustomSql customSql) throws Exception {
        this.customSql = customSql;
        this.setTitle(customSql.name);
    }

    class InnerConditionPane
    extends FxFlowPane {
        XdtsSqlEditPane sqlEditPanel;

        public InnerConditionPane() throws Exception {
            super(11);
            this.sqlEditPanel = new XdtsSqlEditPane();
        }
    }
}

