/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx.table;

import java.math.BigDecimal;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.SwingNode;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.TableCell;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.mmd.MmdDefaultRenderingConverter;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.mmd.MmdRenderingConverter;
import jp.co.extreme.base.mmd.MmdUtil;
import jp.co.extreme.base.table.BcCellAttribute;
import jp.co.extreme.fx.control.FxCheckBox;
import jp.co.extreme.fx.control.FxNumberField;
import jp.co.extreme.fx.control.FxTextField;
import jp.co.extreme.fx.table.FxTableColumn;
import jp.co.extreme.fx.table.FxTableUtil;
import jp.co.extreme.fx.util.FxUtil;

public class FxTableCell<S, T>
extends TableCell<S, T> {
    private FxTableColumn tableColumn;
    private Label label;
    private FxTextField textField;
    private FxNumberField numberField;
    private FxCheckBox checkBox;
    private SwingNode swingNode;
    private boolean isSettinng;

    public FxTableCell(FxTableColumn tableColumn) throws Exception {
        this.tableColumn = tableColumn;
        this.setEditable(tableColumn.isEditable());
    }

    public void updateItem(T cellValue, boolean empty) {
        super.updateItem(cellValue, empty);
        Node graphicNode = null;
        if (!empty) {
            graphicNode = this.getGraphicNode(false, cellValue);
        }
        this.setGraphic(graphicNode);
    }

    public void startEdit() {
        super.startEdit();
        Node graphicNode = this.getGraphicNode(true, this.getItem());
        this.setGraphic(graphicNode);
        graphicNode.requestFocus();
    }

    public void commitEdit(T newValue) {
        super.commitEdit(newValue);
        FxTableUtil.setCellValue(this.getTableView(), this.getIndex(), this.tableColumn.index, newValue);
    }

    public void cancelEdit() {
        super.cancelEdit();
        Node graphicNode = this.getGraphicNode(false, this.getItem());
        this.setGraphic(graphicNode);
    }

    protected Node getGraphicNode(boolean isEdit, T cellValue) {
        this.isSettinng = true;
        Node node = null;
        try {
            node = this.getGraphicNode_L2(isEdit, cellValue);
        }
        catch (Exception ex) {
            this.getLabel().setText(ex.getMessage());
            node = this.getLabel();
        }
        this.isSettinng = false;
        return node;
    }

    protected Node getGraphicNode_L2(boolean isEdit, T cellValue1) throws Exception {
        MmdField mmdField = this.tableColumn.mmdField;
        if (mmdField == null) {
            mmdField = new MmdField();
        }
        Object cellValue2 = null;
        Class<?> valueClass = null;
        MmdRenderingConverter renderingConverter = MmdDefaultRenderingConverter.getInstance();
        if (cellValue1 == null) {
            valueClass = mmdField.dataClass;
        } else {
            cellValue2 = cellValue1;
            if (mmdField.fieldDisplay.renderingConverter != null) {
                renderingConverter = mmdField.fieldDisplay.renderingConverter;
            }
            cellValue2 = renderingConverter.convertValue(mmdField, cellValue1);
            valueClass = cellValue2.getClass();
        }
        HPos hPos = FxUtil.toHPos(MmdUtil.getHorizonalAlignment(mmdField));
        Pos pos = FxUtil.toPos(hPos, VPos.CENTER);
        this.setAlignment(pos);
        BcCellAttribute cellAttribute = FxTableUtil.getCellAttribute(this);
        Node graphicNode = null;
        if (valueClass != null) {
            graphicNode = FxTableUtil.getCellNode_Number(mmdField, valueClass, cellValue2, isEdit, renderingConverter, (Labeled)this.getLabel(), this.getNumberField(), cellAttribute);
            if (graphicNode != null) {
                this.tempProc(cellValue2, graphicNode, mmdField, isEdit);
                return graphicNode;
            }
            graphicNode = FxTableUtil.getCellNode_Calendar(mmdField, valueClass, cellValue2, isEdit, (Labeled)this.getLabel(), cellAttribute);
            if (graphicNode != null) {
                this.tempProc(cellValue2, graphicNode, mmdField, isEdit);
                return graphicNode;
            }
            graphicNode = FxTableUtil.getCellNode_Boolean(mmdField, valueClass, cellValue2, isEdit, this.getCheckBox(), (Labeled)this.getLabel(), cellAttribute);
            if (graphicNode != null) {
                this.tempProc(cellValue2, graphicNode, mmdField, isEdit);
                return graphicNode;
            }
            graphicNode = FxTableUtil.getCellNode_jComponent(mmdField, valueClass, cellValue2, isEdit, this.getSwingNode());
            if (graphicNode != null) {
                this.tempProc(cellValue2, graphicNode, mmdField, isEdit);
                return graphicNode;
            }
        }
        graphicNode = FxTableUtil.getCellNode_text(mmdField, cellValue2, isEdit, (Labeled)this.getLabel(), (TextInputControl)this.getTextField(), cellAttribute);
        this.tempProc(cellValue2, graphicNode, mmdField, isEdit);
        return graphicNode;
    }

    protected void tempProc(Object cellValue, Node graphicNode, MmdField mmdField, boolean isEdit) throws Exception {
    }

    protected Label getLabel() {
        if (this.label != null) {
            return this.label;
        }
        this.label = new InnerLabel();
        return this.label;
    }

    protected TextField getTextField() {
        if (this.textField != null) {
            return this.textField;
        }
        this.textField = this.createTextField();
        return this.textField;
    }

    protected FxTextField createTextField() {
        return new InnerTextField();
    }

    protected FxNumberField getNumberField() {
        if (this.numberField != null) {
            return this.numberField;
        }
        this.numberField = this.createNumberField();
        return this.numberField;
    }

    protected FxNumberField createNumberField() {
        return new InnerNumberField();
    }

    protected CheckBox getCheckBox() {
        if (this.checkBox != null) {
            return this.checkBox;
        }
        this.checkBox = new FxCheckBox();
        this.checkBox.selectedProperty().addListener((ov, oldValue, newValue) -> {
            if (!this.isSettinng) {
                this.commitEdit(newValue);
            }
        });
        this.checkBox.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    Boolean bool = FxTableCell.this.checkBox.isSelected();
                    FxTableCell.this.commitEdit(bool);
                }
            }
        });
        return this.checkBox;
    }

    protected SwingNode getSwingNode() {
        if (this.swingNode != null) {
            return this.swingNode;
        }
        this.swingNode = new SwingNode();
        return this.swingNode;
    }

    class InnerLabel
    extends Label {
    }

    public class InnerNumberField
    extends FxNumberField {
        @Override
        protected void focusOut() throws Exception {
            super.focusOut();
            BigDecimal bigDecimal = this.getBigDecimal();
            if (bigDecimal != null) {
                BcLogUtil.debug("bigDecimal=" + bigDecimal);
                if (((FxTableCell)FxTableCell.this).tableColumn.mmdField != null) {
                    Number number = BcNumberUtil.toNumber(bigDecimal, ((FxTableCell)FxTableCell.this).tableColumn.mmdField.dataClass);
                    FxTableCell.this.commitEdit(number);
                } else {
                    FxTableCell.this.commitEdit(bigDecimal.toString());
                }
            } else {
                FxTableCell.this.commitEdit(null);
            }
        }
    }

    public class InnerTextField
    extends FxTextField {
        @Override
        protected void focusOut() throws Exception {
            super.focusOut();
            FxTableCell.this.commitEdit(this.getText());
        }
    }
}

