/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;

public final class BcMath {
    public static final int MANTISSA_INTEGER_DIGITS_DEFAULT = 1;
    public static final int MANTISSA_DECIMAL_DIGITS_DEFAULT = 2;
    public static final int EXPONENT_DIGITS_DEFAULT = 2;

    private BcMath() {
    }

    public static boolean isEven(long value) {
        return (value & 1L) == 0L;
    }

    public static short max(Short ... values) {
        return Collections.max(Arrays.asList(values));
    }

    public static int max(Integer ... values) {
        return Collections.max(Arrays.asList(values));
    }

    public static long max(Long ... values) {
        return Collections.max(Arrays.asList(values));
    }

    public static float max(Float ... values) {
        return Collections.max(Arrays.asList(values)).floatValue();
    }

    public static double max(Double ... values) {
        return Collections.max(Arrays.asList(values));
    }

    public static int integerRound(int intVal, int roundScale, int roundMode) throws Exception {
        int resValue = 0;
        int baesVal = 0;
        String valStr = Integer.toString(intVal);
        if (valStr.length() >= roundScale) {
            baesVal = Integer.parseInt(String.valueOf(valStr.substring(0, valStr.length() - roundScale)) + BcStringUtil.fill("0", roundScale));
        } else {
            valStr = BcStringUtil.fillPrefix(valStr, roundScale, '0');
        }
        switch (roundMode) {
            case 0: {
                resValue = baesVal + (int)Math.pow(10.0, roundScale);
                break;
            }
            case 1: {
                resValue = baesVal;
                break;
            }
            case 4: {
                int tergetNum = Integer.parseInt(valStr.substring(valStr.length() - roundScale, valStr.length() - roundScale + 1));
                resValue = tergetNum >= 5 ? baesVal + (int)Math.pow(10.0, roundScale) : baesVal;
            }
        }
        return resValue;
    }

    public static double longToDouble(long srcVal, int decimalPoint) throws Exception {
        BigDecimal bd = new BigDecimal(srcVal);
        bd = bd.movePointLeft(decimalPoint);
        return bd.doubleValue();
    }

    public static int summary(int[] intArray) {
        int sum = 0;
        int i = 0;
        while (i < intArray.length) {
            sum += intArray[i];
            ++i;
        }
        return sum;
    }

    public static Object[] calcShiftForExponent(BigDecimal bigDec, int mantissaIntegerDigits, int mantissaDecimalDigits) throws Exception {
        BigInteger unscaledValue = bigDec.unscaledValue();
        int signum = unscaledValue.signum();
        unscaledValue = unscaledValue.abs();
        int digitSize = unscaledValue.toString().length();
        BigDecimal bigDec2 = new BigDecimal(unscaledValue);
        int tScale = mantissaIntegerDigits + mantissaDecimalDigits - digitSize;
        unscaledValue = (bigDec2 = bigDec2.setScale(tScale, 4)).toBigInteger();
        int shit = (digitSize = unscaledValue.toString().length()) - mantissaIntegerDigits;
        if (shit != 0) {
            bigDec2 = bigDec2.movePointLeft(shit);
            bigDec2 = bigDec2.setScale(mantissaDecimalDigits, 1);
        }
        if (signum < 0) {
            bigDec2 = bigDec2.negate();
        }
        Object[] res = new Object[]{bigDec2, shit};
        return res;
    }

    public static String toExponentialNotation(BigDecimal mantissa, int exponent, int exponentSize) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(mantissa.toPlainString());
        sb.append('E');
        sb.append(BcNumberUtil.getSignSymbol(exponent, false));
        sb.append(BcStringUtil.fillPrefix(String.valueOf(Math.abs(exponent)), exponentSize, '0'));
        return sb.toString();
    }

    public static String reformExponentialNotation(String str1) throws Exception {
        int expPos = str1.indexOf(69);
        String mantissa = str1.substring(0, expPos);
        String exponent = str1.substring(expPos + 1);
        return BcMath.toExponentialNotation(new BigDecimal(mantissa), Integer.parseInt(exponent), 2);
    }

    public static String scientificNotation(BigDecimal value, int mantissaIntegerDigits, int mantissaDecimalDigits, int exponentDigits) throws Exception {
        Object[] res = BcMath.calcShiftForExponent(value, mantissaIntegerDigits, mantissaDecimalDigits);
        BigDecimal bigDec2 = (BigDecimal)res[0];
        int shit = (Integer)res[1];
        int exponent = shit - value.scale();
        String str = BcMath.toExponentialNotation(bigDec2, exponent, exponentDigits);
        return str;
    }

    public static String scientificNotation(BigDecimal value) throws Exception {
        return BcMath.scientificNotation(value, 1, 2, 2);
    }
}

