/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsys.client;

import java.io.File;
import java.nio.charset.Charset;
import javafx.application.Platform;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.app.common.AfbConstants;
import jp.co.extreme.app.common.AfbLogUtil;
import jp.co.extreme.base.core.BcBooleanUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.reflect.BcReflectUtil;
import jp.co.extreme.base.runtime.BcRuntimeUtil;
import jp.co.extreme.base.thread.BcMonitor;
import jp.co.extreme.base.util.BcArgumentUtil;
import jp.co.extreme.base.util.BcEncoder;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.FxPlatform;
import jp.co.extreme.fx.util.FxOptionPane;
import jp.co.extreme.module.advm.client.AdvmAdvertisementManager;
import jp.co.extreme.module.advm.client.AdvmAdvertisementTask;
import jp.co.extreme.module.tbcp.common.TbcpCondition;
import jp.co.extreme.module.tbcp.common.TbcpCsvComparator;
import jp.co.extreme.module.tbcp.common.TbcpUtil;
import jp.co.extreme.module.tbcp.fx.TbcpDesktopPane;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xsys.common.XsysConstants;
import jp.co.extreme.module.xsys.fx.XsysDesktopPane;
import jp.co.extreme.module.xsys.fx.XsysLicensePane;
import jp.co.extreme.module.xupd.client.XupdChacker;
import jp.co.extreme.scf.client.ScfAbstractClientModule;
import jp.co.extreme.scf.common.ScfConstants;
import jp.co.extreme.scf5.swg.IswgTablePanel;
import jp.co.extreme.swing.SwgUtil;

public class XsysClientModule
extends ScfAbstractClientModule {
    public BcMonitor monitor = new BcMonitor();
    boolean licenseAgreement;

    @Override
    public void init() throws Exception {
        String javaVersion = BcRuntimeUtil.getJavaVersion();
        boolean doExit = false;
        final BcMonitor monitor = new BcMonitor();
        if (!BcRuntimeUtil.isJava_1_8()) {
            doExit = true;
            monitor.lock();
            final String msg = String.format("\u672c\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u306f Java %s \u3067\u306f\u7a3c\u52d5\u3057\u307e\u305b\u3093\u3002", javaVersion);
            FxPlatform.runLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        FxOptionPane.showMessageDialog(msg, BcWords.getInstance().error, 0);
                        monitor.unLock();
                    }
                    catch (Exception ex) {
                        BcLogUtil.error(ex);
                    }
                }
            });
        }
        while (monitor.isLock()) {
            Thread.sleep(1000L);
        }
        if (doExit) {
            System.exit(AfbConstants.ExitCode.NG.code);
        }
    }

    @Override
    public void start() throws Exception {
        boolean isAgreement = this.licenseAgreement();
        if (!isAgreement) {
            AfbApplication.getInstance().exit(AfbConstants.ExitCode.OK.code);
            return;
        }
        if (this.serverMode()) {
            AfbApplication.getInstance().exit(AfbConstants.ExitCode.OK.code);
            return;
        }
        IswgTablePanel.printButtonEnabled = false;
        AfbApplication application = AfbApplication.getInstance();
        String appType = application.properties.getProperty("type");
        String desktopClassName = XsysDesktopPane.class.getName();
        final String method = "show2";
        if (XsysConstants.AppType.CsvDiffex.appType.equals(appType)) {
            desktopClassName = TbcpDesktopPane.class.getName();
        }
        final String desktopClassName2 = desktopClassName;
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    BcReflectUtil.invoke(desktopClassName2, method);
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
    }

    protected boolean licenseAgreement() throws Exception {
        String vPath = "${APP}data/license_agreement.log";
        String rPath = AfbApplication.getInstance().toReal(vPath);
        File agreementLogFile = new File(rPath);
        this.getLogger().debug("agreementLogFile=" + agreementLogFile.getPath());
        if (agreementLogFile.exists()) {
            return true;
        }
        this.monitor.lock();
        vPath = "${APP}\u30bd\u30d5\u30c8\u30a6\u30a7\u30a2\u4f7f\u7528\u8a31\u8afe\u5951\u7d04\u66f8.txt";
        rPath = AfbApplication.getInstance().toReal(vPath);
        File licenseFile = new File(rPath);
        String charsetName = BcEncoder.detectEncoding(licenseFile);
        Charset charset = Charset.forName(charsetName);
        final StringBuilder licenseStrBuf = BcFileUtil.readAsStringBuilder(new File(rPath), charset);
        Platform.setImplicitExit((boolean)false);
        Platform.runLater(() -> System.out.println("Inside Platform.runLater()"));
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    XsysLicensePane licensePane = new XsysLicensePane();
                    licensePane.textArea.setText(licenseStrBuf.toString());
                    XsysClientModule.this.licenseAgreement = licensePane.show(null);
                    XsysClientModule.this.monitor.unLock();
                }
                catch (Exception ex) {
                    XsysClientModule.this.handleException(ex);
                }
            }
        });
        this.monitor.sync();
        if (this.licenseAgreement) {
            StringBuilder agreementLog = new StringBuilder();
            agreementLog.append(BcTimeUtil.toString(BcTimeUtil.createCalendar(), "yyyy/MM/dd HH:mm:ss.SSS"));
            agreementLog.append(BcRuntimeUtil.lineSeparator);
            agreementLog.append(AfbLogUtil.jvmInfo());
            BcFileUtil.makeParent(agreementLogFile);
            BcFileUtil.save(agreementLogFile, agreementLog.toString(), charset);
            return true;
        }
        return false;
    }

    protected int chackUpdate() throws Exception {
        XupdChacker xupdChacker = new XupdChacker();
        int exitCode = xupdChacker.check(this.monitor);
        this.monitor.sync();
        return exitCode;
    }

    protected void advertisement() throws Exception {
        AdvmAdvertisementManager advertisementManager = new AdvmAdvertisementManager();
        advertisementManager.setAdvertisementTask(new AdvmAdvertisementTask());
        try {
            advertisementManager.checkBootConfig(this.monitor);
            this.monitor.sync();
            XdtsConstants.LIMIT_tableCount = -1;
            XdtsConstants.LIMIT_recordCount = -1;
        }
        catch (Exception ex) {
            this.monitor.unLock();
            this.getLogger().error(ex);
        }
    }

    protected void handleException(Throwable throwable) {
        SwgUtil.getExceptionHandler().handleException(throwable, this);
    }

    protected boolean serverMode() throws Exception {
        String[] mainArgs = AfbApplication.getInstance().getMainArguments();
        String tmpStr = BcArgumentUtil.getArgumentValue(mainArgs, ScfConstants.AppArg.server.value);
        boolean isServer = BcBooleanUtil.parseBoolean(tmpStr);
        this.getLogger().info("server=" + isServer);
        if (!isServer) {
            return isServer;
        }
        TbcpCondition condition = TbcpUtil.createCondition();
        tmpStr = BcArgumentUtil.getArgumentValue(mainArgs, XsysConstants.AppArg.if1.value);
        this.getLogger().info("if1=" + tmpStr);
        File file1 = new File(tmpStr);
        tmpStr = BcArgumentUtil.getArgumentValue(mainArgs, XsysConstants.AppArg.if2.value);
        this.getLogger().info("if2=" + tmpStr);
        File file2 = new File(tmpStr);
        tmpStr = BcArgumentUtil.getArgumentValue(mainArgs, XsysConstants.AppArg.of1.value);
        this.getLogger().info("of1=" + tmpStr);
        if (!BcStringUtil.isEmpty(tmpStr)) {
            condition.destFile1 = new File(tmpStr);
        }
        tmpStr = BcArgumentUtil.getArgumentValue(mainArgs, XsysConstants.AppArg.of2.value);
        this.getLogger().info("of1=" + tmpStr);
        if (!BcStringUtil.isEmpty(tmpStr)) {
            condition.destFile2 = new File(tmpStr);
        }
        tmpStr = BcArgumentUtil.getArgumentValue(mainArgs, XsysConstants.AppArg.workbook.value);
        condition.workbook = BcBooleanUtil.parseBoolean(tmpStr);
        this.getLogger().info("condition.workbook=" + condition.workbook);
        tmpStr = BcArgumentUtil.getArgumentValue(mainArgs, XsysConstants.AppArg.comment.value);
        condition.comment = BcBooleanUtil.parseBoolean(tmpStr);
        TbcpCsvComparator csvComparator = new TbcpCsvComparator();
        csvComparator.condition = condition;
        csvComparator.compare(file1, file2);
        return isServer;
    }
}

